MODULE current
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *CURRENT* - CURRENT FIELD.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -----     --------
!      *U*         REAL      U - COMPONENT OF CURRENT (M/S).
!      *V*         REAL      V - COMPONENT OF CURRENT (M/S).
REAL :: u(0:niblc,nblc), v(0:niblc,nblc)
END MODULE current

MODULE cbound
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *CBOUND* COURSE GRID BOUNDARY OUTPUT.
!
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -----     --------
!      *IBOUNC*    REAL      FLAG FOR THE COURSE GRID
!                            = 1; THE RUN INCLUDEDS BOUNDARY POINTS.
!                            ELSE; NO BOUNDARY POINTS.
!      *NBOUNC*    INTEGER   NUMBER OF BOUNDARY POINTS.
!      *IGARC*     INTEGER   INDEX OF BLOCK FOR A BOUNDARY POINT.
!      *IJCAR*     INTEGER   INDEX IN A BLOCK FOR A BOUNDARY POINT.
!      *DLAMAC*    REAL      LONGITUDE INCREMENT OF COARSE GRID (DEG).
!      *DPHIAC*    REAL      LATITUDE INCREMENT OF COARSE GRID (DEG).
!      *AMOWEC*    REAL      MOST EASTERN LONGITUDE FOR THE FINE GRID.
!      *AMOSOC*    REAL      MOST SOUTHERN LONGITUDE FOR THE FINE GRID.
!      *AMOEAC*    REAL      MOST WESTERN LONGITUDE FOR THE FINE GRID.
!      *AMONOC*    REAL      MOST NORTHERN LONGITUDE FOR THE FINE GRID.
!      *BLATC*     REAL      LATITUDE OF COARSE GRID BOUNDARY POINTS.
!      *BLNGC*     REAL      LONGITUDE OF COARSE GRID BOUNDARY POINTS.
!cpk-i4 instead of i8
INTEGER*4 :: ibounc, igarc(nmaxc,nests), ijarc(nmaxc,nests), nbounc(nests)
END MODULE cbound

MODULE cout
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *COUT*  OUTPUT POINTS INDICES AND FLAGS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *NGOUT*     INTEGER   NUMBER OF OUTPUT POINTS.
!      *IGAR*      INTEGER   BLOCK NUMBER OF OUTPUT POINTS.
!      *IJAR*      INTEGER   GRIDPOINT NUMBER OF OUTPUT POINT.
!      *NOUTT*     INTEGER   NUMBER OF OUTPUT TIMES.
!      *IOUTT*     INTEGER   OUTPUT TIMES.
!      *FFLAG*     LOGICAL   FILE  OUTPUT FLAG FOR EACH OUTPUT TYPE.
!      *FFLAG20*   LOGICAL   .TRUE. IF OUTPUT IS WRITTEN TO UNIT IU20.
!      *FFLAG21*   LOGICAL   .TRUE. IF OUTPUT IS WRITTEN TO UNIT IU21.
!      *FFLAG25*   LOGICAL   .TRUE. IF OUTPUT IS WRITTEN TO UNIT IU25.
!      *FFLAG26*   LOGICAL   .TRUE. IF OUTPUT IS WRITTEN TO UNIT IU26.
!      *PFLAG*     LOGICAL   PRINT OUTPUT FLAG FOR EACH OUTPUT TYPE.
!      *PFLAG20*   LOGICAL   .TRUE. IF PRINT OUTPUT OF FIELDS.
!      *PFLAG21*   LOGICAL   .TRUE. IF PRINT OUTPUT OF SWELL FIELDS.
!      *PFLAG25*   LOGICAL   .TRUE. IF PRINT OUTPUT OF SPECTRA.
!      *PFLAG26*   LOGICAL   .TRUE. IF PRINT OUTPUT OF SWELL SPECTRA.
CHARACTER (LEN=12) :: ioutt (moutt)
LOGICAL :: fflag(14), fflag20, fflag21, fflag25, fflag26
LOGICAL :: pflag(14), pflag20, pflag21, pflag25, pflag26
INTEGER*4 :: ngout, igar(moutp), ijar(moutp), noutt  !cpk-i4 instead of i8
END MODULE cout

MODULE fbound
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *FBOUND* FINE GRID BOUNDARY INPUT ORGANISATION.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -----     --------
!      *IBOUNF*    REAL      FLAG FOR THE FINE GRID
!                            = 1; THE RUN INCLUDEDS BOUNDARY POINTS.
!                            ELSE; NO BOUNDARY POINTS.
!      *NBOUNF*    INTEGER   NUMBER OF FINE GRID BOUNDARY POINTS.
!      *IGARF*     INTEGER   BLOCK INDEX FOR A FINE GRID BOUNDARY POINT.
!      *IJARF*     INTEGER   POINT INDEX FOR A FINE GRID BOUNDARY POINT.
!      *IBFL*      INTEGER   INDEX OF LEFT COARSE GRID OUTPUT POINT.
!      *IBFR*      INTEGER   INDEX OF RIGHT COARSE GRID OUTPUT POINT.
!      *BFW*       INTEGER   SPACE INTERPOLATION WEIGHT.
INTEGER :: ibounf, nbounf, ijarf(nmaxf), igarf(nmaxf), ibfl(nmaxf), ibfr(nmaxf)
REAL    :: bfw(nmaxf)
END MODULE fbound

MODULE fredir
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *FREDIR* - FREQUENCY AND DIRECTION GRID.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *FR*        REAL      FREQUENCIES IN HERTZ.
!      *DFIM*      REAL      FREQUENCY INTERVAL*DIRECTION INTERVAL.
!      *GOM*       REAL      DEEP WATER GROUP VELOCITIES (M/S).
!      *C*         REAL      DEEP WATER PHASE VELOCITIES (M/S).
!      *DELTH*     REAL      ANGULAR INCREMENT OF SPECTRUM (RADIANS).
!      *DELTR*     REAL      DELTH TIMES RADIUS OF EARTH (METRES).
!      *TH*        REAL      DIRECTIONS IN RADIANS.
!      *COSTH*     REAL      COS OF DIRECTION.
!      *SINTH*     REAL      SIN OF DIRECTION.
REAL :: fr(nfre), dfim(nfre), gom(nfre), c(nfre), delth, deltr, th(nang)
REAL :: costh(nang), sinth(nang)
END MODULE fredir

MODULE gridpar
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *GRIDPAR*  GENERAL GRID INFORMATION.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *DELPHI*    REAL      GRID INCREMENT FOR LATITUDE (METRES).
!      *DELLAM*    REAL      GRID INCREMENT FOR LONGITUDE AT EQUATOR
!                            IN METRES.
!      *SINPH*     REAL      SIN OF LATITUDE.
!      *COSPH*     REAL      COS OF LATITUDE.
!      *IGL*       INTEGER   NO OF BLOCKS.
!      *IJS*       INTEGER   INDEX OF FIRST POINT OF SECOND LAT.
!      *IJS*       INTEGER   INDEX OF FIRST POINT OF SECOND LAT.
!      *IJL2*      INTEGER   INDEX OF LAST POINT OF SECOND LAT.
!      *IJLS*      INTEGER   INDEX OF FIRST POINT OF LAT BEFORE LAST.
!      *IJL*       INTEGER   INDEX OF LAST POINT OF LAT BEFORE LAST.
!      *IJLT*      INTEGER   TOTAL NUMBER OF GRIDPOINTS IN A BLOCK.
REAL    :: delphi, dellam, sinph(ngy), cosph(ngy)
!cpk-i4 instead of i8
INTEGER*4 :: igl, ijs(nblo), ijl2(nblo), ijls(nblo), ijl(nblo), ijlt(nblo)
END MODULE gridpar

MODULE ice1
USE params
IMPLICIT NONE
SAVE
INTEGER :: icemask(niblo, nblo)
END MODULE ice1

MODULE indnl
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *INDNL* - INDICES AND WEIGHTS USED IN THE COMPUTATION
!                        OF THE NONLINEAR TRANSFER RATE.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   -------
!      *IKP*       INTEGER   FREQUENCY INDEX ARRAY FOR STORING ENERGY
!                            TRANSFER INCREMENTS INTO BINS, WAVE NO. 3.
!      *IKP1*      INTEGER   IKP+1.
!      *IKM*       INTEGER   FREQUENCY INDEX ARRAY FOR STORING ENERGY
!                            TRANSFER INCREMENTS INTO BINS, WAVE NO. 4.
!      *IKM1*      INTEGER   IKM+1
!      *K1W*       INTEGER   ANGULAR INDEX ARRAY FOR STORING ENERGY
!                            TRANSFER INCREMENTS INTO BINS, WAVE NO. 3.
!      *K11W*      INTEGER   K1W(.,1)-1, K1W(.,2)+1.
!      *K2W*       INTEGER   ANGULAR INDEX ARRAY FOR STORING ENERGY
!                            TRANSFER INCREMENTS INTO BINS, WAVE NO. 4.
!      *K21W*      INTEGER   K2W(.,1)+1, K2W(.,2)-1.
!      *AF11*      REAL      WEIGHTS FOR DISCRETE APPROXIMATION OF NONL
!                            TRANSFER (AT PRESENT ONE TERM ONLY SET TO
!                            3000). MULTIPLIED BY FREQUENCIES **11.
!      *FKLAP*     REAL      WEIGHT IN FREQUENCY GRID FOR INTERPOLATION,
!                            WAVE NO. 3 ("1+LAMBDA" TERM).
!      *FKLAP1*    REAL      1-FKLAP.
!      *FKLAM*     REAL      WEIGHT IN FREQUENCY GRID FOR INTERPOLATION,
!                            WAVE NO. 4 ("1-LAMBDA" TERM).
!      *ACL1*      REAL      WEIGHT IN ANGULAR GRID FOR INTERPOLATION,
!                            WAVE NO. 3 ("1+LAMBDA" TERM).
!      *ACL2*      REAL      WEIGHT IN ANGULAR GRID FOR INTERPOLATION,
!                            WAVE NO. 4 ("1-LAMBDA" TERM).
!      *CL11*      REAL      1.-ACL1.
!      *CL21*      REAL      1.-ACL2.
!      *DAL1*      REAL      1./ACL1.
!      *DAL2*      REAL      1./ACL2.
!      *FRH*       REAL      TAIL FREQUENCY RATION **5
!cpk-i4 instead of i8
INTEGER*4 :: ikp(nfre+4), ikp1(nfre+4), ikm(nfre+4) , ikm1(nfre+4),           &
           k1w(nang,2), k2w(nang,2) , k11w(nang,2), k21w(nang,2)
REAL    :: af11(nfre+4), fklap(nfre+4), fklap1(nfre+4), fklam(nfre+4),      &
           fklam1(nfre+4), acl1, acl2, cl11, cl21, dal1, dal2, frh(30)
END MODULE indnl

MODULE intpar
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *INTPAR*  GRIDDED INTEGRATED PARAMETER TOTAL SPECTRUM.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *WHGTTG*    REAL      GRIDDED MEAN ENERGY (M*M) CHANGED TO
!                            WAVE HEIGHT (M) IN SUB OUTINT.
!      *WDIRTG*    REAL      GRIDDED MEAN DIRECTION (RAD) CHANGED TO
!                            DEGREE IN SUB OUTINT.
!      *WPKFTG*    REAL      GRIDDED PEAK FREQUENCY (HZ).
!      *WMNFTG*    REAL      GRIDDED MEAN FREQUENCY (HZ).
!      *USTARG*    REAL      GRIDDED FRICTION VELOCITY (M/S).
!      *UDIRG*     REAL      GRIDDED WIND DIRECTION (RAD) CHANGED TO
!                            DEGREE IN SUB OUTINT.
!      *TAUWG*     REAL      GRIDDED NORMALISED WAVE STRESS.
!      *CDG*       REAL      GRIDDED DRAG COEFFICENT.
!
REAL :: whgttg(ngx,ngy), wdirtg(ngx,ngy), wpkftg(ngx,ngy),    &
        wmnftg(ngx,ngy), ustarg(ngx,ngy), udirg(ngx,ngy),     &
        tauwg(ngx,ngy) , cdg(ngx,ngy),tauwghf_x(ngx,ngy),      &
        tauwghf_y(ngx,ngy),tauwg_x(ngx,ngy),tauwg_y(ngx,ngy), &
        betag(ngx,ngy)
END MODULE intpar

MODULE intspar
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *INTSPAR*  GRIDDED INTEGRATED SWELL PARAMETERS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *WHGTSG*    REAL      GRIDDED MEAN SWELL ENERGY (M*M) CHANGED TO
!                            WAVE HEIGHT (M) IN SUB OUTINT.
!      *WDIRSG*    REAL      GRIDDED MEAN SWELL DIRECTION (RAD) CHANGED
!                            TO DEGREE IN SUB OUTINT.
!      *WDIRWG*    REAL      GRIDDED MEAN SEA   DIRECTION (RAD) CHANGED
!                            TO DEGREE IN SUB OUTINT.
!      *WMNFSG*    REAL      GRIDDED MEAN SWELL FREQUENCY (HZ).
REAL :: whgtsg(ngx,ngy), wdirsg(ngx,ngy), wdirwg(ngx,ngy), wmnfsg(ngx,ngy)
END MODULE intspar

MODULE map
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *MAP*  LON/LAT INDEX OF EACH SEA POINT.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *IXLG*      INTEGER   LONG. GRID INDEX.
!      *KXLT*      INTEGER   LAT. GRID INDEX.
!      *NX*        INTEGER   NUMBER OF LONGITUDES IN GRID.
!      *NY*        INTEGER   NUMBER OF LATITUDES  IN GRID.
!      *IPER*      INTEGER   = 1 IF GRID IS PERIODIC.
!      *AMOWEP*    REAL      MOST WESTERN LONGITUDE IN GRID (DEGREE).
!      *AMOSOP*    REAL      MOST SOUTHERN LATITUDE IN GRID (DEGREE).
!      *AMOEAP*    REAL      MOST EASTERN LONGITUDE IN GRID (DEGREE).
!      *AMONOP*    REAL      MOST NORTHERN LATITUDE IN GRID (DEGREE).
!      *XDELLA*    REAL      GRID INCREMENT FOR LATITUDE (DEGREE).
!      *XDELLO*    REAL      GRID INCREMENT FOR LONGITUDE (DEGREE).
!cpk-i4 instead of i8
INTEGER*4 :: ixlg(niblo,nblo), kxlt(niblo,nblo), nx, ny, iper
REAL    :: amowep, amosop, amoeap, amonop, xdella, xdello
END MODULE map

MODULE meanpa
USE params
IMPLICIT NONE
SAVE
!*    *COMMON*  *MEANPA* - INTEGRATED PARAMETERS OF A BLOCK.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *EMEAN*     REAL      TOTAL ENERGY.
!      *FMEAN*     REAL      MEAN FREQUENCY (1./MEAN PERIOD).
!      *THQ*       REAL      MEAN WAVE DIRECTION IN RADIANS.
!      *AKMEAN*    REAL      MEAN WAVE NUMBER.
REAL :: emean(niblo), fmean(niblo), thq(niblo), akmean(niblo),wdiss(niblo)
END MODULE meanpa

MODULE ndtf
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *NDTF* - MULTIPLE NUMBER OF MINIMUM DT (IDTMIN)
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *NDTADF*    INTEGER   MULTIPLE NUMBER OF MINIMUM (1ST FREQUENCY)
!                            DT (IDTMIN) AT EVERY FREQUENCIES
INTEGER :: ndtadf(nfre), idtmin, idelfd, ifdtp
END MODULE ndtf

MODULE over
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *OVER* - INTERMEDIATE STORAGE OF LATITUDES.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *OV*        REAL     STORES SECOND TO LAST LATITUDE SPECTRA
!                           FOR FIRST LATITUDE OF NEXT BLOCK.
REAL :: ov(nover,nang,nfre)
END MODULE over

MODULE propfr
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *PROPFR*  FRACTIONS OF IDELPRO FOR UNSTABLE POINTS
INTEGER :: ipropfr(niblo,nblo)
REAL    :: grdfr(ngx,ngy)
END MODULE propfr

MODULE refdot
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *REFDOT* - DEPTH AND CURRENT PART OF THETA DOT.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *THDD*      REAL      DEPTH GRADIENT PART OF THETA DOT.
!      *THDC*      REAL      CURRENT GRADIENT PART OF THETA DOT.
REAL :: thdd(nibld,nang), thdc(niblc,nang)
END MODULE refdot

MODULE refrsource
USE params
IMPLICIT NONE
SAVE
REAL :: sl_refr(0:niblo,nang,nfre)
END MODULE refrsource

MODULE shallow
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *SHALLOW*   SHALLOW WATER TABLES.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *NDEPTH*    INTEGER   LENGTH OF SHALLOW WATER TABLES.
!      *DEPTH*     REAL      WATER DEPTH IN METRES.
!      *DEPTHA*    REAL      MINIMUM DEPTH FOR TABLES (METRES).
!      *DEPTHD*    REAL      DEPTH INCREMENT (METRES).
!      *TCGOND*    REAL      SHALLOW WATER GROUP VELOCITY TABLE.
!      *TFAK*      REAL      WAVE NUMBER TABLE.
!      *TSIHKD*    REAL      TABLE FOR OMEGA/SINH(2KD).
!      *INDEP*     INTEGER   DEPTH INDEX FOR A BLOCK.
!posdpmin begin
INTEGER,PARAMETER :: ndepth = 63
!posdpmin end
REAL    :: depth(niblo,nblo)  , deptha, depthd
REAL    :: tcgond(ndepth,nfre), tfak(ndepth,nfre)
REAL    :: tsihkd(ndepth,nfre)
INTEGER :: indep(niblo)
END MODULE shallow

MODULE source
USE params
IMPLICIT NONE
SAVE
!*    *COMMON*  *SOURCE* - SOURCE FUNCTION AND TAIL FLAG.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      FOR SOURCE FUNCTION INTEGRATION:
!      *SL*        REAL      TOTAL SOURCE FUNCTION ARRAY.
!      *FCONST*    REAL      = 1 FOR PROGNOSTIC FREQUENCY BANDS.
!                            = 0 FOR DIAGNOSTIC FREQUENCY BANDS.
!REFRA
!      FOR PROPAGATION WITH REFRACTION:
!      *SL*        REAL     SIGMA DOT TERM.
!      *FCONST*    REAL     SIGMA/SINH(2KD).
!REFRA
REAL :: sl(0:niblo,nang,nfre), fconst(niblo,nfre)
END MODULE source

MODULE spe
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *SPE1* - A BLOCK OF SPECTRA.
!*    *COMMON* *SPE2* - A BLOCK OF SPECTRA.
!*    *COMMON* *SPE3* - A BLOCK OF SPECTRA.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!       *FL1*      REAL      2-D SPECTRUM FOR EACH GRID POINT OR 2-D
!                            SWELL DISTRIBUTION.
!       *FL2*      REAL      2-D SPECTRUM FOR EACH GRID POINT OR 2-D
!                            SWELL DISTRIBUTION.
!                            FL1,FL2 ARE SWAPPED AFTER EACH BLOCK,
!                            AT TIME T SPECTRA ARE READ INTO FL1
!                            FOR BLOCK IG+1 WHILE INTEGRATION IS DONE
!                            FOR BLOCK IG WITH FL2 .
!                            WHEN NEW SPECTRA HAS BEEN COMPUTED THE 2-
!                            SWELL DISTRIBUTION IS STORED IN FL2 FOR
!                            BLOCK IG WHILE IT WILL BE STORED IN FL1
!                            FOR BLOCK IG+1 (SAVES I/O TIME AND MEMORY
!                            SIZE).
!       *FL3*      REAL      NEW SPECTRA AFTER TIME STEP.
REAL :: fl1(0:niblo,nang,nfre)
REAL :: fl2(0:nibl1,nang,nfre)
REAL :: fl3(0:niblo,nang,nfre)
REAL :: diss(0:niblo,nang,nfre)
END MODULE spe

MODULE stokesblock
USE params
IMPLICIT NONE
SAVE
REAL :: ustokes(ngx,ngy), vstokes(ngx,ngy), rough(ngx,ngy),wdiss_gridded(ngx,ngy)
END MODULE stokesblock

MODULE swell
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *SWELL* - SEA AND SWELL PARAMETERS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *ESWELL*    REAL      TOTAL SWELL ENERGY
!      *FSWELL*    REAL      MEAN SWELL FREQUENCY
!      *THSWELL*   REAL      MEAN SWELL DIRECTION
!      *THWISEA*   REAL      MEAN WIND INTERACTING SEA DIRECTION
REAL :: eswell(niblo), fswell(niblo), thswell(niblo), thwisea(niblo)
END MODULE swell

MODULE ubuf
USE params
IMPLICIT NONE
SAVE
!*    *COMMON* *UBUF*  GRID POINT DEPENDENT CONSTANTS
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *KLAT*      REAL      INDEX OF GRIDPOINT SOUTH AND NORTH
!                            LANDPOINTS ARE MARKED BY ZERO.
!      *KLON*      REAL      INDEX OF GRIDPOINT WEST AND EAST
!                            LANDPOINTS ARE MARKED BY ZERO.
INTEGER*4 :: klat(niblo,6), klon(niblo,6) !cpk-i4 instead of i8
END MODULE ubuf

MODULE units
USE params
IMPLICIT NONE
SAVE
!*    *COMMON*  *UNITS* - INPUT / OUTPUT UNITS.
!        *IU02*  - LOGICAL UNIT FOR INPUT OF BOUDARY VALUES FROM A
!                  PREVIOUS COARSE GRID IF THIS A FINE GRID RUN.
!        *IU08*  - LOGICAL UNIT FOR INPUT OF COMMON UBUF
!                  (OUTPUT OF PREPROC).
!        *IU11*  - LOGICAL UNIT FOR INPUT OF SPECTRA AT ALL GRID
!                  POINTS. EACH PROPAGATION TIMESTEP THE FILES
!                  CONNECTED TO IU11 AND IU12 ARE INTERCHANGED.
!        *IU12*  - LOGICAL UNIT FOR OUTPUT (SEE IU11).
!        *IU13*  - LOGICAL UNIT FOR INPUT OF SPECTRA ON LAST LATUTUDE
!                  OF A BLOCK. SPECTRA ARE SAVED FROM THE SECOND
!                  LATITUDE OF THE NEXT BLOCK.
!                  EACH PROPAGATION TIMESTEP THE FILES CONNECTED TO
!                  IU14 AND IU13 ARE INTERCHANGED.
!        *IU14*  - LOGICAL UNIT FOR OUTPUT (SEE IU13).
!        *IU15*  - LOGICAL UNIT FOR OUTPUT OF LAST WINDFIELDS FOR
!                  RESTART.
!        *IU16*  - LOGICAL UNIT FOR INPUT/OUTPUT OF COMMON REFDOT
!                  (SEE SUBS PROPDOT AND DOTDC)
!        *IU17*  - LOGICAL UNIT FOR BLOCK WINDINPUT (SEE SUB. IMPLSCH)
!        *IU18*  - LOGICAL UNIT FOR BLOCK WINDINPUT (SEE SUB. IMPLSCH)
!        *IU19*  - LOGICAL UNIT FOR OUTPUT OF OF BOUNDARY VALUES IF
!                  THIS IS A FINE GRID RUN.
!        *IU20*  - LOGICAL UNIT FOR OUTPUT OF INTEGRATED PARAMETERS
!                  OF THE TOTAL SPECTRUM.
!        *IU21*  - LOGICAL UNIT FOR OUTPUT OF INTEGRATED PARAMETERS
!                  OF SWELL AND WIND WAVES.
!        *IU25*  - LOGICAL UNIT FOR OUTPUT OF SPECTRA AT CERTAIN
!                  GRID POINTS.
!        *IU26*  - LOGICAL UNIT FOR OUTPUT OF SWELL SPECTRA AT
!                  CERTAIN GRID POINTS.
!        *IUVELO*- OUTPUT UNIT FOR BLOCKED WIND FIELDS.
!        *IUSCR* - SCRATCH UNITS FOR WIND PROCESSING.
INTEGER ::  iu02, iu08, iu11, iu12, iu13, iu14, iu15, iu16, iu17, iu18, &
            iu19, iu20, iu21, iu25, iu26, iuvelo, iuscr(nblo)
END MODULE units

MODULE wind
USE params
IMPLICIT NONE
SAVE
!*    *COMMON*  *WIND* - VARIABLES USED FOR WIND COMPUTATIONS.
!*     VARIABLE.   TYPE.     PURPOSE.
!      ---------   -------   --------
!      *IDA*       CHAR*12   DATE OF LAST WINDFIELD READ IN.
!      *IDATEWO*   CHAR*12   DATE OF NEXT WIND FIELD TO BE READ.
!      *IDAWIFL*   CHAR*12   DATE OF NEXT WIND FILE NAME.
!      *IDATEFL*   CHAR*12   DATE OF NEXT WIND FILE TO BE ACCESSED.
!      *IIG*       INTEGER   BLOCK NUMBER OF LAST WIND FIELD READ IN
!      *U10NEW*    REAL      NEW WIND SPEED IN M/S.
!      *U10OLD*    REAL      INTERMEDIATE STORAGE OF MODULUS OF WIND
!                            VELOCITY.
!      *THWNEW*    REAL      WIND DIRECTION IN RADIANS IN OCEANOGRAPHIC
!                            NOTATION (POINTING ANGLE OF WIND VECTOR,
!                            CLOCKWISE FROM NORTH).
!      *THWOLD*    REAL      INTERMEDIATE STORAGE OF ANGLE (RADIANS) OF
!                            WIND VELOCITY.
!      *USNEW*     REAL      NEW FRICTION VELOCITY IN M/S.
!      *USOLD*     REAL      INTERMEDIATE STORAGE OF MODULUS OF FRICTION
!                            VELOCITY.
!      *Z0NEW*     REAL      ROUGHNESS LENGTH IN M.
!      *Z0OLD*     REAL      INTERMEDIATE STORAGE OF ROUGHNESS LENGTH IN
!                            M.
!      *TAUW*      REAL      WAVE STRESS IN (M/S)**2
CHARACTER (LEN=12) :: ida, idawifl, idatewo, idatefl
CHARACTER :: cbfile * 3 !AUTO ISOS DEN ANHKEI EDO.SE KAPOIO ARXEIO YPHRXE OMOS...
REAL :: u10new(niblo), u10old(niblo,nblo)
REAL :: thwnew(niblo), thwold(niblo,nblo)
REAL :: usnew(niblo) , usold(niblo,nblo)
REAL :: z0new(niblo) , z0old(niblo,nblo)
REAL :: tauw(niblo,nblo),tauwhf_x(niblo,nblo) ,tauwhf_y(niblo,nblo)
REAL :: tauw_x(niblo,nblo) ,tauw_y(niblo,nblo)
INTEGER :: iig
END MODULE wind
