INTEGER FUNCTION isamax (n, sx, incx)  
!     finds the index of element having max. absolute value.
!     jack dongarra, linpack, 3/11/78.
!     modified 3/93 to return if incx .le. 0.
!     modified 12/3/93, array(1) declarations changed to array(*)
IMPLICIT NONE

REAL   , INTENT(IN) :: sx(*)
INTEGER, INTENT(IN) :: n, incx
REAL    :: smax
INTEGER :: i, ix

isamax = 0
IF( n .LT. 1  .OR.  incx .LE. 0 ) RETURN
isamax = 1
IF( n    .EQ. 1 )   RETURN
IF( incx .EQ. 1 )   GOTO 20

!        code for increment not equal to 1
ix = 1
smax = ABS(sx (1) )
ix = ix + incx
DO i = 2, n
   IF(ABS(sx(ix) ) .LE. smax ) GOTO 5
   isamax = i
   smax = ABS(sx (ix) )
   5 ix = ix + incx
ENDDO
RETURN

!        code for increment equal to 1
20 smax = abs (sx (1) )
do 30 i = 2, n
   IF( ABS(sx(i) ) .LE. smax ) GOTO 30
   isamax = i
   smax = abs (sx (i) )
30 ENDDO  

RETURN  
END FUNCTION isamax
