SUBROUTINE intspec (ml, kl, fr, del12, del1l, f1, fmean1, emean1, thetm1,&
                    f2, fmean2, emean2, thetm2, fl, fmean, emean, thetm  )
! ----------------------------------------------------------------------
!**** *INTSPEC* -  INTERPOLATION OF SPECTRA.
!     SUSANNE HASSELMANN  MPI        JUNE 1990.
!     H. GUNTHER          GKSS/ECMWF JAN. 1991   MODIFIED FOR CYCLE_4
!*    PURPOSE.
!     --------
!       INTERPOLATION OF SPECTRA.
!**   INTERFACE.
!     ----------
!       *CALL* *INTSPEC (NFRE, NANG, ML, KL, FR, DEL12, DEL1L,
!                        F1, FMEAN1, EMEAN1, THETM1,
!                        F2, FMEAN2, EMEAN2, THETM2,
!                        FL, FMEAN,  EMEAN,  THETM )*
!         *NFRE*   - FREQUENCY DIMENSION OF SPECTRA.
!         *NANG*   - DIRECTION DIMENSION OF SPECTRA.
!         *ML*     - NUMBER OF FREQUENCIES.
!         *KL*     - NUMBER OF DIRECTIONS.
!         *FR*     - FREQUENCY ARRAY.
!         *DEL12*  - DISTANCE SPECTRUM 2 - SPECTRUM 1.
!         *DEL1L*  - DISTANCE SPECTRUM L - SPECTRUM 1.
!         *F1*     - INPUT SPECTRUM 1.
!         *FMEAN1* - INPUT MEAN FREQUENCY OF F1.
!         *EMEAN1* - INPUT MEAN ENERGY OF F1.
!         *THETM1* - INPUT MEAN DIRECTION OF F1.
!         *F2*     - INPUT SPECTRUM 2.
!         *FMEAN2* - INPUT MEAN FREQUENCY OF F2.
!         *EMEAN2* - INPUT MEAN ENERGY OF F2.
!         *THETM2* - INPUT MEAN DIRECTION OF F2.
!         *FL*     - INTEPOLATED SPECTRUM.
!         *FMEAN*  - INTEPOLATED MEAN FREQUENCY.
!         *EMEAN*  - INTEPOLATED MEAN ENERGY.
!         *THETM*  - INTEPOLATED MEAN DIRECTION.
!     METHOD.
!     -------
!       ROTATE SPECTRA ACCORDING TO MEAN OF MEAN ANGLES, TRANSFORM
!       FREQUENCIES ACCORDING TO MEAN OF MEAN FREQUENCIES ,ADJUST ENERGY
!       ACCORDCING TO MEAN OF TOTAL ENERGY AND INTERPOLATE RESULTING
!       SPECTRA.
!     EXTERNALS.
!     ----------
!       *ROTSPEC*   - ROTATES SPECTRUM.
!       *STRSPEC*   - TRANSFORM FREQUENCIES.
!     REFERENCES.
!     -----------
!       K.HASSELMANN, 1990,
!          INTERPOLATION OF WAVE SPECTRA. WAM NOTE 6/6/90.
! ----------------------------------------------------------------------
use params
implicit none

INTEGER, INTENT(IN) :: ml, kl
REAL   , INTENT(IN) :: fr(nfre), f1(nang,nfre), f2(nang,nfre)
REAL   , INTENT(IN) :: del12, del1l, fmean1, emean1, thetm1, fmean2, emean2, thetm2
REAL   , INTENT(OUT):: fl(nang, nfre)
REAL   , INTENT(OUT):: fmean, emean, thetm
INCLUDE 'globals.h'
REAL    :: F3(NANG,NFRE), F4(NANG,NFRE)
REAL    :: CM, CM1, CM2, SM, SM1, SM2, GW1, GW2, EMEANH,RTHET1, GAMMA, RTHET2
INTEGER :: K, M
! ----------------------------------------------------------------------
!*    1. INTERPOLATION WEIGHTS.
!        ----------------------
 1000 CONTINUE  

GW1 = (DEL12 - DEL1L) / DEL12  
GW2 = DEL1L / DEL12  
! ----------------------------------------------------------------------
!*    2. INTERPOLATE MEAN VALUES.
!        ------------------------
 2000 CONTINUE  

IF (EMEAN1.EQ.0.) THEN  
!*    2.1 ENERGY OF SPECTRUM 1 IS ZERO.
!         -----------------------------
   EMEAN = GW2 * EMEAN2  
   FMEAN = FMEAN2  
   THETM = THETM2  
   DO M = 1, ML  
      DO K = 1, KL  
         FL (K, M) = GW2 * F2 (K, M)  
      END DO  
   END DO  
   RETURN  
ELSEIF (EMEAN2.EQ.0.) THEN  
!*    2.2 ENERGY OF SPECTRUM 2 IS ZERO.
!         -----------------------------
   EMEAN = GW1 * EMEAN1  
   FMEAN = FMEAN1  
   THETM = THETM1  
   DO M = 1, ML  
      DO K = 1, KL  
         FL (K, M) = GW1 * F1 (K, M)  
      END DO  
   END DO  
   RETURN  
ENDIF  
!*    2.3 ENERGY BOTH SPECTRUM IS GT ZERO.
!         -------------------------------
EMEAN = GW1 * EMEAN1 + GW2 * EMEAN2  
FMEAN = GW1 * FMEAN1 + GW2 * FMEAN2  
CM1 = COS (THETM1)  
CM2 = COS (THETM2)  
SM1 = SIN (THETM1)  
SM2 = SIN (THETM2)  
CM = GW1 * CM1 + GW2 * CM2  
SM = GW1 * SM1 + GW2 * SM2  
THETM = ATAN2 (SM, CM)  
THETM = MOD (THETM + ZPI, ZPI)  
! ----------------------------------------------------------------------
!*    3. SPECTRUM 1.
!        -----------
 3000 CONTINUE  
!*    3.1 ROTATE.
!         -------
RTHET1 = THETM - THETM1  
CALL ROTSPEC (NFRE, NANG, ML, KL, F1, F3, RTHET1)  
  160 CONTINUE  
!*    3.2 STRETCH.
!         --------
GAMMA = FMEAN1 / FMEAN  
CALL STRSPEC (ML, KL, FR, F3, GAMMA)  
!*    3.3 ADJUST ENERGY.
!         --------------
EMEANH = EMEAN / EMEAN1  
DO M = 1, ML  
   DO K = 1, KL  
      F3 (K, M) = F3 (K, M) * EMEANH  
   END DO  
END DO  
! ----------------------------------------------------------------------
!*    4. SPECTRUM 2.
!        -----------
 4000 CONTINUE  
!*    4.1 ROTATE.
!         -------
RTHET2 = THETM - THETM2  
CALL ROTSPEC (NFRE, NANG, ML, KL, F2, F4, RTHET2)  
!*    4.2 STRETCH.
!         --------
GAMMA = FMEAN2 / FMEAN  
CALL STRSPEC (ML, KL, FR, F3, GAMMA)  
!*    4.3 ADJUST ENERGY.
!         --------------
EMEANH = EMEAN / EMEAN2  
DO M = 1, ML  
   DO K = 1, KL  
      F4 (K, M) = F4 (K, M) * EMEANH  
   END DO  
END DO  
! ----------------------------------------------------------------------
!*    5. LINEAR INTERPOLATION OF NEW SPECTRA.
!        ------------------------------------
 5000 CONTINUE  
DO M = 1, ML  
   DO K = 1, KL  
      FL (K, M) = GW1 * F3 (K, M) + GW2 * F4 (K, M)  
   END DO  
END DO  

RETURN  
END SUBROUTINE intspec
