SUBROUTINE initmdl (nadv, nsubadv)
!     SUBROUTINE INITMDL (NADV)
! ----------------------------------------------------------------------
!**** *INITMDL* - INITIALIZES THE WAM MODEL.
!
!     L. ZAMBRESKY   GKSS/ECMWF    JULY 1988
!
!     MODIFIED BY:   H. GUNTHER    NOVEMBER 1989
!SHALLOW
!          DIFFERENCES FOR SHALLOW WATER RUNS TO DEEP WATER RUNS
!          ARE ENCLOSED IN COMMENT LINES : 'CSHALLOW'.
!SHALLOW
!NEST
!          DIFFERENCES FOR NESTED GRID RUNS TO NORMAL RUNS
!          ARE ENCLOSED IN COMMENT LINES : 'CNEST'.
!NEST
!REFRA
!          DIFFERENCES FOR REFRACTION RUNS TO NORMAL RUNS
!          ARE ENCLOSED IN COMMENT LINES : 'CREFRA'.
!REFRA
!*    PURPOSE.
!     --------
!       INITIALIZE THE WAM MODEL.
!**   INTERFACE.
!     ----------
!          ---- FORMAL PARAMETERS ----
!       *CALL* *INITMDL (NADV)*
!         *NADV*     INTEGER   NUMBER OF ADVECTION ITERATIONS
!                              PER CALL OF WAMODEL, OUTPUT PARAMETER.
!         *NSUBADV*  INTEGER   NUMBER OF SUBADVECTION ITERATIONS
!                              PER IDELPRO, OUTPUT PARAMETER.
!          ---- INPUT/OUTPUT UNITS ---
!          THE NAMES ARE DEFINED IN SECTION 1. OF THIS PROGRAM,
!          IF IT IS NOT MENTIONED OTHERWISE.
!           *IU01*   - INPUT  UNIT UNBLOCKED WIND FILE.
!                      (SEE SUB READWND).
!           *IU02*   - INPUT  UNIT OF BOUDARY VALUES FROM A PREVIOUS
!                      COARSE GRID IF THIS A FINE GRID RUN.
!                      THIS FILE IS DYNAMICALLY ASSIGNED FILEID = 'FBI'
!                      (OUTPUT OF BOUINT).
!           *IU05*   - USER INPUT UNIT.
!           *IU06*   - PRINTER OUTPUT.
!           *IU07*   - INPUT  UNIT OF PRECOMPUTED COMMON BLOCKS.
!                      (OUTPUT OF PREPROC).
!           *IU08*   - INPUT  UNIT OF COMMON UBUF.
!                      (OUTPUT OF PREPROC).
!NEST
!           *IU09*   - INPUT  UNIT COMMON CBOUND (OUTPUT OF PREPROC).
!           *IU10*   - INPUT  UNIT COMMON FBOUND (OUTPUT OF PREPROC).
!NEST
!           *IU11*   - INPUT UNIT OF SPECTRA AT ALL GRID POINTS.
!                      EACH PROPAGATION STEP THE FILES CONNECTED
!                      TO IU11 AND IU12 ARE INTERCHANGED.
!           *IU12*   - OUTPUT UNIT BLOCKS OF SPECTRA (SEE IU11).
!           *IU13*   - INPUT UNIT OF SPECTRA ON LAST LATITUDE
!                      OF A BLOCK. SPECTRA ARE SAVED FROM THE
!                      SECOND LATITUDE OF NEXT BLOCK.
!                      EACH PROPAGATION STEP THE FILES CONNECTED
!                      TO IU13 AND IU14 ARE INTERCHANGED.
!           *IU14*   - OUTPUT UNIT SECOND LATITUDES (SEE IU13).
!           *IU15*   - OUTPUT UNIT LAST WINDFIELDS.
!REFRA
!           *IU16*   - INPUT/OUTPUT UNIT OF COMMON REFDOT.
!REFRA
!           *IU17*   - INPUT  UNIT OF BLOCKED WINDS.
!                      THIS FILE IS DYNAMICALLY ASSIGNED IN SUB
!                      IMPLSCH. SEE SUB CREWFN TOO.
!           *IU18*   - INPUT  UNIT OF BLOCKED WINDS.
!                      THIS FILE IS DYNAMICALLY ASSIGNED IN SUB
!                      IMPLSCH. SEE SUB CREWFN TOO.
!NEST
!           *IU19*   - OUTPUT UNIT OF BOUNDARY VALUES IF
!                      THIS IS A FINE GRID RUN.
!                      THIS FILE IS DYNAMICALLY ASSIGNED FILEID = 'CBO'
!NEST
!           *IU20*   - OUTPUT UNIT OF INTEGRATED PARAMETERS
!                      OF THE TOTAL SPECTRUM.
!                      THIS FILE IS DYNAMICALLY ASSIGNED FILEID = 'MAP'
!           *IU21*   - OUTPUT UNIT OF INTEGRATED PARAMETERS
!                      OF SWELL AND WIND WAVES.
!                      THIS FILE IS DYNAMICALLY ASSIGNED FILEID = 'SWE'
!           *IU25*   - OUTPUT UNIT OF SPECTRA AT CERTAIN GRID POINTS.
!                      THIS FILE IS DYNAMICALLY ASSIGNED FILEID = 'SPE'
!           *IU26*   - OUTPUT UNIT OF SWELL SPECTRA AT CERTAIN POINTS.
!                      THIS FILE IS DYNAMICALLY ASSIGNED FILEID = 'SWS'
!           *IUSCR*  - SCRATCH UNITS FOR WIND PROCESSING.
!           *IUVELO* - OUTPUT UNIT OF BLOCKED WINDFILEDS.
!                      FILES ARE DYNAMICALLY ASSIGNED IN SUB
!                      NOTIM OR TIMIN. SEE SUB CREWFN TOO.
!          FOR A START THE RESTART FILES WILL DYNAMICALLY BE ASSIGNED
!          AND COPIED TO THE *OUTPUT* UNITS (IU12, IU14, IU15).
!          IF IT IS REQUESTED TO SAVE RESTART FILES THESE WILL BE COPIED
!          IN REGULAR INTERVALS FROM THE UNIT ALIAS FILES OF IU11 OR
!          IU12, IU13 OR IU14, AND IU15 TO THE PREMANENT RESTART FILES.
!          FOR DETAILS OF THE FILE NAMES SEE SUB GSFILE.
!
!          THE PROGRAM USES OPEN TO ASSIGN FILES WHICH HAVE A FILEID
!          (IU02,IU19,IU20,IU21,IU25,IU26). FOR DETAILS OF THE
!          FILE NAME CONVENTION SEE SUB OPENFIL.
!
!          SUB NOTIM OR TIMIN OPENS FILES AND ASSIGNS THEM TO UNIT
!          IUVELO FOR THE BLOCKED WINDS. THESE FILES ARE READ AND
!          DELETED IN SUB IMPLSCH (IU17 AND IU18). THE FILE NAMES
!          ARE CREATED IN SUB CREWFN.
!
!          THE FILE HANDLING SUBS OPENFIL AND GSFILE ARE COMPUTER
!          DEPENDENT AND MAY BE ADOPTED BY THE USER.
!          IF A FRONT /END SYSTEM IS USED THE CODE BETWEEN 'CCMFA'
!          AND 'CCMFE' HAS TO BE COMMENTED.
!
!          THE PROGRAM CLOSES AND DELETES ALL WORK FILES.
!
!          ALL PARAMETERS HAVE TO BE THE VALUES GIVEN AT THE END
!          OF THE PREPROC OUTPUT IN COLUMN 'REQUIRED'.
!     METHOD.
!     -------
!          THIS ROUTINE INITIALISES THE WAVEMODEL:
!            -  DEFINES THE UNITS FOR INPUT/OUTPUT,
!            -  READS THE USER INPUT FILE,
!            -  INITIALIZES SOME MODEL CONSTANTS,
!            -  GETS THE RECOVERY FILES,
!            -  READS THE COMMON BLOCKS PRECOMPUTED BY PROG PREPROC,
!            -  DOES SOME GENERAL BOOKEEPING REGARDING
!               DATES, INTEGRATION TIME STEPS AND OUTPUT TIME STEPS.
!            -  READ COMMON UBUF AND SPECTRA IF ONE BLOCK VERSION.
!REFRA
!            -  PRECOMPUTES AND WRITES TO IU16 REFRACTION TERMS.
!REFRA
!            -  OPENS THE FIRST RESULT FILES.
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!       *DIFDATE*   - COMPUTES A TIME DIFFERENCE.
!       *GETREST*   - GETS RESTART FILES.
!REFRA
!       *GRADI*     - COMPUTES DEPTH AND CURRENT GRADIENTS.
!REFRA
!       *GSFILE*    - ROUTINE TO DYNAMICALLY FETCH OR DISPOSE FILES.
!       *HEADBC*    - WRITE BOUNDARY OUTPUT FILE HEADER.
!       *iecf_len*  - LENGTH OF A CHARACTER ARRAY.
!       *INCDATE*   - UPDATE DATE TIME GROUP.
!       *OPENFIL*   - OPENS A FILE.
!REFRA
!       *PROPDOT*   - PRECOMPUTE REFRACTION.
!REFRA
!NEST
!       *READBOU*   - READS PREPROC BOUNDARY FILES.
!NEST
!       *READPRE*   - READS PREPROC OUTPUT.
!       *USERIN*    - READS USER INPUT.
!     REFERENCE
!     ---------
!          A MORE DETAILED  DISCUSSION MAY BE FOUND IN SUB WAMODEL.
! ----------------------------------------------------------------------
use params
!NEST
use cbound
!NEST
use coupl
use cout
!REFRA
use current
!REFRA
!NEST
use fbound
!NEST
use fredir
use gridpar
use indnl
use map
use ndtf
use over
!REFRA
use refdot
!REFRA
use shallow
use spe
use stat
use table
use testo
use text
use units
use ubuf
use wind
implicit none

INTEGER, INTENT(OUT) :: nadv, nsubadv
INTEGER:: IDEPTHU, IDELREC, IDELWH, IU05, IU07, IU09, IU10
INTEGER:: IUBC, INDI, INDK, NEST, IDT, KDT, ID, IG, IJ, I, K, M
REAL   :: DXMIN, DTMIN, CFLL, CFLP, GVE, DLH, DPH, DTL, XLA, XLO, XD

INCLUDE'globals.h'
! ----------------------------------------------------------------------
!*    1. DEFINITION OF MODEL PARAMETERS.
!        -------------------------------
1000 CONTINUE
!*    1.1  DEFINE UNIT NAMES.
!          ------------------
!NEST
IU02 = 2
!NEST
IU05 = 95
IU06 = 6
IU07 = 7
IU08 = 8
!NEST
IU09 = 9
IU10 = 10
!NEST
IU11 = 11
IU12 = 12
IU13 = 13
IU14 = 14
IU15 = 15
!REFRA
IU16 = 16
!REFRA
IU17 = 17
IU18 = 18
!NEST
IU19 = 19
!NEST
IU20 = 20
IU21 = 21
IU25 = 25
IU26 = 26
IUVELO = 39
DO IG = 1, NBLO
   IUSCR (IG) = 39 + IG
   I = IUSCR (IG)
   CALL OPEN_SCRATCH_FILE (I, IU06)
END DO
IF (ITEST.GE.2) THEN
WRITE (IU06,  * ) '   SUB. INITMDL: UNITS DEFINED'
ENDIF

!*    1.2 INPUT OF USER PARAMETER.
!         ------------------------
CALL USERIN (IU05, IBOUNC, IBOUNF)
IF (ITEST.GE.2) THEN
   WRITE (IU06,  * ) '   SUB. INITMDL: USERIN DONE'
ENDIF
CLOSE (UNIT = IU05, STATUS = 'KEEP')

!*    2. INPUT FROM PREPROCESSING PROGRAMS.
!        ----------------------------------
2000 CONTINUE
CALL READPRE (IU07, IREFRA)
CLOSE (UNIT = IU07, STATUS = 'KEEP')
IF (ITEST.GE.2) THEN
WRITE (IU06,  * ) '    SUB. INITMDL: PREPROC OUTPUT READ ', 'AND F&
&ILE CLOSE UNIT IU07 = ', IU07
ENDIF
ITESTB = MIN (ITESTB, IGL)
IF (NGOUT.EQ.0.AND. (PFLAG25.OR.FFLAG25.OR.PFLAG26.OR.FFLAG26)) THEN
   WRITE (IU06,  * ) '+++++++++++++++++++++++++++++++++++++++++++++'
   WRITE (IU06,  * ) '+                                           +'
   WRITE (IU06,  * ) '+    WARNING ERROR IN SUB. INITMDL          +'
   WRITE (IU06,  * ) '+    =============================          +'
   WRITE (IU06,  * ) '+ NUMBER OF OUTPUT POINT FOR SPECTRA        +'
   WRITE (IU06,  * ) '+ READ FROM PREPROC OUTPUT IS ZERO.         +'
   WRITE (IU06,  * ) '+ OUTPUT FLAGS CHANGED TO NO OUTPUT.        +'
   WRITE (IU06,  * ) '+                                           +'
   WRITE (IU06,  * ) '+ MODEL CONTINUES.                          +'
   WRITE (IU06,  * ) '+                                           +'
   WRITE (IU06,  * ) '+++++++++++++++++++++++++++++++++++++++++++++'
   PFLAG25 = .FALSE.
   FFLAG25 = .FALSE.
   PFLAG26 = .FALSE.
   FFLAG26 = .FALSE.
ENDIF
!NEST
!*    2.1 READ COMMON CBOUND AND COMMON FBOUND.
!     ----------------------------------------
IF (IBOUNC.EQ.1.OR.IBOUNF.EQ.1) THEN
   CALL READBOU (IU09, IU10, IU06)
   CLOSE (UNIT = IU09, STATUS = 'KEEP')
   CLOSE (UNIT = IU10, STATUS = 'KEEP')
   IF (ITEST.GE.2) THEN
   WRITE (IU06,  * ) '    SUB. INITMDL: BOUNDARY POINTS READ ', ' AND&
& FILES CLOSED '
   ENDIF
ENDIF
!NEST
! ----------------------------------------------------------------------
!*    3. PRINT INITIAL CONDITIONS AS READ FROM PERPROCESSING.
!        ----------------------------------------------------
 3000 CONTINUE
WRITE (IU06, * ) '  '
WRITE (IU06, * ) ' WAVE MODEL GRID ORGANISATION:'
WRITE (IU06, * ) ' SOUTHERNMOST LATITUDE IN GRID IS .......: ',AMOSOP, ' DEGREE'
WRITE (IU06, * ) ' NORTHERNMOST LATITUDE IN GRID IS .......: ',AMONOP, ' DEGREE'
WRITE (IU06, * ) ' WESTERNMOST LONGITUDE IN GRID IS .......: ',AMOWEP, ' DEGREE'
WRITE (IU06, * ) ' EASTERNMOST LONGITUDE IN GRID IS .......: ',AMOEAP, ' DEGREE'
WRITE (IU06, * ) ' LATITUDE INCREMENT IS ..................: ',XDELLA, ' DEGREE'
WRITE (IU06, * ) ' LONGITUDE INCREMENT IS .................: ',XDELLO, ' DEGREE'
WRITE (IU06, * ) '  '
WRITE (IU06, * ) ' TOTAL NUMBER OF BLOCKS IS...............: ',IGL
WRITE (IU06,  * ) '  '
WRITE (IU06, * ) ' OUTPUT POINTS:'
WRITE (IU06, * ) ' TOTAL NUMBER OF OUTPUT POINTS IS: ', NGOUT
WRITE (IU06, '(/,4X,''BLOCK NO'',6X,''INDEX NO'', &
&                 8X,''LONGITUDE'',6X,''LATITUDE'')')
DO I = 1, NGOUT
   XLO = AMOWEP + REAL (IXLG (IJAR (I), IGAR (I) ) - 1) * XDELLO
   XLA = AMOSOP + REAL (KXLT (IJAR (I), IGAR (I) ) - 1) * XDELLA
   WRITE (IU06, '((6X,I3,10X,I5,7X,F10.3,4X,F10.3))') IGAR (I) , &
    IJAR (I) , XLO, XLA
END DO
!NEST
IF (IBOUNC.EQ.1) THEN
   WRITE (IU06, * )
   WRITE (IU06, * ) ' COURSE GRID: BOUNDARY OUTPUT POINTS :'
   WRITE (IU06, * ) ' TOTAL NUMBER OF BOUNDARY POINTS IS: ', NBOUNC
   IF (ITEST.GE.2) THEN
WRITE (IU06, '(/,4X,''BLOCK NO'',6X,''INDEX NO'', &
&              8X,''LONGITUDE'',6X,''LATITUDE'')')
      DO NEST = 1, NESTS
      WRITE (IU06) 'NEST NUMBER:', NEST
      DO I = 1, NBOUNC (NEST)
         XLO = AMOWEP + REAL (IXLG (IJARC (I, NEST), IGARC (I,NEST) ) - 1) * XDELLO
         XLA = AMOSOP + REAL (KXLT (IJARC (I, NEST), IGARC (I,NEST) ) - 1) * XDELLA
         WRITE (IU06, '((6X,I3,10X,I5,7X,F10.3,4X,F10.3))') IGARC &
          (I, NEST) , IJARC (I, NEST) , XLO, XLA
      END DO
      WRITE (IU06) '*****************************************'
      ENDDO
   ENDIF
ENDIF
!NEST
! ----------------------------------------------------------------------
!*    4. CONNECT RESTART FIELDS TO OUTPUT UNITS.
!        ---------------------------------------
 4000 CONTINUE
IF (ITEST.GE.2) THEN
WRITE (IU06, * ) '    '
WRITE (IU06, * ) '   SUB. INITMDL:  RECOVERY FILES ACCESSED.'
ENDIF
!
!        READ IN LAST WINDFIELDS FROM RESTARTFILE.
!
READ (IU15) IDTPRO, IDATEWO, IDAWIFL, IDATEFL, IDTSOU
READ (IU15) U10OLD
READ (IU15) THWOLD
READ (IU15) USOLD
READ (IU15) TAUW
READ (IU15) Z0OLD
IDA = IDTPRO
WRITE (IU06, * ) ' RECOVERY START DATE IS IDTPRO = ', IDTPRO
IF (IDTPRO.NE.'000000000000') THEN
!*    4.1 MODEL STARTS FROM FILES OUT OF A PREVIOUS MODEL RUN.
!         ----------------------------------------------------
   IF (IDTPRO.LT.IDATEA.OR.IDTPRO.GE.IDATEE) THEN
      WRITE (IU06, * ) ' *******************************************'
      WRITE (IU06, * ) ' *    FATAL ERROR IN SUB. INITMDL          *'
      WRITE (IU06, * ) ' *    ===========================          *'
      WRITE (IU06, * ) ' * START DATE FROM RESTART FIELD IS NOT    *'
      WRITE (IU06, * ) ' * MODEL PERIOD.                           *'
      WRITE (IU06, * ) ' * START DATE OF RUN       IS IDATEA = ', IDATEA
      WRITE (IU06, * ) ' * END   DATE OF RUN       IS IDATEE = ', IDATEE
      WRITE (IU06, * ) ' * START DATE FROM RESTART IS IDTPRO = ', IDTPRO
      WRITE (IU06, * ) ' *                                         *'
      WRITE (IU06, * ) ' * PROGRAM ABORTS     PROGRAM ABORTS       *'
      WRITE (IU06, * ) ' *                                         *'
      WRITE (IU06, * ) ' *******************************************'
      CALL ABORT
   ENDIF
ELSE
!*    4.2 MODEL STARTS FROM FIELDS CREATED BY PRESET.
!         -------------------------------------------
   IDTPRO = IDATEA
   IDTSOU = IDATEA
   IF (ITEST.GE.2) THEN
      WRITE (IU06, * ) ' IN SUB. INITMDL: IDTSOU =', IDTSOU
   ENDIF
   IDATEWO = IDATEA
   IF (IDELT.LT.IDELWO) CALL INCDATE (IDATEWO, IDELWO / 2)
   IDAWIFL = IDATEA
   IDELWH = MAX (IDELWI, IDELPRO)
   CALL INCDATE (IDAWIFL, IDELWH)
   IDATEFL = IDATEWO
ENDIF
IF (ITEST.GE.2) THEN
   WRITE(IU06,*) '    SUB. INITMDL: WIND FIELD AND ', ' COUNTER INITIALIZED'
   WRITE(IU06,*) '      NEXT WINDFIELD WILL BE READ AT     ', 'IDATEWO = ', IDATEWO
   WRITE(IU06,*) '      NEXT WIND FILE WILL BE ACCESSED AT ', 'IDATEFL = ', IDATEFL
   WRITE(IU06,*) '      NEXT WIND FILE NAME IS FROM        ', 'IDAWIFL = ', IDAWIFL
ENDIF
! ----------------------------------------------------------------------
!*    5. INITIALIZE MODEL TIME VARIABLES
!        -------------------------------
!*    5.1 OUTPUT TIME VARIABLES.
!         ----------------------
IF (PFLAG20.OR.FFLAG20) THEN
   IDTINTT = IDATEA
 5102    CONTINUE
   CALL INCDATE (IDTINTT, IDELINT)
   IF (IDTINTT.LE.IDTPRO) GOTO 5102
ELSE
   IDTINTT = '000000000000'
ENDIF
IF (PFLAG21.OR.FFLAG21) THEN
   IDTINTS = IDATEA
 5103    CONTINUE
   CALL INCDATE (IDTINTS, IDELINS)
   IF (IDTINTS.LE.IDTPRO) GOTO 5103
ELSE
   IDTINTS = '000000000000'
ENDIF
IF (PFLAG25.OR.FFLAG25) THEN
   IDTSPT = IDATEA
 5104    CONTINUE
   CALL INCDATE (IDTSPT, IDELSPT)
   IF (IDTSPT.LE.IDTPRO) GOTO 5104
ELSE
   IDTSPT = '000000000000'
ENDIF
IF (PFLAG26.OR.FFLAG26) THEN
   IDTSPS = IDATEA
 5105    CONTINUE
   CALL INCDATE (IDTSPS, IDELSPS)
   IF (IDTSPS.LE.IDTPRO) GOTO 5105
ELSE
   IDTSPS = '000000000000'
ENDIF
!
!*    5.2 FILE DISPOSE TIME AND RESTART TIME.
!         -----------------------------------
!
IDTRES = IDTPRO
CALL INCDATE (IDTRES, IDELRES)
IF (ITEST.GE.2) THEN
WRITE (IU06,  * ) '    SUB. INITMDL: TIME COUNTER INITIALIZED'
ENDIF
!
! ----------------------------------------------------------------------
!
 6000 CONTINUE
!wlufdtp begin
!     GVE = G/(ZPI*FR(1)*2.)
! FOR FREQUENCY DEPENDENT PROPGATION CASE, CFL FUFILLED AT THE LAST
! FREQUENCY, THEN DIVIDE EVERY IDELPRO INTO SEVERAL SUB TIME STEP
! DEPENDENT ON FREQUENCY
!*****************************
#ifndef profreq
IFDTP = 0
#else
IFDTP = 1
#endif
!*****************************
IF (IFDTP.EQ.1) THEN
   GVE = G / (ZPI * FR (NFRE) * 2.)
ELSE
   GVE = G / (ZPI * FR (1) * 2.)
ENDIF
!wlufdtp end
DPH = DELPHI
!      CFLP= IDELPRO*GVE/DPH
CFLP = SQRT (2.) * IDELPRO * GVE / DPH
DLH = DELLAM * COS (AMONOP * RAD)
!      CFLL= IDELPRO*GVE/DLH
CFLL = SQRT (2.) * IDELPRO * GVE / DLH
!*    7. NUMBER OF PROPAGATION TIME STEPS PER CALL.
!        ------------------------------------------
!
 7000 CONTINUE
NADV = IDELWI / IDELPRO
NADV = MAX (NADV, 1)
IF (ITEST.GE.2) THEN
WRITE (IU06,  * ) '   SUB. INITMDL: NUMBER OF PROPAGATION STEPS'
WRITE (IU06,  * ) '     IN ONE CALL OF SUB WAVEMDL WILL BE ', 'NADV = ', NADV
ENDIF
!wlufdtp begin
!     7.1 CALCULATE ADVECTION SUB-TIMESTEPS (IF APPLICABLE) AND
!         MULTIPLE TIMESTEPS FOR THE HIGHER FREQUENCIES IF REQUIRED
!
IF (IFDTP.EQ.1) THEN
   DXMIN = MIN (DPH, DLH)
   DTMIN = DXMIN * 2. * ZPI * FR (1) / G / SQRT (2.)
!jcc begin 141298
!         IDT=INT(IDELPRO/DTMIN+0.5)
   IDT = MAX (1, INT (IDELPRO / DTMIN + 0.5) )
!jcc end
   DTMIN = IDELPRO / IDT
   IDTMIN = INT (DTMIN)
 7001    IF ( (MOD (IDELPRO, IDTMIN) .NE.0) .OR. (IDTMIN.GE.IDELPRO) ) THEN
      IDTMIN = IDTMIN - 1
      GOTO 7001
   ENDIF
   NSUBADV = IDELPRO / IDTMIN
ELSE
   NSUBADV = 1
   IDTMIN = IDELPRO
ENDIF
IF (IFDTP.EQ.1) THEN
   NDTADF (1) = 1
   DO 7020 M = 2, NFRE
      KDT = 1
      DTL = DXMIN * 4. * PI * FR (M) / G / SQRT (2.)
      KDT = INT (DTL / IDTMIN)
! TAKE LARGEST VALUE
      DO 7030 K = 1, KDT
         IF (MOD (NSUBADV, K) .EQ.0) THEN
            NDTADF (M) = K
         ENDIF
 7030       END DO
 7020    END DO
ELSE
   DO 7040 M = 1, NFRE
      NDTADF (M) = 1
 7040    END DO
ENDIF
IF (ITEST.GE.2) THEN
WRITE (IU06,  * ) '   SUB. INITMDL: NUMBER OF SUB PROP.TIME STEP'
WRITE (IU06,  * ) '   FOR 1ST FREQUENCY IN ONE IDELPRO WILL BE ', &
&'NSUBADV = ', NSUBADV
   WRITE (IU06, * ) 'TIME STEP FOR 1ST FREQUENCY IS:', IDTMIN
   WRITE (IU06, * ) 'NDTADF ARRAY IS:', (NDTADF (M) , M = 1, NFRE)
ENDIF
!wlufdtp end
! ----------------------------------------------------------------------
!*    8. IF ONE BLOCK VERSION READ SPECTRA AND COMMON UBUF.
!        --------------------------------------------------
 8000 CONTINUE
IF (IGL.EQ.1) THEN
!*    8.1 READ BLOCK OF SPECTRA.
!         ----------------------
   READ (IU12) ( ( (FL1 (IJ, K, M), IJ = 0, NIBLO), K = 1, NANG), &
    M = 1, NFRE)
IF (ITEST.GE.2) WRITE (IU06,  * ) '   SUB. INITMDL: START READ IN &
&OF', ' BLOCK OF SPECTRA'
!*    8.2 INPUT NEIGHBOURING GRID POINT INDICES (COMMON BLOCK UBUF).
!         ----------------------------------------------------------
   READ (IU08) KLAT, KLON
!SHALLOW
!*    8.3 COMPUTE SHALLOW WATER TABLE INDICES.
!         ------------------------------------
   IF (ISHALLO.NE.1) THEN
      DO 8301 IJ = 1, IJLT (IGL)
         XD = LOG (DEPTH (IJ, IGL) / DEPTHA) / LOG (DEPTHD) + 1.
         ID = NINT (XD)
         ID = MAX (ID, 1)
         INDEP (IJ) = MIN (ID, NDEPTH)
 8301       END DO
   ENDIF
!SHALLOW
IF (ITEST.GE.2) WRITE (IU06,  * ) '   SUB. INITMDL: COMMON UBUF ', &
& 'READ AND INITIALIZED '
ENDIF
! ----------------------------------------------------------------------
!REFRA
!*    9. PRECOMPUTE REFRACTION TERMS.
!        ----------------------------
 9000 CONTINUE
IF (IREFRA.NE.0) THEN
   CALL PROPDOT
IF (ITEST.GE.2) WRITE (IU06,  * ) '   SUB. INITMDL: COMMON REFDOT &
&', 'INITIALIZED '
ENDIF
!REFRA
! ----------------------------------------------------------------------
!CMFA
!*    10. OPEN THE FIRST RESULT FILES.
!         ----------------------------
!           INTEGRATED PARAMETER DATA FILE.
IF (FFLAG20) CALL GSFILE (IU06, IU20, 1, IDTRES, 'MAP', 'S')
!            INTEGRATED SWELL AND SEA DATA FILE.
IF (FFLAG21) CALL GSFILE (IU06, IU21, 1, IDTRES, 'SWE', 'S')
!             SPECTRA FILE.
IF (FFLAG25) CALL GSFILE (IU06, IU25, 1, IDTRES, 'SPE', 'S')
!             SWELL SPECTRA FILE.
IF (FFLAG26) CALL GSFILE (IU06, IU26, 1, IDTRES, 'SWS', 'S')
!NEST
!             BOUNDARY VALUE FILE.
IF (IBOUNC.EQ.1) THEN
   IUBC = 50
   DO NEST = 1, NESTS
   IF (NEST.LE.9) THEN
      WRITE (CBFILE, '(2x,i1)') NEST
      CBFILE (1:2) = 'CB'
   ELSEIF (NEST.GE.10) THEN
      WRITE (CBFILE, '(1x,i2)') NEST
      CBFILE (1:2) = 'C'
   ENDIF
   IF (NEST.EQ.1) CBFILE (1:3) = 'CBO'
   CALL GSFILE (IU06, IUBC, 1, IDTRES, CBFILE, 'S')
   IUBC = IUBC + 1
   ENDDO
ENDIF
!NEST
IF (ITEST.GE.2) WRITE (IU06,  * ) '   SUB. INITMDL: OUTPUT FILES OPENED'
!CMFE
!NEST
!
!        WRITE BOUNDARY VALUE FILE HEADER.
!
IF (IBOUNC.EQ.1) THEN
   IUBC = 50
   DO NEST = 1, NESTS
      CALL HEADBC (NBOUNC, IDELPRO, FR (1), IUBC, IU06, NEST)
      IUBC = IUBC + 1
      IF (ITEST.GE.2) WRITE (IU06, '(''    SUB. INITMDL: HEADER FOR  '', &
&                  ''COURSE GRID WAS WRITTEN OF UNIT IUBC = '',A8)') IUBC
   ENDDO
ENDIF
!NEST
! ----------------------------------------------------------------------
!jcccfl begin 190298
!
!*   11. CONSISTENCY CHECK ACCORDING TO CFL CRITERION.
!        ---------------------------------------------
IF (IFDTP.NE.1) THEN
   DO IG = 1, NBLO
      INDK = 0
      CALL CFLSUB (IU08, IG, INDK, INDI, IDEPTHU, IDELREC)
      IF (INDK.NE.0) THEN
         WRITE(IU06,*) '******************************************'
         WRITE(IU06,*) '*                                         *'
         WRITE(IU06,*) '*               WARNING                   *'
         WRITE(IU06,*) '*                                         *'
         WRITE(IU06,*) '*             IN SUB. CFLSUB              *'
         WRITE(IU06,*) '*       ===========================       *'
         WRITE(IU06,*) '* CFL-CRITERION NOT FULFILLED AT LEAST AT *'
         WRITE(IU06,*) '* GRID POINT :                            *'
         WRITE(IU06,*) '* INDEX I                  : ', INDI
         WRITE(IU06,*) '* INDEX K                  : ', INDK
         WRITE(IU06,*) '* DEPTH                    : ', IDEPTHU
         WRITE(IU06,*) '* PROPAGATION TIME DEFINED : ', IDELPRO
         WRITE(IU06,*) '* PROPAGATION TIME RECOMEND: ', IDELREC
         WRITE(IU06,*) '*                                        *'
         WRITE(IU06,*) '******************************************'
!             CALL ABORT
      ENDIF
   END DO
   IF (ITEST.GE.2) THEN
      WRITE(IU06,*) '    SUB. INITMDL: CFL CRITERION CHECK DONE'
      WRITE(IU06,*) '   '
   ENDIF
ELSE
   WRITE (IU06,*) ' SUB. INITMDL: CFL CRITERION IS NOT CHECKED '
   WRITE (IU06,*) ' FOR ALL GRID POINTS, DIRECTIONS AND FREQUENCIES'
   WRITE (IU06,*) '    '
ENDIF

RETURN
END SUBROUTINE initmdl
