SUBROUTINE incdate (date, ishift)
! ----------------------------------------------------------------------
!**** *INCDATE* - TO UPDATE DATE TIME GROUP
!     L. BERTOTTI, P.JANSSEN.
!     H. GUNTHER   ECMWF  NOVEMBER 1989    NEGATIVE INCREMENTS.
!*    PURPOSE.
!     --------
!       UPDATING DATE TIME GROUP.
!**   INTERFACE.
!     ----------
!       *CALL* *INCDATE (IDATE,ISHIFT)*
!         *IDATE*  INTEGER - DATE TIME GROUP (YYMMDDHHMM)
!         *ISHIFT* INTEGER - TIME INCREMENT IN SECONDS, WHERE
!                            ABS (ISHIFT) HAS TO BE LESS THEN 1 YEAR
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCES.
!     -----------
!       NONE.
! ----------------------------------------------------------------------
IMPLICIT NONE

CHARACTER, INTENT(INOUT):: date * 12
INTEGER  , INTENT(IN)   :: ishift
INTEGER :: mon(12)
INTEGER :: iday, isec, ihour, iyear, month, minut

DATA mon / 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /
! ----------------------------------------------------------------------
!*    1.0 SPLITE DATE TIME GROUP INTO MINUTE, HOUR, DAY, MONTH, YEAR.
!         -----------------------------------------------------------
READ(date, 5) iyear, month, iday, ihour, minut, isec
IF( MOD (iyear, 4) .EQ.0) THEN
   mon(2) = 29
ELSE
   mon(2) = 28
ENDIF
! ----------------------------------------------------------------------
!*    2.0 ADD SECONDS AND UPDATE DATE AND TIME.
!         -------------------------------------
isec = isec + MOD (ishift, 60)
IF( isec .GE. 60 ) THEN
   minut = minut + isec / 60
   isec = isec - (isec / 60) * 60
ELSEIF( isec .LT. 0 ) THEN
   minut = minut + (isec - 59) / 60
   isec = isec - ( (isec - 59) / 60) * 60
ENDIF
minut = minut + ishift / 60
!     2.1 POSITIVE SHIFT GREATER THAN 1 MINUTE.
IF( minut .GE. 60 ) THEN
   ihour = ihour + minut / 60
   minut = minut - (minut / 60) * 60
   IF( ihour .GE. 24 ) THEN
      iday = iday + ihour / 24
      ihour = ihour - (ihour / 24) * 24
      IF( iday .GT. mon(month) ) THEN
         1300 CONTINUE
         iday = iday - mon(month)
         month = month + 1
         IF( month .EQ. 13 ) THEN
            month = 1
            iyear = MOD (iyear + 1, 100)
            IF( MOD (iyear, 4) .EQ.0) THEN
               mon(2) = 29
            ELSE
               mon(2) = 28
            ENDIF
         ENDIF
         IF( iday .GT. mon(month) ) GOTO 1300
      ENDIF
   ENDIF
ELSEIF( minut .LT. 0 ) THEN
!     2.2 NEGATIVE SHIFT.
   ihour = ihour + (minut - 59) / 60
   minut = minut - ( (minut - 59) / 60) * 60
   IF( ihour .LT. 0 ) THEN
      iday = iday + (ihour - 23) / 24
      ihour = ihour - ( (ihour - 23) / 24) * 24
      IF( iday .LT. 1 ) THEN
         1400 CONTINUE
         month = month - 1
         IF( month .EQ. 0 ) THEN
            month = 12
            iyear = MOD (iyear + 99, 100)
            IF( MOD (iyear, 4) .EQ.0) THEN
               mon(2) = 29
            ELSE
               mon(2) = 28
            ENDIF
         ENDIF
         iday = iday + mon(month)
         IF( iday .LT. 1 ) GOTO 1400
      ENDIF
   ENDIF
ENDIF
! ----------------------------------------------------------------------
!*    3.0 COMPOSE NEW DATE TIME GROUP.
!         ----------------------------
WRITE(date, 5) iyear, month, iday, ihour, minut, isec
 5 FORMAT(6I2.2)

RETURN
END SUBROUTINE incdate
