SUBROUTINE gsfile (iu06, iunit, ifs, idrn, fileid, opt)
! ----------------------------------------------------------------------
!**** *GSFILE* - GETS/SAVES FILES (UNICOS VERSION).
!     HEINZ GUNTHER       GKSS/ECMWF  MARCH   1991
!*    PURPOSE.
!     --------
!       TO COPY A RESTART FILE OR TO CLOSE AND TO ASSIGN A RESULT FILE.
!**   INTERFACE.
!     ----------
!      *CALL* GSFILE (IU06, IUNIT, IFS, IDRN, FILEID, OPT)*
!         *IU06*   INTEGER    UNIT FOR PRINTER MESSAGES.
!         *IUNIT*  INTEGER    FORTRAN UNIT.
!         *IFS*     INTEGER    DATE (YYMMDDHHMM) OF FILE TO BE SAVED
!                             OR < 0  RESTART FILE INDEX.
!         *IDRN*   CHAR*12    DATE TIME GROUP OF A NEW RESULT FILE
!                             0 IF A NEW FILE HAS NOT TO BE OPENED.
!         *FILEID* CHARACTER  FILE ID.
!         *OPT*    CHARACTER  OPTION
!                             = 'S' SAVE FILE CONNECTED TO IUNIT
!                             = 'G' GET FILE AND CONNECT FILE TO IUNIT
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!       *IECF_LEN*  - LENGTH OF CHARACTER STRING.
!       *ISHELL*    - FORTRAN INTERFACE TO UNICOS.
!       *OPENFIL*   - OPEN A NEW FILE.
!     METHOD.
!     -------
!        THE METHOD USED IN THIS SUB DEPENDS UPON THE COMPUTER
!        ENVIROMENT. IN ITS PRESENT FORM THE ROUTINE IS ADOPTED TO
!        THE CRAY UNICOS SYSTEM.
!
!        IF IFS IS LESS THAN ZERO A RESTART HAS TO BE TREATED.
!           THE FORTRAN UNIT ALIAS FILE IS CLOSED AND KEPT.
!           IF OPT = 'G' THEN THE SUB COPIES A FILE TO THE UNIT
!              ALIAS FILE IN THE CURRENT WORKING DIRECTORY.
!           IF OPT = 'S' THE UNIT ALIAS FILE IS COPIED TO A
!              FILE. BOTH OPERATIONS ARE DONE BY THE UNICOS COMMAND
!              "cp" ,WHICH IS EXECUTED BY CALLING ISHELL.
!           THE FULL PATH NAME IS  PATH/FILE NAME, WHERE THE FILE
!           NAME IS TAKEN FROM NAME(-IDATE), DEFINED IN SECTION 1.
!
!        IF IFS IS GREATER THAN ZERO A RESULT FILE IS TREATED.
!           THE FILE ASSIGNED TO THE UNIT IS CLOSED AND KEPT. IN
!           ADDITION:
!           IF OPT = 'S' AND IDRN > 0 A NEW RESULT FILE IS OPENED
!              AND ASSIGNED TO THE UNIT BY OPENFIL. THE FILE DATE USED
!              IS IDRN. IT IS ASSUMED THAT THE FILE DOES NOT EXIST.
!           IF OPT = 'G' AN EXISTING FILE IS ASSIGNED TO THE UNIT
!              BY OPENFIL. THE FILE DATE USED IS IDRN. IT IS ASSUMED
!              THAT THE FILE EXIST.
!           THE FILE NAME CONVENTION IS EXPLAINED IN SUB OPENFIL.
!     REFERENCES.
!     -----------
!       NONE.
! ----------------------------------------------------------------------
USE text
IMPLICIT NONE

INTEGER  , INTENT(IN) :: iu06, ifs
INTEGER  , INTENT(OUT):: iunit
CHARACTER, INTENT(IN) :: idrn * 12, fileid * 3, opt * 1

INTEGER,PARAMETER :: qqname = 3
CHARACTER :: name (qqname) * 16, filena * 16, fname * 128, uit * 7
!        *QQNAME*  INTEGER     DIMENSION OF RESTAT FILE NAME ARRAY.
!        *NAME*    CHARACTER   RESTART FILE NAMES.
!        *FILENA*  CHARACTER   GENERATED FILE NAME.
!        *FNAME*   CHARACTER   FULL UNICOS FILE NAME.
!        *UIT*     CHARACTER   FORTRAN UNIT ALIAS FILE NAME.
INTEGER :: ifail
! ----------------------------------------------------------------------
!*    1. FILE NAMES FOR RESTART FIELDS.
!        ------------------------------
DATA NAME (1) / 'BLSPANAL' / , NAME (2) / 'SLATANAL' / , NAME (3) &
 / 'LAWIANAL' /
!        *NAME(1)* CHARACTER   PERMANENT FILE NAME FOR RESTART FILE
!                              BLOCKS OF SPECTRA.
!        *NAME(2)* CHARACTER   PERMANENT FILE NAME FOR RESTART FILE
!                              SECOND LATITUDE OF BLOCKS.
!        *NAME(3)* CHARACTER   PERMANENT FILE NAME FOR RESTART FILE
!                              LAST WIND FIELDS.
! ----------------------------------------------------------------------
!*    2.0  ERROR, RESTART OR RESULT FILE?
!          ------------------------------
IF( ifs .LT. - qqname) THEN
! ----------------------------------------------------------------------
!*    2.1  ERROR IN IDATE, ABORT.
!          ----------------------
   WRITE(IU06,*) ' *******************************************'
   WRITE(IU06,*) ' *                                         *'
   WRITE(IU06,*) ' *        FATAL ERROR IN --GSFILE--        *'
   WRITE(IU06,*) ' *        =========================        *'
   WRITE(IU06,*) ' * RESTAT FILE INDEX OUT OF RANGE.         *'
   WRITE(IU06,*) ' * FILE NAME INDEX REQUESTED IS ', IFS
   WRITE(IU06,*) ' * INDEX MUST FULLFILL:                    *'
   WRITE(IU06,*) ' *       -QQNAME <= INDEX  < 0             *'
   WRITE(IU06,*) ' * QQNAME = ', QQNAME
   WRITE(IU06,*) ' * EXECUTION ABORTS.                       *'
   WRITE(IU06,*) ' *                                         *'
   WRITE(IU06,*) ' *******************************************'
   CALL ABORT
ELSEIF( ifs .GE. 0 ) THEN
! ----------------------------------------------------------------------
!*    2.2  RESULT FILE.
!          ------------
!*    2.2.1 CLOSE THE UNIT TO EMPTY THE BUFFER.
!           -----------------------------------
   CLOSE(UNIT = iunit, STATUS = 'KEEP')
   IF( opt .EQ. 'G') THEN
!*    2.2.2 OPEN AN EXISTING FILE.
!           ----------------------
      CALL openfil (iu06, iunit, idrn, fileid, 'OLD', userid, runid, path, ifail)
      IF( ifail .NE. 0 ) CALL ABORT
   ELSEIF( opt .EQ. 'S' .AND. idrn .GT. '000000000000') THEN
!*    2.2.3 CREATE A NEW FILE, IF NOT END OF RUN.
!           -------------------------------------
      CALL openfil (iu06, iunit, idrn, fileid, 'NEW', userid, runid, path, ifail)
      IF( ifail .NE. 0 ) CALL ABORT
   ENDIF
ENDIF

RETURN
END SUBROUTINE gsfile
