SUBROUTINE gradi (ig, irefra, ddphi, ddlam, duphi, dulam, dvphi, dvlam)
! ----------------------------------------------------------------------
!**** *GRADI* - CALCULATES DEPTH AND CURRENT VELOCITY GRADIENTS.
!     K.P. HUBBERT              AUGUST   1988
!     H. GUNTHER    ECMWF/GKSS  DECEMBER 1990  MODIFIED FOR CYCLE_4.
!
!*    PURPOSE.
!     --------
!       CALCULATES DEPTH AND CURRENT VELOCITY GRADIENTS OF A BLOCK.
!**   INTERFACE.
!     ----------
!       *CALL* *GRADI (IG, IREFRA, DDPHI, DDLAM, DUPHI, DULAM,
!                      DVPHI, DVLAM)*
!          *IG*     - BLOCK NUMBER.
!          *IREFRA* - REFRACTION OPTION.
!          *DDPHI*  - LATITUDE DEPTH GRADIENT.
!          *DDLAM*  - LONGITUDE DEPTH GRADIENT.
!          *DUPHI*  - LATITUDE  U-COMPONENT GRADIENT.
!          *DULAM*  - LONGITUDE U-COMPONENT GRADIENT.
!          *DVPHI*  - LATITUDE  V-COMPONENT GRADIENT.
!          *DVLAM*  - LONGITUDE V-COMPONENT GRADIENT.
!     METHOD.
!     ------
!       CENTRAL DIFFERENCING FOR DEPTH AND CURRENT VELOCITY GRADIENTS.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use current
use gridpar
use shallow
use ubuf
implicit none

INTEGER, INTENT(IN) :: ig, irefra
REAL   , INTENT(OUT):: ddphi(nibld), ddlam(nibld), duphi(niblc), dulam(niblc)
REAL   , INTENT(OUT):: dvphi(niblc), dvlam(niblc)

REAL :: DELPHI2, DELLAM2
INTEGER :: IJ, IPP, IPM, ILP, ILM
! ----------------------------------------------------------------------
!*    1. INITIALISE.
!        -----------
!1000 CONTINUE
DELPHI2 = 1. / (DELPHI * 2.0)
DELLAM2 = 1. / (DELLAM * 2.0)
! ----------------------------------------------------------------------
!*    2. CALCULATE DEPTH GRADIENTS.
!        --------------------------
!2000 CONTINUE
DO IJ = 1, NIBLD
   DDPHI (IJ) = 0.0
   DDLAM (IJ) = 0.0
END DO
DO IJ = IJS (IG), IJL (IG)
   IPP = KLAT (IJ, 2)
   IPM = KLAT (IJ, 1)
   IF (IPP.GT.0.AND.IPM.GT.0) THEN
      DDPHI (IJ) = (DEPTH (IPP, IG) - DEPTH (IPM, IG) ) * DELPHI2
   ENDIF
   ILP = KLON (IJ, 2)
   ILM = KLON (IJ, 1)
   IF (ILP.GT.0.AND.ILM.GT.0) THEN
      DDLAM (IJ) = (DEPTH (ILP, IG) - DEPTH (ILM, IG) ) * DELLAM2
   ENDIF
END DO
! ----------------------------------------------------------------------
!*    3. CALCULATE CURRENT VELOCITY GRADIENTS.
!        -------------------------------------
!3000 CONTINUE
IF (IREFRA.EQ.2) THEN
   DO IJ = 1, NIBLC
      DUPHI (IJ) = 0.0
      DULAM (IJ) = 0.0
      DVPHI (IJ) = 0.0
      DVLAM (IJ) = 0.0
   END DO
   DO IJ = IJS (IG), IJL (IG)
      IPP = KLAT (IJ, 2)
      IPM = KLAT (IJ, 1)
      IF (IPP.GT.0.AND.IPM.GT.0) THEN
         DUPHI (IJ) = (U (IPP, IG) - U (IPM, IG) ) * DELPHI2
         DVPHI (IJ) = (V (IPP, IG) - V (IPM, IG) ) * DELPHI2
      ENDIF
      ILP = KLON (IJ, 2)
      ILM = KLON (IJ, 1)
      IF (ILP.GT.0.AND.ILM.GT.0) THEN
         DULAM (IJ) = (U (ILP, IG) - U (ILM, IG) ) * DELLAM2
         DVLAM (IJ) = (V (ILP, IG) - V (ILM, IG) ) * DELLAM2
      ENDIF
   END DO
ENDIF

RETURN
END SUBROUTINE gradi
