SUBROUTINE getwnd (us, ds, idtwis, uwnd, vwnd, nc, nr, us_eta, z0_eta)
! ----------------------------------------------------------------------
!**** *GETWND* - ROUTINE TO READ AND PROCESS ONE WINDFIELD.
!*    PURPOSE.
!     --------
!        READ A WINDFIELD FROM THE WINDFILE (SEARCH FOR IT)
!        AND CALCULATES THE WIND VELOCITY  AND DIRECTION
!        FOR ALL WAM BLOCKS.
!**   INTERFACE.
!     ----------
!       *CALL* *GETWND (US, DS, IDTWIS, UWND, VWND, NC, NR)*
!         *US*     - MAGNITUDE OF USTAR IN EACH POINT AND BLOCK.
!         *DS*     - DIRECTION OF USTAR IN EACH POINT AND BLOCK.
!         *IDTWIS* - DATE OF WIND FIELD TO BE LOOKED FOR.
!         *UWND*   - INPUT WIND FIELD U COMPONENT.
!         *VWND*   - INPUT WIND FIELD V COMPONENT.
!         *NC*     - DIMENSION OF WIND INPUT ARRAYS NUMBER OF COLUMNES.
!         *NR*     - DIMENSION OF WIND INPUT ARRAYS NUMBER OF ROWS.
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ----------
!       *ABORT*     - TERMINATES PROCESSING.
!       *READWND*   - READING WINDS.
!       *WAMWND*    - CALCULATE WIND IN WAM POINTS.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
use params
use testo
implicit none
!NIKOS SAVE

INTEGER*4  , INTENT(IN)    :: nc, nr   !cpk-i4 instead of -i8
REAL     , INTENT(IN OUT):: us(niblo,nblo), ds(niblo,nblo)
CHARACTER, INTENT(IN)    :: idtwis * 12
REAL     , INTENT(IN OUT):: uwnd(nc,nr), vwnd(nc,nr)
REAL     , INTENT(IN OUT):: us_eta(nc,nr), z0_eta(nc,nr)
CHARACTER (LEN=12),SAVE  :: IDTWIR

!NIKOS SAVE IDTWIR
INTEGER :: IAREAS, IT1, IT2
! ----------------------------------------------------------------------
!*    1. WIND DATA ARE READ
!        ------------------
1000 CONTINUE
CALL READWND (IDTWIR, UWND, VWND, NC, NR, us_eta, z0_eta)
!*    2. CHECK WIND FIELD DATE
!        ----------------------
IF (IDTWIR.LT.IDTWIS) THEN
!     2.1 DATE OF INPUT FIELD IS BEFORE REQUESTED DATE
!         TRY AGAIN
!         --------------------------------------------
   GOTO 1000
ELSEIF (IDTWIR.GT.IDTWIS) THEN
!     2.2 DATE OF INPUT FIELD IS LATER THAN REQUESTED DATE
!         ------------------------------------------------
   WRITE(IU06,*) ' ******************************************'
   WRITE(IU06,*) ' *                                        *'
   WRITE(IU06,*) ' *      FATAL ERROR SUB. GETWND           *'
   WRITE(IU06,*) ' *      =======================           *'
   WRITE(IU06,*) ' * WIND DATE READ IS LATER THAN EXPECTED  *'
   WRITE(IU06,*) ' * DATE READ IS     IDTWIR = ', IDTWIR
   WRITE(IU06,*) ' * DATE EXPECTED IS IDTWIS = ', IDTWIS
   WRITE(IU06,*) ' *                                        *'
   WRITE(IU06,*) ' *   PROGRAM ABORTS  PROGRAM ABORTS       *'
   WRITE(IU06,*) ' *                                        *'
   WRITE(IU06,*) ' ******************************************'
   CALL ABORT
ENDIF
! ----------------------------------------------------------------------
!*    3. INTERPOLATE AND BLOCK WINDFIELD
!        -------------------------------
CALL WAMWND (US, DS, UWND, VWND, NC, NR, 1, NIBLO, us_eta, z0_eta)

RETURN
END SUBROUTINE getwnd
