SUBROUTINE fdur (ewfg, t, usmo, ijs, ijl)
!--------------------------------------------------------------------
!**** *FDUR* - EVALUATE THE WINDSEA DURATION FROM THE MODEL GROTH CURVE.
!     P.LIONELLO     ECMWF       APRIL 1990
!     PURPOSE.
!     --------
!       EVALUATE THE WINDSEA DURATION FROM THE MODEL GROTH CURVE.
!**   INTERFACE.
!     ----------
!       *CALL* *FDUR (EWFG, T, USMO, IJS, IJL)*
!        *EWFG*   REAL     WINDSEA ENERGY (FIRST GUESS).
!        *T*      REAL     WINDSEA DURATION (OUTPUT).
!        *USMO*   REAL     FIRST GUESS USTAR.
!        *IJS*    INTEGER  FIRST INDEX IN BLOCK.
!        *IJL*    INTEGER  LAST  INDEX IN BLOCK.
!     METHOD.
!     -------
!        THE DURATION IS DERIVED BY THE NON DIMENSIONAL GROWTH CURVE
!        ESTAR=EGRCRV*TANH(AGRCRV*TSTAR**BGRCRV).
! ----------------------------------------------------------------------
USE params
IMPLICIT NONE

REAL   , INTENT(IN) :: ewfg(niblo), usmo(niblo)
REAL   , INTENT(OUT):: t(niblo)
INTEGER, INTENT(IN) :: ijs, ijl
INCLUDE'globals.h' !NIKOS ONLY G
REAL, PARAMETER :: egrcrv=955.,agrcrv=6.02e-5,bgrcrv=0.695
REAL    :: g2, tstar, bgrcrv_inv
INTEGER :: ij
! ----------------------------------------------------------------------
!*    1. INITIALIZE DURATION.
!        -------------------
DO ij = ijs, ijl
   t(ij) = - 9.
ENDDO
g2 = g * g
bgrcrv_inv = 1. / bgrcrv
!*    2. LOOP OVER POINTS IN BLOCK.
!        --------------------------
DO ij = ijs, ijl
   IF( ewfg(ij) .GT. 0.01 ) THEN
!         DETERMINE THE EFFECTIVE DURATION OF THE WINDSEA ACCORDING TO
!         THE WAM MODEL GROWTH CURVE, IF THERE WINDSEA IS PRESENT.
      tstar = ewfg(ij) * g2 / usmo(ij) **4
      tstar = MIN (tstar / egrcrv, .999999)
      tstar = (1. + tstar) / (1. - tstar)
      tstar = (LOG (tstar) / (2. * agrcrv) ) **bgrcrv_inv
      t(ij) = usmo(ij) / g * tstar
   ENDIF
ENDDO

RETURN
END SUBROUTINE fdur
