SUBROUTINE dotdc (ijs, ijl, ig, igl, ishallo, irefra)
! ----------------------------------------------------------------------
!**** *DOTDC* - SIGMA DOT FOR CURRENT REFRACTION.
!     H. GUNTHER   GKSS/ECMWF   17/02/91
!*    PURPOSE.
!     --------
!       READ (FROM IU16) FOR PROPAGATION ..
!           - DEPTH AND CURRENT PART OF THETA DOT.
!           - SIGMA DOT TERM.
!       SCATTER SIGMA/ SINH (2*K*D) TABLE.
!**   INTERFACE.
!     ----------
!       *CALL* *DOTDC (IJS, IJL, IG, IGL, ISHALLO, IREFRA)*
!          *IJS*     - INDEX OF FIRST GRID POINT.
!          *IJL*     - INDEX OF LAST  GRID POINT.
!          *IG*      - BLOCK NUMBER.
!          *IGL*     - NUMBER OF BLOCKS.
!          *ISHALLO* - SHALLOW WATER OPTION.
!          *IREFRA*  - REFRACTION OPTION.
!     METHOD.
!     -------
!       SEQUENCIAL READ FROM UNIT.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
USE params ; use refdot ; use shallow ; use source ; use refrsource ; use units
IMPLICIT NONE

INTEGER, INTENT(IN) :: ijs, ijl, ig, igl, ishallo, irefra
INTEGER :: k, m, ij
! ----------------------------------------------------------------------
!*    1. READ COMMON REFDOT.
!        -------------------
IF( igl .NE. 1 ) THEN
   IF( ishallo .NE. 1 ) THEN
      IF( irefra .EQ. 1 ) THEN
      ELSE
         sl = sl_refr
      ENDIF
   ELSE
      DO k = 1, nang
         DO ij = 1, niblc
            sl(ij, k, nfre) = sl_refr(ij, k, nfre)
         ENDDO
      ENDDO
   ENDIF
ELSE
   IF( ishallo .NE. 1 ) THEN
      IF( irefra .EQ. 2 ) THEN
         sl = sl_refr
      ENDIF
   ELSE
      DO k = 1, nang
         DO ij = 1, niblc
            sl(ij, k, nfre) = sl_refr(ij, k, nfre)
         ENDDO
      ENDDO
   ENDIF
ENDIF

!*    2. IF DEEP WATER RETURN.
!        ---------------------
IF( ishallo .EQ. 1 ) RETURN
!
!*    3. GATHER SIGMA /SINH(2KD) FROM TABLE.
!        -----------------------------------
DO m = 1, nfre
   DO ij = ijs, ijl
      fconst(ij, m) = tsihkd(indep(ij), m)
   ENDDO
ENDDO

RETURN
END SUBROUTINE dotdc
