SUBROUTINE dismean (f3, ijs, ijl)
! ----------------------------------------------------------------------
!**** *DISMEAN* - COMPUTATION OF TOTAL DISSIPATION AT EACH GRID POINT.
!     G. KORRES
!*    PURPOSE.
!     --------
!       TO COMPUTE TOTAL WAVE DISSIPATION AT EACH GRID POINT.
!**   INTERFACE.
!     ----------
!       *CALL* *DISMEAN(F3, IJS, IJL)*
!          *F3*  - WAVE DISSIPATION
!          *IJS* - INDEX OF FIRST GRIDPOINT
!          *IJL* - INDEX OF LAST GRIDPOINT
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
USE params ; USE fredir ;USE meanpa
IMPLICIT NONE
INCLUDE'globals.h'
REAL,PARAMETER :: roair = 1.225, rowater = 1000.
REAL,PARAMETER :: xeps = roair / rowater, xinveps = 1. / xeps
REAL,ALLOCATABLE :: constf(:)

REAL   , INTENT(IN):: f3(0:niblo,nang,nfre)
INTEGER, INTENT(IN):: ijs, ijl
REAL,ALLOCATABLE   :: temp(:)
REAL    :: delt25
INTEGER :: k, m, ij
! ----------------------------------------------------------------------
!ALLOCATE(temp(ijs:ijl))
ALLOCATE(constf(nfre))
!*    1. INITIALISE DISSIPATION ARRAY.
!        ------------------------
DO ij = ijs, ijl
   wdiss(ij) = 0.1e-32
ENDDO

DO m = 1, nfre
   constf(m) = zpi * xinveps * fr(m) * dfim(m)
ENDDO


DO k = 1, nang
   DO m = 1, nfre
      DO ij = ijs, ijl
         wdiss(ij) = wdiss(ij) + f3(ij,k,m) * constf(m)
      ENDDO
   ENDDO
ENDDO

! ----------------------------------------------------------------------
!*    2. INTEGRATE OVER FREQUENCIES AND DIRECTION.
!        -----------------------------------------
!DO m = 1, nfre
!   DO ij = ijs, ijl
!      temp(ij) = 0.
!   ENDDO
!   DO  k = 1, nang
!      DO ij = ijs, ijl
!         temp(ij) = temp(ij) + f3(ij,k,m)
!      ENDDO
!   ENDDO
!   DO ij = ijs, ijl
!      wdiss(ij) = wdiss(ij) + dfim(m) * temp(ij)
!   ENDDO
!ENDDO
! ----------------------------------------------------------------------
!*    3. ADD TAIL ENERGY.
!        ----------------
!delt25 = fr(nfre) / 4. * delth
!DO ij = ijs, ijl
!   emean(ij) = emean(ij) + delt25 * temp(ij)
!ENDDO
!DEALLOCATE(temp)
DEALLOCATE(constf)

RETURN
END SUBROUTINE dismean
