SUBROUTINE difdate (idate1, idate2, ishift)
! ----------------------------------------------------------------------
!**** *DIFDATE* - TO COMPUTE TIME DIFFERENCE.
!     H. GUNTHER   GKSS/ECMWF  NOVEMBER 1989
!*    PURPOSE.
!     --------
!       COMPUTE THE SECONDS BETWEEN THE INPUT DATES.
!       DATES HAVE TO BE IN CONSECUTIVE YEARS.
!**   INTERFACE.
!     ----------
!       *CALL* *DIFDATE (IDATE1, IDATE2, ISHIFT)*
!         *IDATE1* - DATE TIME GROUP (YYMMDDHHMM).
!         *IDATE2* - DATE TIME GROUP (YYMMDDHHMM).
!         *ISHIFT* - DIFFERENCE IN SECONDS (IDATE2-IDATE1).
!     METHOD.
!     -------
!       NONE.
!     EXTERNALS.
!     ----------
!       NONE.
!      REFERENCES.
!      -----------
!       NONE.
! ----------------------------------------------------------------------
IMPLICIT NONE

CHARACTER, INTENT(IN) :: idate1  * 12, idate2 * 12
INTEGER  , INTENT(OUT):: ishift
INTEGER :: mon(12), isi, iym1, iym2, iyear1, month1, iday1, ihour1, minut1
INTEGER :: isec1, iyear2, month2, iday2, ihour2, minut2, isec2, m
CHARACTER (LEN=12) :: idt1, idt2!NIKOS , CDAT  SEEMS UNUSED
data mon / 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 /
! ----------------------------------------------------------------------
!*    1.0 CHANGE DATE TIME GROUPS TO ENSURE THAT THE SECOND IS LARGER.
!         ------------------------------------------------------------
idt1 = idate1
idt2 = idate2
isi = 60
!         END OF CENTURY CORRECTION.
isi = 1
READ(idt1(1:4) , '(I4)') iym1
READ(idt2(1:4) , '(I4)') iym2
IF( iym1 .LT. 100  .AND. iym2 .GT. 9900 )   iym1 = 10000 + iym1

IF( iym2 .LT. 100  .AND. iym1 .GT. 9900 )   iym2 = 10000 + iym2
IF( idt1 .GT. idt2 .OR.  iym1 .GT. IYM2 )  THEN
   idt1 = idate2
   idt2 = idate1
   isi = - 1
ENDIF
! ----------------------------------------------------------------------
!*    2.0 SPLIT DATE TIME GROUPS INTO MINUTE, HOUR, DAY, MONTH, YEAR.
READ(idt1, 5) iyear1, month1, iday1, ihour1, minut1, isec1
IF( iym1 .GT. 10000 )  iyear1 = iyear1 + 100

READ(idt2, 5) iyear2, month2, iday2, ihour2, minut2, isec2
IF( iym2 .GT. 10000 )  iyear2 = iyear2 + 100
! ----------------------------------------------------------------------
!*    3.0 CORRECT DAYS IN FEBRUARY OF FIRST YEAR FOR LEAP-YEAR.
!         -----------------------------------------------------
!     IF (MOD(IYEAR1,4).EQ.0) MON(2) = 29     <- Replaced operator
IF( MOD (iyear1, 4) .EQ.0) THEN
   mon(2) = 29
ELSE
   mon(2) = 28
ENDIF
! ----------------------------------------------------------------------
!*    4.0 COMPUTE TIME DIFFERENCE IN MINUTES.
!         -----------------------------------
!     4.1 DIFFERENCE BETWEEN DAY, HOUR ,MINITE.
ishift = ( ( (iday2 - iday1) * 24 + ihour2 - ihour1) * 60 + minut2 - minut1) * 60&
        + isec2 - isec1
!      4.2 ADD DIFFERENCE FROM MONTH.
IF( iyear2 .GT. iyear1 ) THEN
!      4.2.1 START AND END MONTH ARE IN DIFFERENT YEARS.
   DO m = month1, 12
      ishift = ishift + INT (mon(m) * 24 * 60 * 60)
   ENDDO
   IF( MONTH2 .GT. 1 ) THEN
      IF( MOD (iyear2, 4) .EQ. 0 ) THEN
         mon(2) = 29
      ELSE
         mon(2) = 28
      ENDIF
      DO m = 1, month2 - 1
         ishift = ishift + INT (mon(m) * 24 * 60 * 60)
      ENDDO
   ENDIF
ELSE
!      4.2.2 START AND END MONTH ARE IN THE SAME YEAR.
   IF( month2 .GT. month1 ) THEN
      DO m = month1, month2 - 1
         ishift = ishift + INT (mon(m) * 24 * 60 * 60)
      ENDDO
   ENDIF
ENDIF
! ----------------------------------------------------------------------
!*    5.0 CHANGE SIGN OF DIFFERENCE IF DATES HAVE BEEN EXCHANGED
!*        AND CONVERT TO SECONDS.
!         ------------------------------------------------------
ishift = ishift * isi
5 FORMAT(6I2.2)

RETURN
END SUBROUTINE difdate
