SUBROUTINE crewfn (iunit, wdate)  
! ----------------------------------------------------------------------
!**** *CREWFN* - CREATES A WIND FILE NAME.
!     H. GUNTHER       ECMWF      29/5/90.
!*    PURPOSE.
!     --------
!       TO CREATE A FILE NAME AND ASSIGN IT TO A UNIT.
!**   INTERFACE.
!     ----------
!        *CALL* CREWFN (IUNIT, WDATE)
!         *IUNIT*  - LOCIAL UNIT TO WHICH A FILE NAME HAS
!                    TO BE ASSIGNED.
!         *WDATE*  - DATE TIME GROUP FOR FILE NAME.
!     METHOD.
!     -------
!       FROM THE DATE TIME GROUP YYMMDDHHMM THE FILE NAME
!       WDDHHMM IS GENERATED AND ASSIGNED TO IUNIT.
!     EXTERNALS.
!     ---------
!       NONE.
!     REFERENCE.
!     ----------
!       NONE.
! ----------------------------------------------------------------------
IMPLICIT NONE

INTEGER  , INTENT(OUT):: iunit
CHARACTER, INTENT(IN) :: wdate * 12
CHARACTER :: wfn * 9

wfn(1:1) = 'W'
wfn(2:9) = wdate(5:12)
OPEN(UNIT = iunit, FILE = wfn, FORM = 'UNFORMATTED', STATUS = 'UNKNOWN')

RETURN
END SUBROUTINE crewfn
