#ifdef waves_breaking
SUBROUTINE cmpqb (hrms, hmax, qb)  
!     ADDED BY WEIMIN LUO, POL, MAY 1996
!     BASED ON THE CODE OF G. Ph. van Vledder, Delft Hydraulics
!  1. Purpose
!     Compute fraction of breaking waves for use in
!     SFBRK wave breaking dissipation function
!  2. Method
!     Newton-Raphson implementation of
!     1 - Qb
!     ------ = - (Hrms/Hmax)^2
!     ln(Qb)
!  3. Parameter list
!  4. Subroutines used
!  5. Error messages
!  6. Remarks
!     If Hrms > Hmax --> Qb = 1
!  7. Structure
!  8. Source text
!     Hrms   real  I  Root mean square wave height
!     Hmax   real  I  Maximum wave height
!     Qb     real  I  Fraction of breaking waves
implicit none

REAL, INTENT(IN)  :: hrms, hmax
REAL, INTENT(OUT) :: qb
real :: b, q0
integer :: i

if (hrms.ge.hmax) then  
   qb = 1.  
   return  
endif  
b = hrms / hmax  
q0 = 0.  
if (b.ge.0.5) q0 = (2. * b - 1.) **2  
!
do 100 i = 1, 2  
   q1 = q0 - b**2 * (q0 - exp ( (q0 - 1.) / b**2) ) / (b**2 - exp &
    ( (q0 - 1.) / b**2) )
   q0 = q1  
  100 end do  
qb = q1  
!
return  
end SUBROUTINE cmpqb
#endif
