SUBROUTINE analyse (xm, nobs, xme, xmo, xoi, imeas, jmeas, i, j, dist, ndim2)
! ----------------------------------------------------------------------
!**** *ANALYSE* - COMPUTE FIELD AT (I,J) BY OPTIMUM INTERPOLATION.
!     PIERO LIONELLO      ECMWF     JUNE 1990
!     PURPOSE.
!     --------
!       COMPUTE THE FIELD IN THE POINT (I,J) BY OPTIMUM INTERPOLATION.
!       ANALYSIS IS DONE FOR ONE GRID POINT.
!**   INTERFACE.
!     ----------
!       *CALL* *ANALYSE (XM, NOBS, XME, XMO, XOI, IMEAS, JMEAS, I, J,
!                        DIST, NDIM2)*
!         *XM*      REAL      INVERSE OF (P+M) : P=MODEL CORRELATION
!                             MATRIX , M=MEASUREMENTS CORRELATION MATRIX
!         *NOBS*    INTEGER   NUMBER OF OBSERVATION IN THE
!                             BOX AROUND POINT (I,J)
!         *XME*     REAL      FIELD FROM  MEASUREMENT
!         *XMO*     REAL      FIELD FROM MODEL
!         *XOI*     REAL      RESULT OF O.I.
!         *IMEAS*   INTEGER   X-INDICES OF MEASUREMENTS
!         *JMEAS*   INTEGER   Y-INDICES OF MEASUREMENTS
!         *I*       INTEGER   POINT WHERE O.I.FIELD IS PRODUCED
!         *J*       INTEGER   POINT WHERE O.I.FIELD IS PRODUCED
!         *DIST*    REAL      CUTOFF LENGTH OF THE SPREADING FUNCTION
!         *NDIM2*   INTEGER   DIMENSION OF IMEAS AND JMEAS
! ----------------------------------------------------------------------
use params
use gridpar
use map
implicit none

INTEGER, INTENT(IN) :: i, j, nobs, ndim2, imeas(ndim2), jmeas(ndim2)
REAL   , INTENT(IN) :: xme(ngx,ngy), xmo(ngx,ngy), dist
REAL   , INTENT(OUT):: xm(nobs,nobs), xoi
INCLUDE'globals.h'
REAL    :: XNEW, DOBS, W, DELLON, COSLON, DOBS2
INTEGER :: K, L, IOBS, JOBS, I1, I2, J1, J2, IX, JX
! ----------------------------------------------------------------------
DO L = 1, NOBS - 1  
   DO K = L + 1, NOBS  
      XM (L, K) = XM (K, L)  
   ENDDO  
ENDDO  
XNEW = 0.  
DO IOBS = 1, NOBS  
   I1 = I  
   I2 = IMEAS (IOBS)  
   J1 = J  
   J2 = JMEAS (IOBS)  
   IF ( (I1.EQ.I2) .AND. (J1.EQ.J2) ) THEN  
      DOBS = 0.  
      W = 1.  
   ELSE  
      DELLON = REAL (I1 - 1) * XDELLO - REAL (I2 - 1) * XDELLO  
      COSLON = COS (DELLON * RAD)  
      DOBS2 = COSLON * COSPH (J1) * COSPH (J2) + SINPH (J1) * SINPH (J2)
      DOBS = ACOS (DOBS2)  
      W = EXP ( - DOBS / DIST)  
   ENDIF  
   DO JOBS = 1, NOBS  
      IX = IMEAS (JOBS)  
      JX = JMEAS (JOBS)  
      XNEW = XNEW + W * XM (IOBS, JOBS) * (XME (IX, JX) - XMO (IX, JX))
   ENDDO  
ENDDO  
XOI = XMO (I, J) + XNEW  
!     IF (I.EQ.58 .AND. J.EQ.71) THEN
!     WRITE(*,*) 'O.I. DATA FOR POINT:',I,J,XOI,XMO(I,J),XME(I,J)
!     WRITE(*,*) 'IMEAS',IMEAS
!     WRITE(*,*) 'JMEAS',JMEAS
!     WRITE(*,*) 'NOBS:',NOBS
!     WRITE(*,*) 'W  XM',W,XM(1,1)
!     END IF
RETURN  
END SUBROUTINE analyse
