SUBROUTINE airsea (u10, tauw, us, z0, ijs, ijl)
! ----------------------------------------------------------------------
!**** *AIRSEA* - DETERMINE TOTAL STRESS IN SURFACE LAYER.
!     P.A.E.M. JANSSEN    KNMI      AUGUST    1990
!*    PURPOSE.
!     --------
!       COMPUTE TOTAL STRESS.
!**   INTERFACE.
!     ----------
!       *CALL* *AIRSEA (U10, TAUW, US, Z0, IJS, IJL)*
!          *U10*  - INPUT BLOCK OF WINDSPEEDS U10.
!          *TAUW* - INPUT BLOCK OF WAVE STRESSES.
!          *US*   - OUTPUT BLOCK OF SURFACE STRESSES.
!          *ZO*   - OUTPUT BLOCK OF ROUGHNESS LENGTH.
!          *IJS*  - INDEX OF FIRST GRIDPOINT.
!          *IJL*  - INDEX OF LAST GRIDPOINT.
!     METHOD.
!     -------
!       USE TABLE TAUT(TAUW,U) AND LINEAR INTERPOLATION.
!     EXTERNALS.
!     ----------
!       NONE.
!     REFERENCE.
!     ---------
!       NONE.
! ----------------------------------------------------------------------
USE params ; USE coupl ; USE table
IMPLICIT NONE

INTEGER, INTENT(IN) :: ijs, ijl
REAL   , INTENT(IN) :: u10(niblo), tauw(niblo)
REAL   , INTENT(OUT):: us(niblo), z0(niblo)
INCLUDE'globals.h'
REAL    :: deli1, deli2, delj1, delj2, x, xi, xj, ust, deltold
REAL    :: znu,z0_ch,arg,ust2
INTEGER :: i, j, ij
! ----------------------------------------------------------------------
!
!*    1. DETERMINE TOTAL STRESS FROM TABLE.
!        ----------------------------------
DO ij = ijs, ijl
   xi      = tauw(ij) / deltauw
   i       = MIN (itaumax - 1, INT (xi) )
! KORRES MODIFICATION
!  deli1   = xi - FLOAT (i)
        DELI1   = MIN(1.,XI - REAL(I))
   deli2   = 1. - deli1
   xj      = u10(ij) / delu
   j       = MIN (jumax - 1, INT (xj) )
! KORRES MODIFICATION
!  delj1   = xj - FLOAT (j)
        DELJ1   = MIN(1.,XJ - REAL(J))

   delj2   = 1. - delj1
   deltold = (taut(i,j)  * deli2 + taut(i+1,j)  * deli1) * delj2 &
            +(taut(i,j+1)* deli2 + taut(i+1,j+1)* deli1) * delj1
   us(ij)  = SQRT (deltold)
ENDDO
!*    2. DETERMINE ROUGHNESS LENGTH.
!        ---------------------------
DO ij = ijs, ijl
!  ust    = MAX (us(ij), 0.000001)
!  x      = MIN (tauw(ij) / ust**2, 0.999)
!  z0(ij) = alpha * ust**2 / (g * SQRT (1. - x) )

!  z0(ij) = alpha * ust**2 / (g * SQRT (1. - x) )
!       X  = MIN(U10(IJ)/US(IJ),100.0)
!       Z0(IJ)  = 10.*EXP(-XKAPPA*X)

        UST2 = US(IJ)**2
        ARG = MAX(1.-(TAUW(IJ)/UST2),0.00001)
        Z0(IJ)  = ALPHA*UST2/G/SQRT(ARG)


ENDDO

RETURN
END SUBROUTINE airsea
