MF	= Makefile	# Name of Makefile. Dependency for all files.


# compile with openMP profiler  FC 	= /opt/ompP/bin/kinst-ompp ifort
FC      = mpif90
	# Options used in both compile and link time.
#FFLAGS  =  -O3 -fast -ip -ipo -mcmodel=medium -shared-intel -openmp -openmp-report2
#FFLAGS	=  -fltconsistency -openmp -openmp-report2  #-auto-scalar#-tpp2
#FFLAGS	=  -fast -fltconsistency -openmp -openmp-report2  #-auto-scalar#-tpp2
#FFLAGS	=  -O3 -fltconsistency -mcmodel=large -shared-intel -openmp -openmp-report2  #-auto-scalar#-tpp2
#FFLAGS	=  -openmp -openmp-report2 -O2 -fp-model precise -mp1 -mcmodel=medium -shared-intel
FFLAGS	= -O0 -xHost -ipo -fp-model strict -mcmodel=large -shared-intel -unroll-aggressive -ftz -opt-prefetch=4 -openmp
FFLAGSMPI	= -O3 -mcmodel=large -shared-intel
#FFLAGS	= -O1 -i8 -fpic -fomit-frame-pointer -unroll-aggressive -fltconsistency -vec -ipo -ftz -mcmodel=large -shared-intel -parallel -par-num-threads=4 #-i8
#FFLAGSMPI	= -O1 -ipo -fomit-frame-pointer -unroll-aggressive -fltconsistency -vec -ftz -mcmodel=large -shared-intel -parallel -par-num-threads=4 #-openmp
#FFLAGS	= -mp1 -O3 -ip -ipo -auto-scalar -mtune=core2 -openmp -openmp-report2 #-tpp2 

	# Compiler options
FCFLAGS	=  -Dpropagation2 -Dcoarseonly -Dlinux #-I$(MKLINCLUDE) 
	# Linker only options
FLFLAGS	=  
	# List of source files.
SRCS	= airsea.F90 analyse.F90 assim.F90 bouinpt.F90 cflsub.F90 chief.F90     \
	cmpqb.F90 correct.F90 crewfn.F90 difdate.F90 dotdc.F90 f4spec.F90       \
	fdur.F90 femean.F90 fillbl.F90 fustar.F90 fwsea.F90 getdata.F90         \
	getwnd.F90 gradi.F90 gsfile.F90 headbc.F90 iecf_len.F90 implsch.F90     \
	incdate.F90 initmdl.F90 intpol.F90 intspec.F90 isamax.F90 locint.F90    \
	makeblo.F90 makegrid.F90 notim.F90 oifield.F90 openfil.F90              \
	open_scratch_file.F90 op_files.F90 outbc.F90 outbs.F90 outgrid.F90      \
	outint.F90 outpp.F90 outspec.F90 outspp.F90 peakfr.F90 prewind.F90      \
	propags1.F90 propags2.F90 propags.F90 propdot.F90 prspp.F90 prspps.F90  \
	readbou.F90 readpre.F90 readsat.F90 readwnd.F90 rotspec.F90 sasum.F90   \
	saxpy.F90 sbottom.F90 sdissip.F90 sdot.F90 semean.F90 sepwisw.F90       \
	setice.F90 sfbrk.F90 sgeco.F90 sgedi.F90 sgefa.F90 sinput.F90           \
	snonlin.F90 splitbl.F90 spr.F90 sscal.F90 sswap.F90 sthq.F90            \
	stokes_drift.F90 stresso.F90 strspec.F90 syminv.F90 timin.F90           \
	trans_grid.F90 update.F90 upwspec.F90 userin.F90 wamodel.F90 wamwnd.F90 \
	wavemdl.F90 wavenumber.F90 wsmfen.F90 initomp.F90 dismean.F90

	# List of headers. Dependency for object files.
HEADERS	= globals.h
EXE	= wamodwk	# Name of executable

# NO NEED TO EDIT BEYOND THIS LINE
.SUFFIXES: .F90 .o
OBJ	= $(SRCS:.F90=.o)

$(EXE):	$(OBJ) $(MF)
	$(FC)  $(FFLAGS) -o $@ $(OBJ) parameters.o modules.o $(FLFLAGS) 
	@echo "Compiled and linked"

.F90.o:	$(HEADERS) $(MF) parameters.o modules.o
	$(FC) $(FFLAGS) $(FCFLAGS) -c $<
#2> $<.log

$(OBJ): $(MF) parameters.o modules.o

parameters.o: parameters.F90
	$(FC) $(FCFLAGS) $(FFLAGSMPI) -c parameters.F90
modules.o   : parameters.o modules.F90
	$(FC) $(FCFLAGS) $(FFLAGSMPI) -c modules.F90

clean:
	@rm -f $(EXE) *.o *.mod core.* *.opari.inc *.mod.F opari.*
	@echo "Files removed: $(EXE), *.o, *.mod,  core.* *.opari.inc *.mod.F opari.*"

run:	$(EXE)
	@echo "Copying executable to place."
	@cp wamodwk ..
	@echo "Removing previous files from wam_in_out/swamp_nest2."
	@rm -rf ../../../wam_in_out/swamp_nest2/{REST*,MAP*,SPE*,SWS*}
	@echo "Preseting work."
	@cd  ../../../presetwk/; \
	 make run
	@echo "Executing... "
#	@cd ../;\
	 time ./wamodwk<fnames_wamod2.txt>out
rclean:
	@echo "Cleaning wam_in_out/swamp_nest2 output files"
	@rm -rf ../../../wam_in_out/swamp_nest2/{REST*,MAP*,SPE*,SWS*}
	@echo "Removing restart files: last_analysis out W091900"
	@rm -rf ../last_analysis ../out ../W091900 
