      SUBROUTINE XSTORE(COUT,CON,MWORDS)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:    XSTORE      STORES A CONSTANT VALUE INTO AN ARRAY
C   PRGMMR: KEYSER           ORG: W/NMC22    DATE: 07-02-92
C
C ABSTRACT: STORES AN 4-BYTE (FULLWORD) VALUE THROUGH CONSECUTIVE
C   STORAGE LOCATIONS.  (MOVING IS ACCOMPLISHED WITH A DO LOOP.)
C
C PROGRAM HISTORY LOG:
C   92-07-02  D. A. KEYSER (W/NMC22)
C
C USAGE:    CALL XSTORE(COUT,CON,MWORDS)
C   INPUT ARGUMENT LIST:
C     CON      - CONSTANT TO BE STORED INTO "MWORDS" CONSECUTIVE
C                FULLWORDS BEGINNING WITH "COUT" ARRAY
C     MWORDS   - NUMBER OF FULLWORDS IN "COUT" ARRAY TO STORE "CON";
C                MUST BE .GT. ZERO (NOT CHECKED FOR THIS)
C
C   OUTPUT ARGUMENT LIST:      (INCLUDING WORK ARRAYS)
C     COUT     - STARTING ADDRESS FOR ARRAY OF "MWORDS" FULLWORDS
C                SET TO THE CONTENTS OF THE VALUE "CON"
C
C REMARKS: THE VERSION OF THIS SUBROUTINE ON THE HDS COMMON LIBRARY
C   IS NAS-SPECIFIC SUBR. WRITTEN IN ASSEMBLY LANG. TO ALLOW FAST
C   COMPUTATION TIME.  SUBR. PLACED IN CRAY W3LIB TO ALLOW CODES TO
C   COMPILE ON BOTH THE HDS AND CRAY MACHINES.
C
C ATTRIBUTES:
C   LANGUAGE: Silicon Graphics 3.4 FORTRAN 77
C   MACHINE:  Silicon Graphics IRIS-4D/25, 35, INDIGO
C
C$$$
C
      DIMENSION  COUT(*)
C
      SAVE
C
      DO 1000  I = 1,MWORDS
         COUT(I) = CON
1000  CONTINUE
C
      RETURN
      END
