      PROGRAM VEG4ETA
C-----------------------------------------------------------------------
#include "all.inc"
C-----------------------------------------------------------------------
      parameter (nbx = 11401, nby = 10201)
      parameter (resland = 120., deg=1./resland)
      parameter (cxsta = -25.0, cxsto = 70.)
      parameter (cysta =   0.0, cysto = 85.)
      byte iusgs(nbx, nby)
C
      INCLUDE "soil_nl.nml"
C
      OPEN (UNIT=11,FILE='../../namelists/name.list',FORM='FORMATTED')
      READ(11,SOIL_NL)
      CLOSE(11)
      write(*,*) FN_LNDCVR
C
      OPEN(10,FILE=FN_LNDCVR,FORM='unformatted'
     &,            ACCESS='direct',RECL=nbx*nby)
      read(10,rec=1)((iusgs(i,j),i = 1, nbx),j = nby, 1, -1)
      close(10)

C--
      CALL RTLLNEW (0.,-SBD,DUMMY,BDNNEW,TPH0D,TLM0D)
      CALL RTLLNEW (WBD,-SBD,WBDNEW,DUMMY,TPH0D,TLM0D)
      CALL RTLLNEW (-WBD,-SBD,EBDNEW,DUMMY,TPH0D,TLM0D)
      CALL RTLLNEW (WBD,SBD,DUMMY,SBDNEW,TPH0D,TLM0D)
C--
      ALMIN=INT(WBDNEW/5)*5-5
      ALMAX=INT(EBDNEW/5)*5+5
      APMIN=INT(SBDNEW/5)*5-5
      APMAX=INT(BDNNEW/5)*5+5

      WRITE(*,*)'BDNNEW,WBDNEW,EBDNEW,SBDNEW'
      WRITE(*,*)BDNNEW,WBDNEW,EBDNEW,SBDNEW
      WRITE(*,*)'APMAX,ALMIN,ALMAX,APMIN'
      WRITE(*,*)APMAX,ALMIN,ALMAX,APMIN

      OPEN(UNIT=99,FILE='../src/vegparm.inc')
      WRITE(99,1098)APMAX,APMIN
      WRITE(99,1099)ALMAX,ALMIN
 1098 FORMAT('      PARAMETER (VEGNBD=',F6.1,',VEGSBD=',F6.1,')')
 1099 FORMAT('      PARAMETER (VEGEBD=',F6.1,',VEGWBD=',F6.1,')')
      CLOSE(UNIT=99)

      print*,' *************************************'
      print*,' *    RECOMPILE vegetanew.F          *'
      print*,' *************************************'

      ista = int((ALMIN - cxsta) * resland) + 1
      isto = int((ALMAX - cxsta) * resland)
      jsta = int((APMIN - cysta) * resland) + 1
      jsto = int((APMAX - cysta) * resland)
      nx = isto - ista + 1
      ny = jsto - jsta + 1

      WRITE(*,*) 'ista-isto-nx',ista,isto,nx
      WRITE(*,*) 'jsta-jsto-ny',jsta,jsto,ny

      OPEN(UNIT=29,FILE=FN_VEG4ETA,FORM='formatted')
      DO J=ny, 1 , -1
         jj = jsta + j - 1
         DO I=1, nx
            ii = ista + i - 1
            WRITE(29,'(i2)') iusgs(II,JJ)
         END DO
      END DO
      CLOSE(UNIT=29)

      stop
      end
C-----------------------------------------------------------------------
      SUBROUTINE RTLL(TLMD,TPHD,ALMD,APHD,TPH0D,TLM0D)
C-----------------------------------------------------------------------
      DTR=.01745329
C
      TPH0=TPH0D*DTR
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
C
      TLMR=TLMD*DTR
      TPHR=TPHD*DTR
      STPH=SIN(TPHR)
      CTPH=COS(TPHR)
      CTLM=COS(TLMR)
      STLM=SIN(TLMR)
C
      APH=ASIN(STPH0*CTPH*CTLM+CTPH0*STPH)
      CPH=COS(APH)
C
      ALMD=TLM0D+ASIN(STLM*CTPH/CPH)/DTR
      APHD=APH/DTR
C
      RETURN
      END
C-----------------------------------------------------------------------
      SUBROUTINE RTLLNEW (TLMD,TPHD,ALMD,APHD,TPH0D,TLM0D)
!-----------------------------------------------------------------------
      parameter (dtr=.01745329)
!-----------------------------------------------------------------------
      TPH0=TPH0D*DTR
!
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
!
      TLMR=TLMD*DTR
      TPHR=TPHD*DTR
!
      STLM=SIN(TLMR)
      CTLM=COS(TLMR)
      STPH=SIN(TPHR)
      CTPH=COS(TPHR)
!
      SPH=CTPH0*STPH+STPH0*CTPH*CTLM
      APH=ASIN(SPH)
      APHD=APH/DTR
      ANUM=CTPH*STLM
      DENOM=(CTLM*CTPH-STPH0*SPH)/CTPH0
      RELM=ATAN2(ANUM,DENOM)
      ALMD=RELM/DTR+TLM0D
!
      IF(ALMD.GT. 180.)    ALMD=ALMD-360.
      IF(ALMD.LT.-180.)    ALMD=ALMD+360.
!
      RETURN
      END
