      PROGRAM TEXT4ETA
C-----------------------------------------------------------------------
#include "all.inc"
C-----------------------------------------------------------------------
      parameter (nbx = 10800, nby = 5400)
      parameter (cxsta = -180., cxsto = 180.)
      parameter (cysta =  -90., cysto =  90.)
      parameter (DLD = 2./60.)
      byte ifaobyte(nbx, nby)
C
      INCLUDE "soil_nl.nml"
C
      OPEN (UNIT=11,FILE='../../../../namelist/name.list'
     &,     FORM='FORMATTED')
c      OPEN (UNIT=11,FILE='../src/name.list',FORM='FORMATTED')
      READ(11,SOIL_NL)
      CLOSE(11)
      write(*,*)FN_FAO
C
      OPEN(10,FILE=FN_FAO,FORM='unformatted'
     &,            ACCESS='direct',RECL=nbx*nby)
      read(10,rec=1)((ifaobyte(i,j),i = 1, nbx),j = nby, 1, -1)
      close(10)
C--
      CALL RTLLNEW (0.,-SBD,DUMMY,BDNNEW,TPH0D,TLM0D)
      CALL RTLLNEW (WBD,-SBD,WBDNEW,DUMMY,TPH0D,TLM0D)
      CALL RTLLNEW (-WBD,-SBD,EBDNEW,DUMMY,TPH0D,TLM0D)
      CALL RTLLNEW (WBD,SBD,DUMMY,SBDNEW,TPH0D,TLM0D)
C--
      ALMIN=INT(WBDNEW/5)*5-5
      ALMAX=INT(EBDNEW/5)*5+5
      APMIN=INT(SBDNEW/5)*5-5
      APMAX=INT(BDNNEW/5)*5+5

      IF (APMAX.GT.90.) APMAX = 90.   !check of North Pole

      WRITE(*,*)'BDNNEW,WBDNEW,EBDNEW,SBDNEW'
      WRITE(*,*)BDNNEW,WBDNEW,EBDNEW,SBDNEW
      WRITE(*,*)'APMAX,ALMIN,ALMAX,APMIN'
      WRITE(*,*)APMAX,ALMIN,ALMAX,APMIN


      OPEN(UNIT=99,FILE='../src/textparm.inc')

c**********Check for crossing 180 deg************pkatsaf**********
      IF (ALMIN.GT.ALMAX) THEN
         PRINT*,'text4eta:Crossing 180 deg...'
         WRITE(99,1098)APMAX,APMIN
         WRITE(99,1099)ALMIN,ALMAX
         ICROSS = 1
         IROW=(((CXSTO-ALMIN)+ABS(CXSTA-ALMAX))/DLD+1.5 - 1)
         JCOL=(((APMAX-APMIN)/DLD+1.5 ) - 1)
         WRITE(99,1097)IROW,JCOL
         WRITE(99,1100) ICROSS       !ICROSS=1-->cross180deg
      ELSE
         WRITE(99,1098)APMAX,APMIN
         WRITE(99,1099)ALMAX,ALMIN
         ICROSS = 0
         IROW=((ALMAX-ALMIN)/DLD+1.5 - 1)
         JCOL=(((APMAX-APMIN)/DLD+1.5 ) - 1)
         WRITE(99,1097)IROW,JCOL
         WRITE(99,1100) ICROSS       !ICROSS=0-->normal
      ENDIF
      
 1097 FORMAT('      PARAMETER (IROW=',I4,',JCOL=',I4,')')
 1098 FORMAT('      PARAMETER (SOILNBD=',F6.1,',SOILSBD=',F6.1,')')
 1099 FORMAT('      PARAMETER (SOILEBD=',F6.1,',SOILWBD=',F6.1,')')
 1100 FORMAT('      PARAMETER (ICROSS=',I1,')')
      CLOSE(UNIT=99)

      print*,' *************************************'
      print*,' *      RECOMPILE texteta.F          *'
      print*,' *************************************'

      ista = nint((ALMIN - cxsta) / DLD) + 1
      isto = nint((ALMAX - cxsta) / DLD)
      jsta = nint((APMIN - cysta) / DLD) + 1
      jsto = nint((APMAX - cysta) / DLD)

c**********Check for crossing 180 deg************pkatsaf**********
      if (jsto.gt.nby) then
         print*, 'WARNING: the north limit is: ', jsto
         jsto = nby
      endif
    
      if (ista.lt.isto) then
         nx = isto - ista + 1
      else
         nx = nbx - ista + isto + 1
      endif

      ny = jsto - jsta + 1

      WRITE(*,*) 'ista-isto-nx',ista,isto,nx
      WRITE(*,*) 'jsta-jsto-ny',jsta,jsto,ny

      OPEN(UNIT=29,FILE=FN_TEXT4ETA,FORM='unformatted')
      DO J=ny, 1 , -1
         jj = jsta + j - 1
         DO I=1, nx
         ii = ista + i - 1
         if (ii.gt.nbx) ii = ii - nbx      !**pkatsaf**

         ITYPD=INT(ifaobyte(II,JJ))
         IF (ifaobyte(II,JJ).LT.0) ITYPD=ifaobyte(II,JJ)+256

            if (ITYPD .eq. 0) then
                IST = 10
            elseif (ITYPD .eq. 1) then
                IST = 9
            elseif (ITYPD .eq. 2) then
                IST = 2
            elseif (ITYPD .eq. 3) then
                IST = 2
            elseif (ITYPD .eq. 4) then
                IST = 6
            elseif (ITYPD .eq. 5) then
                IST = 6
            elseif (ITYPD .eq. 6) then
                IST = 3
            elseif (ITYPD .eq. 7) then
                IST = 9
            elseif (ITYPD .eq. 8) then
                IST = 2
            elseif (ITYPD .eq. 9) then
                IST = 2
            elseif (ITYPD .eq. 10) then
                IST = 2
            elseif (ITYPD .eq. 11) then
                IST = 6
            elseif (ITYPD .eq. 12) then
                IST = 2
            elseif (ITYPD .eq. 13) then
                IST = 2
            elseif (ITYPD .eq. 14) then
                IST = 2
            elseif (ITYPD .eq. 15) then
                IST = 3
            elseif (ITYPD .eq. 16) then
                IST = 2
            elseif (ITYPD .eq. 17) then
                IST = 3
            elseif (ITYPD .eq. 18) then
                IST = 2
            elseif (ITYPD .eq. 19) then
                IST = 2
            elseif (ITYPD .eq. 20) then
                IST = 3
            elseif (ITYPD .eq. 21) then
                IST = 2
            elseif (ITYPD .eq. 22) then
                IST = 1
            elseif (ITYPD .eq. 23) then
                IST = 2
            elseif (ITYPD .eq. 24) then
                IST = 2
            elseif (ITYPD .eq. 25) then
                IST = 2
            elseif (ITYPD .eq. 26) then
                IST = 2
            elseif (ITYPD .eq. 27) then
                IST = 9
            elseif (ITYPD .eq. 28) then
                IST = 3
            elseif (ITYPD .eq. 29) then
                IST = 3
            elseif (ITYPD .eq. 30) then
                IST = 3
            elseif (ITYPD .eq. 31) then
                IST = 2
            elseif (ITYPD .eq. 32) then
                IST = 3
            elseif (ITYPD .eq. 33) then
                IST = 3
            elseif (ITYPD .eq. 34) then
                IST = 1
            elseif (ITYPD .eq. 35) then
                IST = 7
            elseif (ITYPD .eq. 36) then
                IST = 2
            elseif (ITYPD .eq. 37) then
                IST = 6
            elseif (ITYPD .eq. 38) then
                IST = 2
            elseif (ITYPD .eq. 39) then
                IST = 2
            elseif (ITYPD .eq. 40) then
                IST = 4
            elseif (ITYPD .eq. 41) then
                IST = 2
            elseif (ITYPD .eq. 42) then
                IST = 9
            elseif (ITYPD .eq. 43) then
                IST = 6
            elseif (ITYPD .eq. 44) then
                IST = 2
            elseif (ITYPD .eq. 45) then
                IST = 2
            elseif (ITYPD .eq. 46) then
                IST = 2
            elseif (ITYPD .eq. 47) then
                IST = 2
            elseif (ITYPD .eq. 48) then
                IST = 2
            elseif (ITYPD .eq. 49) then
                IST = 2
            elseif (ITYPD .eq. 50) then
                IST = 2
            elseif (ITYPD .eq. 51) then
                IST = 2
            elseif (ITYPD .eq. 52) then
                IST = 2
            elseif (ITYPD .eq. 53) then
                IST = 2
            elseif (ITYPD .eq. 54) then
                IST = 2
            elseif (ITYPD .eq. 55) then
                IST = 2
            elseif (ITYPD .eq. 56) then
                IST = 2
            elseif (ITYPD .eq. 57) then
                IST = 1
            elseif (ITYPD .eq. 58) then
                IST = 2
            elseif (ITYPD .eq. 59) then
                IST = 2
            elseif (ITYPD .eq. 60) then
                IST = 1
            elseif (ITYPD .eq. 61) then
                IST = 2
            elseif (ITYPD .eq. 62) then
                IST = 4
            elseif (ITYPD .eq. 63) then
                IST = 2
            elseif (ITYPD .eq. 64) then
                IST = 1
            elseif (ITYPD .eq. 65) then
                IST = 6
            elseif (ITYPD .eq. 66) then
                IST = 9
            elseif (ITYPD .eq. 67) then
                IST = 2
            elseif (ITYPD .eq. 68) then
                IST = 2
            elseif (ITYPD .eq. 69) then
                IST = 9
            elseif (ITYPD .eq. 70) then
                IST = 3
            elseif (ITYPD .eq. 71) then
                IST = 3
            elseif (ITYPD .eq. 72) then
                IST = 6
            elseif (ITYPD .eq. 73) then
                IST = 1
            elseif (ITYPD .eq. 74) then
                IST = 8
            elseif (ITYPD .eq. 75) then
                IST = 2
            elseif (ITYPD .eq. 76) then
                IST = 8
            elseif (ITYPD .eq. 77) then
                IST = 9
            elseif (ITYPD .eq. 78) then
                IST = 9
            elseif (ITYPD .eq. 79) then
                IST = 2
            elseif (ITYPD .eq. 80) then
                IST = 1
            elseif (ITYPD .eq. 81) then
                IST = 1
            elseif (ITYPD .eq. 82) then
                IST = 1
            elseif (ITYPD .eq. 83) then
                IST = 2
            elseif (ITYPD .eq. 84) then
                IST = 9
            elseif (ITYPD .eq. 85) then
                IST = 1
            elseif (ITYPD .eq. 86) then
                IST = 1
            elseif (ITYPD .eq. 87) then
                IST = 1
            elseif (ITYPD .eq. 88) then
                IST = 1
            elseif (ITYPD .eq. 89) then
                IST = 1
            elseif (ITYPD .eq. 90) then
                IST = 2
            elseif (ITYPD .eq. 91) then
                IST = 1
            elseif (ITYPD .eq. 92) then
                IST = 1
            elseif (ITYPD .eq. 93) then
                IST = 1
            elseif (ITYPD .eq. 94) then
                IST = 2
            elseif (ITYPD .eq. 95) then
                IST = 1
            elseif (ITYPD .eq. 96) then
                IST = 2
            elseif (ITYPD .eq. 97) then
                IST = 4
            elseif (ITYPD .eq. 98) then
                IST = 9
            elseif (ITYPD .eq. 99) then
                IST = 1
            elseif (ITYPD .eq. 100) then
                IST = 6
            elseif (ITYPD .eq. 101) then
                IST = 2
            elseif (ITYPD .eq. 102) then
                IST = 2
            elseif (ITYPD .eq. 103) then
                IST = 2
            elseif (ITYPD .eq. 104) then
                IST = 3
            elseif (ITYPD .eq. 105) then
                IST = 3
            elseif (ITYPD .eq. 106) then
                IST = 3
            elseif (ITYPD .eq. 107) then
                IST = 4
            elseif (ITYPD .eq. 108) then
                IST = 6
            elseif (ITYPD .eq. 109) then
                IST = 2
            elseif (ITYPD .eq. 110) then
                IST = 2
            elseif (ITYPD .eq. 111) then
                IST = 2
            elseif (ITYPD .eq. 112) then
                IST = 4
            elseif (ITYPD .eq. 113) then
                IST = 9
            elseif (ITYPD .eq. 114) then
                IST = 2
            elseif (ITYPD .eq. 115) then
                IST = 1
            elseif (ITYPD .eq. 116) then
                IST = 2
            elseif (ITYPD .eq. 117) then
                IST = 2
            elseif (ITYPD .eq. 118) then
                IST = 2
            elseif (ITYPD .eq. 119) then
                IST = 1
            elseif (ITYPD .eq. 120) then
                IST = 1
            elseif (ITYPD .eq. 121) then
                IST = 1
            elseif (ITYPD .eq. 122) then
                IST = 2
            elseif (ITYPD .eq. 123) then
                IST = 7
            elseif (ITYPD .eq. 124) then
                IST = 2
            elseif (ITYPD .eq. 125) then
                IST = 2
            elseif (ITYPD .eq. 126) then
                IST = 6
            elseif (ITYPD .eq. 127) then
                IST = 6
            elseif (ITYPD .eq. 128) then
                IST = 5
            elseif (ITYPD .eq. 129) then
                IST = 4
            elseif (ITYPD .eq. 130) then
                IST = 1
            elseif (ITYPD .eq. 131) then
                IST = 1
            elseif (ITYPD .eq. 132) then
                IST = 10
            elseif (ITYPD .eq. 133) then
                IST = 10
            endif

            WRITE(29) IST

         END DO
      END DO
      CLOSE(UNIT=29)

      stop
      end
C-----------------------------------------------------------------------
      SUBROUTINE RTLL(TLMD,TPHD,ALMD,APHD,TPH0D,TLM0D)
C-----------------------------------------------------------------------
      DTR=.01745329
C
      TPH0=TPH0D*DTR
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
C
      TLMR=TLMD*DTR
      TPHR=TPHD*DTR
      STPH=SIN(TPHR)
      CTPH=COS(TPHR)
      CTLM=COS(TLMR)
      STLM=SIN(TLMR)
C
      APH=ASIN(STPH0*CTPH*CTLM+CTPH0*STPH)
      CPH=COS(APH)
C
      ALMD=TLM0D+ASIN(STLM*CTPH/CPH)/DTR
      APHD=APH/DTR
C
      RETURN
      END
C-----------------------------------------------------------------------

      SUBROUTINE RTLLNEW (TLMD,TPHD,ALMD,APHD,TPH0D,TLM0D)
!-----------------------------------------------------------------------
      parameter (dtr=.01745329)
!-----------------------------------------------------------------------
      TPH0=TPH0D*DTR
!
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
!
      TLMR=TLMD*DTR
      TPHR=TPHD*DTR
!
      STLM=SIN(TLMR)
      CTLM=COS(TLMR)
      STPH=SIN(TPHR)
      CTPH=COS(TPHR)
!
      SPH=CTPH0*STPH+STPH0*CTPH*CTLM
      APH=ASIN(SPH)
      APHD=APH/DTR
      ANUM=CTPH*STLM
      DENOM=(CTLM*CTPH-STPH0*SPH)/CTPH0
      RELM=ATAN2(ANUM,DENOM)
      ALMD=RELM/DTR+TLM0D
!
      IF(ALMD.GT. 180.)    ALMD=ALMD-360.
      IF(ALMD.LT.-180.)    ALMD=ALMD+360.
!
      RETURN
      END


