C-----------------------------------------------------------------
                        P A R A M E T E R
c     &(TLM0D=08.00,TPH0D=56.50)
c     &(TLM0D=14.00,TPH0D=40.00)
     &(TLM0D=15.00,TPH0D=39.50)
c     &(TLM0D=22.50,TPH0D=39.50)
c     &(TLM0D=38.60,TPH0D=32.00)
c     &(TLM0D=45.50,TPH0D=27.50) !UAE1
c     &(TLM0D=46.50,TPH0D=27.50) !UAE2
c     &(TLM0D=50.00,TPH0D=25.30)  !UAE3
c     &(TLM0D=50.50,TPH0D=24.00)  !UAE4
c     &(TLM0D=24.01,TPH0D=37.20)  !eta_ws-HR
c     &(TLM0D=8.4,TPH0D=34.70)  !eta_ws-LR
c     &(TLM0D=13.8,TPH0D=34.70)  !camx hires
c     &(TLM0D=08.50,TPH0D=50.90)  !anemos-germany
c     &(TLM0D=26.00,TPH0D=37.00)  !GridCC
c     &(TLM0D=10.00,TPH0D=43.00)  !IBM-EMY-scenario-1
c     &(TLM0D=10.00,TPH0D=40.00)  !IBM-EMY
c     &(TLM0D=5.00,TPH0D=45.00)  !IBM-EMY-big-medium-small
c     &(TLM0D=0.00,TPH0D=46.50)  !IBM-EMY
c     &(TLM0D=-4.00,TPH0D=43.00)  !Spain-cener
c     &(TLM0D=-2.00,TPH0D=38.60)  !Spain-cener
C     Domain parameters
                        P A R A M E T E R
c     & (WBD=-26.10,SBD=-26.62,DLMD=0.12,DPHD=0.12)
c     & (WBD=-27.50,SBD=-16.00,DLMD=0.05,DPHD=0.05)
     & (WBD=-24.60,SBD=-11.50,DLMD=0.05,DPHD=0.05)
c     & (WBD=-25.18,SBD=-09.35,DLMD=0.09,DPHD=0.09)
c     & (WBD=-14.54,SBD=-12.51,DLMD=0.04,DPHD=0.04)
c     & (WBD=-14.54,SBD=-12.53,DLMD=0.06,DPHD=0.06)
c     & (WBD=-60.00,SBD=-42.00,DLMD=0.25,DPHD=0.25)
c     & (WBD=-60.00,SBD=-42.30,DLMD=0.32,DPHD=0.32)
c     & (WBD=-17.00,SBD=-15.00,DLMD=0.10,DPHD=0.10) !UAE1
c     & (WBD=-17.00,SBD=-15.40,DLMD=0.125,DPHD=0.125) !UAE2
c     & (WBD=-15.45,SBD=-13.32,DLMD=0.06,DPHD=0.06) !UAE3
c     & (WBD=-16.90,SBD=-13.32,DLMD=0.06,DPHD=0.06) !UAE4
c     & (WBD=-12.00,SBD=-11.28,DLMD=0.06,DPHD=0.06) !UAE3
c     & (WBD=-06.62,SBD=-06.80,DLMD=0.04,DPHD=0.04) !eta_ws-HR
c     & (WBD=-32.10,SBD=-25.40,DLMD=0.24,DPHD=0.24) !eta_ws-LR
c     & (WBD=-25.30,SBD=-18.50,DLMD=0.125,DPHD=0.125) !camx hires
c     & (WBD=-09.00,SBD=-09.50,DLMD=0.10,DPHD=0.10) !anemos-germany
c     & (WBD=-9.00,SBD=-9.00,DLMD=0.05,DPHD=0.05) !gridCC
c     & (WBD=-35.00,SBD=-20.00,DLMD=0.10,DPHD=0.10) !gridCC
c     & (WBD=-50.75,SBD=-25.00,DLMD=0.10,DPHD=0.10) !IBM-EMY-big
c     & (WBD=-35.75,SBD=-25.00,DLMD=0.10,DPHD=0.10) !IBM-EMY-medium
c     & (WBD=-19.60,SBD=-25.00,DLMD=0.10,DPHD=0.10) !IBM-EMY-small
c     & (WBD=-22.60,SBD=-23.00,DLMD=0.10,DPHD=0.10) !IBM-EMY-accord.what EMY provides
c     & (WBD=-26.60,SBD=-16.80,DLMD=0.10,DPHD=0.10) !IBM-EMY-scenario-1
c     & (WBD=-18.00,SBD=-16.00,DLMD=0.10,DPHD=0.10) !Spain-cener
c     & (WBD=-15.00,SBD=-13.00,DLMD=0.10,DPHD=0.10) !Spain-cener
C-----------------------------------------------------------------
                        P A R A M E T E R
     &(IM=-WBD/DLMD+1+0.5,JM=-2*SBD/DPHD+1+0.5
     &          ,IMT=2*IM-1,JMT=JM/2+1,LB=2*JMT+IMT-3
     &          ,KB=IM*2+JM-3)
                  P A R A M E T E R
     &(IMJM=IM*JM-JM/2)
                  P A R A M E T E R
     &(NBDP=2*IM+2*(JM/2-1)+1)

      PARAMETER (DTR = .01745329)
      PARAMETER (LRWK=5000000,LIWK=5000000,LAMA=60000000)
      PARAMETER (NCRA=2000000)
      DIMENSION IAMA(LAMA), IASF(120)
      DIMENSION RWRK(LRWK),IWRK(LIWK)
      DIMENSION IAIA(150),IGIA(150)
      DIMENSION ALMD(IMT,JMT),APHD(IMT,JMT)
      DIMENSION TALMD(IMT,JMT),TAPHD(IMT,JMT)
      DIMENSION PLM1(2),PLM2(2),PLM3(2),PLM4(2)
      DIMENSION HLAM(IMJM,2),HPHI(IMJM,2)
      DIMENSION BLAT(NBDP),BLON(NBDP)
      DIMENSION TBLAT(NBDP),TBLON(NBDP)
      DIMENSION BX(NBDP),BY(NBDP)
 
      DATA IASF / 120*1 /

      REAL NWLON,NWLAT,NELON,NELAT

      WRITE(*,*)' IM=',IM
      WRITE(*,*)' JM=',JM
C-----------------------------------------------------------------
      WRITE(*,*)' IM=',IM,' JM=',JM,' IMT=',IMT,' JMT=',JMT
      WRITE(*,*)'IMJM : ',IMJM,' KB : ',KB,' LB : ',LB
C-----------------------------------------------------------------
C-----------------------------------------------------------------
C------ G R A P H I C S ------------------------------------------
C-----------------------------------------------------------------
      TPH0=TPH0D*DTR
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
      X1=WBD*DTR
      X0=0.
      X2=-WBD*DTR
      Y1=SBD*DTR
      Y0=0.
      Y2=-SBD*DTR
C
      CALL  RTLL(X1,Y1,TLM0D,DTR,CTPH0,STPH0,ALDA,APDA)
      CALL  RTLL(X0,Y1,TLM0D,DTR,CTPH0,STPH0,ALDB,APDB)
      CALL  RTLL(X2,Y1,TLM0D,DTR,CTPH0,STPH0,ALDC,APDC)
      CALL  RTLL(X1,Y0,TLM0D,DTR,CTPH0,STPH0,ALDD,APDD)
      CALL  RTLL(X2,Y0,TLM0D,DTR,CTPH0,STPH0,ALDE,APDE)
      CALL  RTLL(X1,Y2,TLM0D,DTR,CTPH0,STPH0,ALDF,APDF)
      CALL  RTLL(X0,Y2,TLM0D,DTR,CTPH0,STPH0,ALDG,APDG)
      CALL  RTLL(X2,Y2,TLM0D,DTR,CTPH0,STPH0,ALDH,APDH)
C
      ALMX=AMAX1(ALDA,ALDB,ALDC,ALDD,ALDE,ALDF,ALDG,ALDH)+DLO
      APMX=AMAX1(APDA,APDB,APDC,APDD,APDE,APDF,APDG,APDH)+DLA
      ALMN=AMIN1(ALDA,ALDB,ALDC,ALDD,ALDE,ALDF,ALDG,ALDH)-DLO
      APMN=AMIN1(APDA,APDB,APDC,APDD,APDE,APDF,APDG,APDH)-DLA
C
      WRITE(*,'(a44)')'********************************************'
      WRITE(*,'(a44)')'*      West      East      North     South *'
      WRITE(*,'(a2,4F10.5,a2)')'* ',ALMN,ALMX,APMX,APMN,' *'
      WRITE(*,'(a44)')'********************************************'
C
      CALL RTLLNEW (0.,-SBD,TLM0D,TPH0D,DUMMY,BDNNEW)
      CALL RTLLNEW (WBD,-SBD,TLM0D,TPH0D,WBDNEW,DUMMY)
      CALL RTLLNEW (-WBD,-SBD,TLM0D,TPH0D,EBDNEW,DUMMY)
      CALL RTLLNEW (WBD,SBD,TLM0D,TPH0D,DUMMY,SBDNEW)
 
      WRITE(*,'(a44)')'********************************************'
      WRITE(*,'(a44)')'The model needs a LL dataset as big as this:'
      WRITE(*,'(a44)')'********************************************'
      WRITE(*,'(a44)')'*      West      East      North     South *'
      WRITE(*,'(a2,4F10.5,a2)')'* ',WBDNEW,EBDNEW,BDNNEW,SBDNEW,' *'
      WRITE(*,'(a44)')'********************************************'
 
      CALL RTLLNEW (-0.,-SBD,TLM0D,TPH0D,DUMMY,BDNNEW)
      CALL RTLLNEW (WBD,SBD,TLM0D,TPH0D,WBDNEW,DUMMY)
      CALL RTLLNEW (-WBD,SBD,TLM0D,TPH0D,EBDNEW,DUMMY)
      CALL RTLLNEW (0.,SBD,TLM0D,TPH0D,DUMMY,SBDNEW)
 
      WRITE(*,'(a44)')'********************************************'
      WRITE(*,'(a44)')'From model can be created a LL dataset up to'
      WRITE(*,'(a44)')'********************************************'
      WRITE(*,'(a44)')'*      West      East      North     South *'
      WRITE(*,'(a2,4F10.5,a2)')'* ',WBDNEW,EBDNEW,BDNNEW,SBDNEW,' *'
      WRITE(*,'(a44)')'********************************************'

C-----------------------------------------------------------------
      CALL OPNGKS
      CALL GSCLIP (1)
      CALL GSASF (IASF)
      CALL GSFAIS (1) 

      CALL GSCR (1,0, 1.,1.,1.)
      CALL GSCR (1,1, 0.,0.,0.)
      CALL GSCR (1,2, 0.,0.,1.)
      CALL GSCR (1,3, 0.,1.,0.)
      CALL GSCR (1,4, 0.,1.,0.)
      CALL GSCR (1,5, 1.,0.,0.)
      CALL GSCR (1,6, 0.35,0.35,0.35)
      CALL GSCR (1,13,0.65,0.46,0.46)
      CALL GSCR (1,14,0.,.8,1.)

!      CALL MAPPOS (0.02,0.98,0.02,0.98)
C-----------------------------------------------------------------------
      CALL MAPROJ ('CE',TPH0D,TLM0D,0.)

      CALL RTLLNEW (WBD,SBD,TLM0D,TPH0D,RLONMN,RLATMN)
      CALL RTLLNEW (-WBD,-SBD,TLM0D,TPH0D,RLONMX,RLATMX)
      print*, ' RLONMN,    RLONMX,    RLATMN,    RLATMX'
      print*, RLONMN,RLONMX,RLATMN,RLATMX 
      CALL MAPSET ('CO',RLATMN-10.,RLONMN,RLATMX+1.,RLONMX+20.)
!      CALL MAPSET ('MA',RLATMN-10.,RLONMN-10.,RLATMX+10.,RLONMX+10.)
!      CALL MAPSET ('CO',RLATMN-10.,RLONMN-10.,RLATMX+10.,RLONMX+10.)
      CALL MPSETC ('OU','PO')
 
      CALL MAPINT
      CALL ARINAM (IAMA,LAMA)
      CALL MPLNAM ('Earth..1',3,IAMA)
      CALL MAPLBL
      CALL MAPSTR ('GR',10.)
!      CALL MAPSTR ('SA - SATELLITE DISTANCE',1.)
!      CALL MAPSTR ('S1 - SATELLITE ANGLE 1',100.)
!      CALL MAPSTR ('S2 - SATELLITE ANGLE 2',15.)
      CALL MAPGRD
      CALL MPLNDR ('Earth..1',3)

      CALL GSPLCI(1)
      CALL GSLWSC(1.)

      CALL GSPLCI(2)

      DO I=1,IMT
      DO J=1,JMT
         IF(J.EQ.JMT.AND.(MOD(I,2).EQ.0)) go to 300
 
         ALMD(I,J)=WBD+(I-1)*DLMD
         IF(MOD(I,2).EQ.0) THEN
            APHD(I,J)=SBD+(J-1)*2*DPHD + DPHD
         ELSE
           APHD(I,J)=SBD+(J-1)*2*DPHD
         END IF

         CALL RTLLNEW (ALMD(I,J),APHD(I,J),TLM0D,TPH0D,
     &                 TALMD(I,J),TAPHD(I,J))
 
        CALL MAPTRA(TAPHD(I,J),TALMD(I,J),X,Y)

        CALL NGDOTS (X, Y, 1, 1.E-20,5)
!        CALL NGDOTS (X, Y, 1, 1./56000.,5)

300   END DO
      END DO
      CALL MAPGRD
      CALL MPLNDR ('Earth..1',3)

      CALL FRAME

C-----------------------------------------------------------------------
        CALL CLSGKS

	STOP
	END

C-----------------------------------------------------------------------
      SUBROUTINE RTLL(TLM,TPH,TLM0D,DTR,CTPH0,STPH0,ALMD,APHD)
C
      STPH=SIN(TPH)
      CTPH=COS(TPH)
      CTLM=COS(TLM)
      STLM=SIN(TLM)
C
      APH=ASIN(STPH0*CTPH*CTLM+CTPH0*STPH)
      CPH=COS(APH)
C
      ALMD=TLM0D+ASIN(STLM*CTPH/CPH)/DTR
      APHD=APH/DTR
C
      RETURN
      END
C-----------------------------------------------------------------------
      SUBROUTINE TLL (ALMD,APHD,TLMD,TPHD,TPH0D,TLM0D)
C-----------------------------------------------------------------------
      DTR=.01745329
C
      TPH0=TPH0D*DTR
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
C
      RELM=(ALMD-TLM0D)*DTR
      SRLM=SIN(RELM)
      CRLM=COS(RELM)
      APH=APHD*DTR
      SPH=SIN(APH)
      CPH=COS(APH)
      CC=CPH*CRLM
      ANUM=CPH*SRLM
      DENOM=CTPH0*CC+STPH0*SPH
C
      TLMD=ATAN2(ANUM,DENOM)/DTR
      TPHD=ASIN(CTPH0*SPH-STPH0*CC)/DTR
C
      RETURN
      END
C-----------------------------------------------------------------------
 
      SUBROUTINE RTLLNEW (TLMD,TPHD,TLM0D,TPH0D,ALMD,APHD)
!     ****************************************************************
!     *                                                              *
!     *  programer: z. janjic, shmz, feb. 1981                       *
!     *  ammended:  z. janjic, ncep, jan. 1996                       *
!     *                                                              *
!     *  transformation from rotated lat-lon to lat-lon coordinates  *
!     ****************************************************************
!     ****************************************************************
!     *  tlm   - transformed longitude, rad.                         *
!     *  tph   - transformed latitude, rad.                          *
!     *  tlm0d - the angle of rotation of the transformed lat-lon    *
!     *          system in the longitudinal direction, degs          *
!     *  ctph0 - cos(tph0), tph0 is the angle of rotation of the     *
!     *          transformed lat-lon systemn in the latitudinal      *
!     *          direction, precomputed                              *
!     *  stph0 - sin(tph0), tph0 is the angle of rotation of the     *
!     *          transformed lat-lon systemn in the latitudinal      *
!     *          direction, precomputed                              *
!     *  almd  - geographical longitude, degs, range -180.,180       *
!     *  aphd  - geographical latitude,  degs, range - 90., 90.,     *
!     *          poles are singular                                  *
!     ****************************************************************
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
      parameter (dtr=.01745329)
!-----------------------------------------------------------------------
      TPH0=TPH0D*DTR
!
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
!
      TLMR=TLMD*DTR
      TPHR=TPHD*DTR
!
      STLM=SIN(TLMR)
      CTLM=COS(TLMR)
      STPH=SIN(TPHR)
      CTPH=COS(TPHR)
!
      SPH=CTPH0*STPH+STPH0*CTPH*CTLM
      APH=ASIN(SPH)
      APHD=APH/DTR
      ANUM=CTPH*STLM
      DENOM=(CTLM*CTPH-STPH0*SPH)/CTPH0
      RELM=ATAN2(ANUM,DENOM)
      ALMD=RELM/DTR+TLM0D
!
      IF(ALMD.GT. 180.)    ALMD=ALMD-360.
      IF(ALMD.LT.-180.)    ALMD=ALMD+360.
!
      RETURN
      END
C//////////////////////////////////////////////////////////////////
