      SUBROUTINE imjm2ll_V(U,V,ULL,VLL)
C-----------------------------------------------------------------------
      INCLUDE "parmeta"
      INCLUDE "wave.inc"
      PARAMETER (IMT=2*IM-1,JMT=JM/2+1,LM1=LM-1,LP1=LM+1)
      PARAMETER (DTR = .01745329)
      INCLUDE "MAPOT.comm"
C-----------------------------------------------------------------------
      DIMENSION U(IM,JM),V(IM,JM)
      DIMENSION ULL(NXP,NYP), VLL(NXP,NYP)
      DIMENSION ISTV(NXP,NYP),JSTV(NXP,NYP),PPV(NXP,NYP),QQV(NXP,NYP)
C
      DO J=NYP,1,-1
      DO I=1,NXP
         ALMD=(I-1)*DELTAL+RWEST
         APHD=(J-1)*DELTAF+RSOUT
         CALL TLL(ALMD,APHD,TLMD,TPHD,TPH0D,TLM0D)
         CALL PQIJSTV(TLMD,TPHD,DLMD,DPHD,WBD,SBD,IM,JM
     &                ,ISTV(I,J),JSTV(I,J),PPV(I,J),QQV(I,J))
      END DO
      END DO
      DO J=NYP,1,-1
      DO I=1,NXP
C                       !!!! v-points !!!!!!
         LISTH=ISTV(I,J)
         LJSTH=JSTV(I,J)

         LIWST=LISTH-MOD(LJSTH+1,2)
         LJWST=LJSTH+1

         LIEST=LISTH+MOD(LJSTH,2)
         LJEST=LJSTH+1

         LINRT=LISTH
         LJNRT=LJSTH+2

         IF(LISTH.GT.00.AND.LISTH.LT.IM.
     &      AND.LJSTH.GT.00.AND.LJSTH.LT.JM.
     &      AND.LIWST.GT.00.AND.LIWST.LT.IM.
     &      AND.LJWST.GT.00.AND.LJWST.LT.JM.
     &      AND.LIEST.GT.00.AND.LIEST.LT.IM.
     &      AND.LJEST.GT.00.AND.LJEST.LT.JM.
     &      AND.LINRT.GT.00.AND.LINRT.LT.IM.
     &      AND.LJNRT.GT.00.AND.LJNRT.LT.JM)THEN
            CALL BILIN(U(LISTH,LJSTH),U(LIWST,LJWST)
     &                ,U(LIEST,LJEST),U(LINRT,LJNRT)
     &                ,ULL(I,J),PPV(I,J),QQV(I,J))
            CALL BILIN(V(LISTH,LJSTH),V(LIWST,LJWST)
     &                ,V(LIEST,LJEST),V(LINRT,LJNRT)
     &                ,VLL(I,J),PPV(I,J),QQV(I,J))
         ELSE
            print*,'V-points south outside :',LISTH,LJSTH
            print*,'V-points west outside :',LIWST,LJWST
            print*,'V-points north outside :',LINRT,LJNRT
            print*,'V-points east outside :',LIEST,LJEST
            ULL(I,J)=1.E+12
            VLL(I,J)=1.E+12
         ENDIF
      END DO
      END DO
      RETURN
      END
C//////////////////////////////////////////////////////////////////
      SUBROUTINE PQIJSTV(TLMPT,TPHPT,DLMD,DPHD,WBD,SBD,IM,JM
     &                  ,ISTH,JSTH,P,Q)
      X1=(TLMPT-WBD)/DLMD-DLMD
      Y1=(TPHPT-SBD)/DPHD
      X2=.50*( X1+Y1)
      Y2=.50*(-X1+Y1)+(IM-2)
      I2=INT(X2)
      J2=INT(Y2)
      P=X2-I2
      Q=Y2-J2
      JR=J2-(IM-2)
      ISTH=I2-JR+1
      ISTH=ISTH+1
      ISTH=(ISTH+1)/2
      JSTH=I2+JR+1
      RETURN
      END
C$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C-----------------------------------------------------------------------
!      SUBROUTINE TLL (ALMD,APHD,TLMD,TPHD,TPH0D,TLM0D)
C
C     Transformation from natural lat/lon coordinates (ALMD,APHD)
C                    to rotated coordinates (TLMD,TPHD) 
C
C-----------------------------------------------------------------------
!      DTR=.01745329
C
!      TPH0=TPH0D*DTR
!      CTPH0=COS(TPH0)
!      STPH0=SIN(TPH0)
C
!      RELM=(ALMD-TLM0D)*DTR
!      SRLM=SIN(RELM)
!      CRLM=COS(RELM)
!      APH=APHD*DTR
!      SPH=SIN(APH)
!      CPH=COS(APH)
!      CC=CPH*CRLM
!      ANUM=CPH*SRLM
!      DENOM=CTPH0*CC+STPH0*SPH
C
!      TLMD=ATAN2(ANUM,DENOM)/DTR
!      TPHD=ASIN(CTPH0*SPH-STPH0*CC)/DTR
C
!      RETURN
!      END

C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!      SUBROUTINE BILIN(H00,H01,H10,H11,HN,P,Q)
C **********************************************************************
C *                                                                    *
C *  routine for bilinear interpolation                                *
C *                                                                    *
C **********************************************************************
!      HN=H00+P*(H10-H00)+Q*(H01-H00)+P*Q*(H00-H10-H01+H11)
!      RETURN
!      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
