      SUBROUTINE imjm2ll(U10,V10,U10LL,V10LL)
C-----------------------------------------------------------------------
      INCLUDE "parmeta"
      INCLUDE "wave.inc"
      PARAMETER (IMT=2*IM-1,JMT=JM/2+1,LM1=LM-1,LP1=LM+1)
      PARAMETER (DTR = .01745329)
      INCLUDE "MAPOT.comm"
C-----------------------------------------------------------------------
      DIMENSION U10(IM,JM),V10(IM,JM)
      DIMENSION U10LL(NXP,NYP), V10LL(NXP,NYP)
      DIMENSION ISTH(NXP,NYP),JSTH(NXP,NYP),PPH(NXP,NYP),QQH(NXP,NYP)
C
      DO J=NYP,1,-1
      DO I=1,NXP
         ALMD=(I-1)*DELTAL+RWEST
         APHD=(J-1)*DELTAF+RSOUT
         CALL TLL(ALMD,APHD,TLMD,TPHD,TPH0D,TLM0D)
         CALL PQIJSTH(TLMD,TPHD,DLMD,DPHD,WBD,SBD,IM,JM
     &                ,ISTH(I,J),JSTH(I,J),PPH(I,J),QQH(I,J))
      END DO
      END DO
      DO J=NYP,1,-1
      DO I=1,NXP
C                       !!!! geop points !!!!!!
         LISTH=ISTH(I,J)
         LJSTH=JSTH(I,J)

         LIWST=LISTH-MOD(LJSTH,2)
         LJWST=LJSTH+1

         LIEST=LISTH+MOD(LJSTH+1,2)
         LJEST=LJSTH+1

         LINRT=LISTH
         LJNRT=LJSTH+2

         IF(LISTH.GT.00.AND.LISTH.LT.IM.
     &      AND.LJSTH.GT.00.AND.LJSTH.LT.JM.
     &      AND.LIWST.GT.00.AND.LIWST.LT.IM.
     &      AND.LJWST.GT.00.AND.LJWST.LT.JM.
     &      AND.LIEST.GT.00.AND.LIEST.LT.IM.
     &      AND.LJEST.GT.00.AND.LJEST.LT.JM.
     &      AND.LINRT.GT.00.AND.LINRT.LT.IM.
     &      AND.LJNRT.GT.00.AND.LJNRT.LT.JM)THEN
            CALL BILIN(U10(LISTH,LJSTH),U10(LIWST,LJWST)
     &                ,U10(LIEST,LJEST),U10(LINRT,LJNRT)
     &                ,U10LL(I,J),PPH(I,J),QQH(I,J))
            CALL BILIN(V10(LISTH,LJSTH),V10(LIWST,LJWST)
     &                ,V10(LIEST,LJEST),V10(LINRT,LJNRT)
     &                ,V10LL(I,J),PPH(I,J),QQH(I,J))
         ELSE
            print*,'H-points south outside :',LISTH,LJSTH
            print*,'H-points west outside :',LIWST,LJWST
            print*,'H-points north outside :',LINRT,LJNRT
            print*,'H-points east outside :',LIEST,LJEST
            U10LL(I,J)=1.E+12
            V10LL(I,J)=1.E+12
         ENDIF
      END DO
      END DO
      RETURN
      END
C//////////////////////////////////////////////////////////////////
      SUBROUTINE PQIJSTH(TLMPT,TPHPT,DLMD,DPHD,WBD,SBD,IM,JM
     &                  ,ISTH,JSTH,P,Q)
      X1=(TLMPT-WBD)/DLMD
      Y1=(TPHPT-SBD)/DPHD
      X2=.50*( X1+Y1)
      Y2=.50*(-X1+Y1)+(IM-1)
      I2=INT(X2)
      J2=INT(Y2)
      P=X2-I2
      Q=Y2-J2
      JR=J2-(IM-1)
      ISTH=I2-JR+1
      ISTH=(ISTH+1)/2
      JSTH=I2+JR+1
      RETURN
      END
C$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C-----------------------------------------------------------------------
      SUBROUTINE TLL (ALMD,APHD,TLMD,TPHD,TPH0D,TLM0D)
C
C     Transformation from natural lat/lon coordinates (ALMD,APHD)
C                    to rotated coordinates (TLMD,TPHD) 
C
C-----------------------------------------------------------------------
      DTR=.01745329
C
      TPH0=TPH0D*DTR
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
C
      RELM=(ALMD-TLM0D)*DTR
      SRLM=SIN(RELM)
      CRLM=COS(RELM)
      APH=APHD*DTR
      SPH=SIN(APH)
      CPH=COS(APH)
      CC=CPH*CRLM
      ANUM=CPH*SRLM
      DENOM=CTPH0*CC+STPH0*SPH
C
      TLMD=ATAN2(ANUM,DENOM)/DTR
      TPHD=ASIN(CTPH0*SPH-STPH0*CC)/DTR
C
      RETURN
      END

C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
      SUBROUTINE BILIN(H00,H01,H10,H11,HN,P,Q)
C **********************************************************************
C *                                                                    *
C *  routine for bilinear interpolation                                *
C *                                                                    *
C **********************************************************************
      HN=H00+P*(H10-H00)+Q*(H01-H00)+P*Q*(H00-H10-H01+H11)
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
      SUBROUTINE BILIN_S(H00,H01,H10,H11,
     &                   S00,S01,S10,S11,
     &                   HN,P,Q)
C **********************************************************************
C *                                                                    *
C *  routine for bilinear interpolation                                *
C *                                                                    *
C **********************************************************************
      HN=S00*H00+P*(S10*H10-S00*H00)+Q*(S01*H01-S00*H00)
     &          +P*Q*(S00*H00-S10*H10-S01*H01+S11*H11)
      RETURN
      END
