      SUBROUTINE ETA_2_WAM(U10,V10,U10LL,V10LL)
C-----------------------------------------------------------------------
      INCLUDE "parmeta"
      PARAMETER (IMT=2*IM-1,JMT=JM/2+1,LM1=LM-1,LP1=LM+1)
      PARAMETER (DTR = .01745329)
      INCLUDE "MAPOT.comm"
      INCLUDE "WAVESparam.comm"
C-----------------------------------------------------------------------
C
      DIMENSION U10(IM,JM),V10(IM,JM)
      DIMENSION U10LL(NXP,NYP), V10LL(NXP,NYP)
      DIMENSION ISTH(NXP,NYP),JSTH(NXP,NYP),PPH(NXP,NYP),QQH(NXP,NYP)
C
      DO J=NYP,1,-1
      DO I=1,NXP
         ALMD=(I-1)*DELTAL+RWEST
         APHD=(J-1)*DELTAF+RSOUT
         CALL TLL(ALMD,APHD,TLMD,TPHD,TPH0D,TLM0D)
         CALL PQIJSTH(TLMD,TPHD,DLMD,DPHD,WBD,SBD,IM,JM
     &                ,ISTH(I,J),JSTH(I,J),PPH(I,J),QQH(I,J))
      END DO
      END DO
      DO J=NYP,1,-1
      DO I=1,NXP
C                       !!!! geop points !!!!!!
         LISTH=ISTH(I,J)
         LJSTH=JSTH(I,J)

         LIWST=LISTH-MOD(LJSTH,2)
         LJWST=LJSTH+1

         LIEST=LISTH+MOD(LJSTH+1,2)
         LJEST=LJSTH+1

         LINRT=LISTH
         LJNRT=LJSTH+2

         IF(LISTH.GT.00.AND.LISTH.LT.IM.
     &      AND.LJSTH.GT.00.AND.LJSTH.LT.JM.
     &      AND.LIWST.GT.00.AND.LIWST.LT.IM.
     &      AND.LJWST.GT.00.AND.LJWST.LT.JM.
     &      AND.LIEST.GT.00.AND.LIEST.LT.IM.
     &      AND.LJEST.GT.00.AND.LJEST.LT.JM.
     &      AND.LINRT.GT.00.AND.LINRT.LT.IM.
     &      AND.LJNRT.GT.00.AND.LJNRT.LT.JM)THEN
            CALL BILIN(U10(LISTH,LJSTH),U10(LIWST,LJWST)
     &                ,U10(LIEST,LJEST),U10(LINRT,LJNRT)
     &                ,U10LL(I,J),PPH(I,J),QQH(I,J))
            CALL BILIN(V10(LISTH,LJSTH),V10(LIWST,LJWST)
     &                ,V10(LIEST,LJEST),V10(LINRT,LJNRT)
     &                ,V10LL(I,J),PPH(I,J),QQH(I,J))
         ELSE
            print*,'H-points south outside :',LISTH,LJSTH
            print*,'H-points west outside :',LIWST,LJWST
            print*,'H-points north outside :',LINRT,LJNRT
            print*,'H-points east outside :',LIEST,LJEST
            U10LL(I,J)=1.E+12
            V10LL(I,J)=1.E+12
         ENDIF
      END DO
      END DO
      RETURN
      END
C//////////////////////////////////////////////////////////////////
      SUBROUTINE PQIJSTH(TLMPT,TPHPT,DLMD,DPHD,WBD,SBD,IM,JM
     &                  ,ISTH,JSTH,P,Q)
      X1=(TLMPT-WBD)/DLMD
      Y1=(TPHPT-SBD)/DPHD
      X2=.50*( X1+Y1)
      Y2=.50*(-X1+Y1)+(IM-1)
      I2=INT(X2)
      J2=INT(Y2)
      P=X2-I2
      Q=Y2-J2
      JR=J2-(IM-1)
      ISTH=I2-JR+1
      ISTH=(ISTH+1)/2
      JSTH=I2+JR+1
      RETURN
      END
C$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
C-----------------------------------------------------------------------
      SUBROUTINE TLL (ALMD,APHD,TLMD,TPHD,TPH0D,TLM0D)
C
C     Transformation from natural lat/lon coordinates (ALMD,APHD)
C                    to rotated coordinates (TLMD,TPHD) 
C
C-----------------------------------------------------------------------
      DTR=.01745329
C
      TPH0=TPH0D*DTR
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
C
      RELM=(ALMD-TLM0D)*DTR
      SRLM=SIN(RELM)
      CRLM=COS(RELM)
      APH=APHD*DTR
      SPH=SIN(APH)
      CPH=COS(APH)
      CC=CPH*CRLM
      ANUM=CPH*SRLM
      DENOM=CTPH0*CC+STPH0*SPH
C
      TLMD=ATAN2(ANUM,DENOM)/DTR
      TPHD=ASIN(CTPH0*SPH-STPH0*CC)/DTR
C
      RETURN
      END

C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
      SUBROUTINE BILIN(H00,H01,H10,H11,HN,P,Q)
C **********************************************************************
C *                                                                    *
C *  routine for bilinear interpolation                                *
C *                                                                    *
C **********************************************************************
      HN=H00+P*(H10-H00)+Q*(H01-H00)+P*Q*(H00-H10-H01+H11)
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
      SUBROUTINE BILIN_S(H00,H01,H10,H11,
     &                   S00,S01,S10,S11,
     &                   HN,P,Q)
C **********************************************************************
C *                                                                    *
C *  routine for bilinear interpolation                                *
C *                                                                    *
C **********************************************************************
      HN=S00*H00+P*(S10*H10-S00*H00)+Q*(S01*H01-S00*H00)
     &          +P*Q*(S00*H00-S10*H10-S01*H01+S11*H11)
      RETURN
      END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

      SUBROUTINE WAM_2_ETA(BETA,beta_ETA)
C-----------------------------------------------------------------------
      INCLUDE "parmeta"
      PARAMETER (IMT=2*IM-1,JMT=JM/2+1,LM1=LM-1,LP1=LM+1)
      PARAMETER (IMJM=IM*JM-JM/2)
      PARAMETER (DTR = .01745329)
      INCLUDE "MAPOT.comm"
      INCLUDE "WAVESparam.comm"
C-----------------------------------------------------------------------
      DIMENSION beta     (NXP,NYP)
      DIMENSION beta_K   (IMJM)
      DIMENSION beta_ETA (IM,JM)
      DIMENSION GLAT(IM,JM), GLON(IM,JM), SM(IM,JM)
      DIMENSION GLAT1D(IMJM), GLON1D(IMJM), SM_K(IMJM)
C-----------------------------------------------------------------------
      DO J = 1, NYP
      DO I = 1, NXP
         if (beta(i,j).gt.100) beta(i,j) = 0.018
      ENDDO
      ENDDO
C
      DO K = 1, IMJM
         GLAT1D(K) = 0.
         GLON1D(K) = 0.
         SM_K(K) = 1. 
         beta_K (K) = 0.018 
      ENDDO  
C               
      DO J = 1, JM
      DO I = 1, IM
         beta_ETA(I,J) = 0.018
      ENDDO
      ENDDO
C     
      TPH0=TPH0D*DTR
      TLM0=TLM0D*DTR
      CTPH0=COS(TPH0)
      STPH0=SIN(TPH0)
      TPHD=SBD-DPHD
      DLMD2=2.*DLMD
      DO J=1,JM
         KHL=IM*(J-1)-(J-1)/2+1
         KHH=IM* J   -    J/2
         TPHD=TPHD+DPHD
         DO K=KHL,KHH
         TLMD=WBD+DLMD2*(K-KHL)*MOD(J,2)+(DLMD+(K-KHL)*DLMD2)*MOD(J+1,2)
            TLMR=TLMD*DTR
            TPHDR=TPHD*DTR
            CALL RTLLNEW(TLMR,TPHDR,TLM0D,DTR,CTPH0,STPH0,ALMD,APHD)
            GLON1D(K)=ALMD
            GLAT1D(K)=APHD
            X=ALMD-RWEST
            Y=APHD-RSOUT
            IN=X/DELTAL+1
            JN=Y/DELTAF+1
            X=X-(IN-1)*DELTAL
            Y=Y-(JN-1)*DELTAF
            P=X/DELTAL
            Q=Y/DELTAF
            PQ=P*Q
            I00=IN
            I10=IN+1
            I01=IN
            I11=IN+1
            J00=JN
            J10=JN
            J01=JN+1
            J11=JN+1
C----------------- BILINEAR INTERPOLATION -------------------
             IF(IN.ge.1 .AND. IN.le.(NXP-1) .AND.
     &          JN.ge.1 .AND. JN.le.(NYP-1) ) THEN
c            IF(GLON1D(K).ge.RWEST .AND. GLON1D(K).le.REAST .AND.
c     &         GLAT1D(K).ge.RSOUT .AND. GLAT1D(K).le.RNORT .AND.
c     &         SM_K(K) .eq. 1.) THEN      
                beta_K(K) = beta(IN,JN)
c               beta_K(K) = beta(I00,J00)
c     *                     +P*(beta(I10,J10)-beta(I00,J00))
c     *                     +Q*(beta(I01,J01)-beta(I00,J00))
c     *                     +PQ*(beta(I00,J00)-beta(I10,J10)
c     *                     -beta(I01,J01)+beta(I11,J11))
!               if (k.ge.50000 .AND. k.le.50010) then
!                print*,'k,in,jn,beta_K,beta,GLON1D(K),GLAT1D(K)'
!                print*,
!     .   k,in,jn,beta_K(K),beta(IN,JN),GLON1D(K),GLAT1D(K)
!               endif
            ENDIF
         ENDDO
      ENDDO
C------------------------------------------------------------
      CALL CONH12(beta_K(1),beta_ETA(1,1))
      CALL CONH12(GLAT1D, GLAT)
      CALL CONH12(GLON1D, GLON)
C------------------------------------------------------------
      bmin = 100000.
      bmax = -100000.
      bmin0 = 100000.
      bmax0 = -100000.
      DO J = 1, JM
      DO I = 1, IM
         if (beta_ETA(i,j) .lt. bmin) bmin = beta_ETA(i,j)
         if (beta_ETA(i,j) .gt. bmax) bmax = beta_ETA(i,j)
      ENDDO
      ENDDO
      DO J0 = 1, NYP
      DO I0 = 1, NXP
         if (beta(i0,j0) .lt. bmin0) bmin0 = beta(i0,j0)
         if (beta(i0,j0) .gt. bmax0) bmax0 = beta(i0,j0)
      ENDDO
      ENDDO
      print*,'bmin-bmax-bmin0-bmax0 :',bmin,bmax,bmin0,bmax0
      print*,'------------------------------------------------------'
C------------------------------------------------------------
      end
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
                         SUBROUTINE CONH12(HI1,HI2)
C     ******************************************************************
C     *                                                                *
C     *  ROUTINE FOR REORDERING THIBUE-HEIGHT-POINT-1-DIMENSIONAL      *
C     *  MATRICES FOR 2-DIMENSIONAL INDEXING                           *
C     *                                                                *
C     ******************************************************************
      INCLUDE "parmeta"
      PARAMETER (IMT=2*IM-1,JMT=JM/2+1,LM1=LM-1,LP1=LM+1)
      PARAMETER (IMJM=IM*JM-JM/2)
      INCLUDE "MAPOT.comm"
      INCLUDE "WAVESparam.comm"
C-----------------------------------------------------------------------
                             D I M E N S I O N
     & HI2    (IM,JM),HI1    (IMJM)
C-----------------------------------------------------------------------
      K=0
              DO 100 J=1,JM
          DO 100 I=1,IM-1+MOD(J,2)
      K=K+1
  100  HI2(I,J)=HI1(K)
              DO 101 J=2,JM-1,2
  101  HI2(IM,J)=HI2(IM-1,J)
C-----------------------------------------------------------------------
                             RETURN
                             END
C&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
      SUBROUTINE RTLLNEW (TLMD,TPHD,TLM0D,DTR,CTPH0,STPH0,ALMD,APHD)
      STLM=SIN(TLMD)
      CTLM=COS(TLMD)
      STPH=SIN(TPHD)
      CTPH=COS(TPHD)
!
      SPH=CTPH0*STPH+STPH0*CTPH*CTLM
      APH=ASIN(SPH)
      APHD=APH/DTR
      ANUM=CTPH*STLM
      DENOM=(CTLM*CTPH-STPH0*SPH)/CTPH0
      RELM=ATAN2(ANUM,DENOM)
      ALMD=RELM/DTR+TLM0D
!
      IF(ALMD.GT. 180.)    ALMD=ALMD-360.
      IF(ALMD.LT.-180.)    ALMD=ALMD+360.
!
      RETURN
      END
