C     Arrays are dimensioned to accommodate T213/N160 data volumes.
C
      INTEGER JPACK, JPBYTES
      PARAMETER (JPACK=280000)
      PARAMETER (JPBYTES=4)
C                        `---> The number of bytes in an INTEGER
C
C     Integer arguments for GRIBEX call
C
      INTEGER KSEC0(2)
      INTEGER KSEC1(1024)
      INTEGER KSEC2(1024)
      INTEGER KSEC3(2)
      INTEGER KSEC4(512)
      INTEGER KGDS(200)
C
C     Floating point arguments for GRIBEX call
C
      REAL PSEC2(512)
      REAL PSEC3(2)
      REAL PSEC4(JPACK*5)
C
C     Array for the GRIB product
C
      INTEGER KGRIB
      DIMENSION KGRIB(JPACK)
C
      INTEGER FILE, JCOUNT, NUMERR, KLENG, LENOUT
      INTEGER KLENP, KRET, KWORD, LOOP
C
      PARAMETER (NLEV=16, NSFC=16)
      REAL PR(NLEV),AMIN(NLEV),AMAX(NLEV)
C
      REAL,ALLOCATABLE:: FPDATA2D(:,:)
      REAL,ALLOCATABLE:: HD(:,:,:), QD(:,:,:)
      REAL,ALLOCATABLE:: UD(:,:,:), VD(:,:,:),SRFC(:,:,:)
C
      CHARACTER CARG1*6,CARG2*2, CARG3*3
      CHARACTER CED*4
      CHARACTER FFNAME*128,FTMP*64
      CHARACTER FN_GRIB*128,OUTDIR*128
      CHARACTER ATIME*11

      DIMENSION IDAT(3), IDATS(3)
      REAL ESAT,ES
      DATA PR/1000.,925.,850.,700.,500.,400.,300.,250.
     $        ,200.,150.,100.,70.,50.,30.,20.,10./

C
C --Check the command input
C
      read(5,'(a)')   FN_GRIB
      read(5,'(a)')   outdir
!      read(5,'(3I2)') idat
!      read(5,'(I2)')  ihrst      
!      read(5,'(I3)')  ihr     


!      CALL GETARG (1,fn_grib)
!      CALL GETARG (2,outdir)

      print*,fn_grib
      print*,outdir

C
C --End command input
C
C
      print*,'Decoding file: ',FN_GRIB(1:INDEX(FN_GRIB,' '))
C
C     Open the data file
C
      CALL PBOPEN(FILE, FN_GRIB, 'r', KRET)
      IF( KRET.NE.0 ) THEN
        WRITE (*, *) 'GRDEMO: Return code from PBOPEN = ',KRET
        CALL PBCLOSE(FILE, KRET)
        STOP 'Fault in PBOPEN'
      ENDIF
C
C     Loop through GRIB products in the file.
C
      NUMERR = 0
      JCOUNT = 0
C
   50 CONTINUE
C
C     Increment count of products.
C
      JCOUNT = JCOUNT + 1
C
C     Read the GRIB-coded field into KGRIB.
C
      KLENG = JPACK*JPBYTES
      CALL PBGRIB( FILE, KGRIB, KLENG, LENOUT, KRET )
      IF( KRET.LT.0 ) THEN
        IF( KRET.EQ.-1 ) THEN
          WRITE  (*, *) 'GRDEMO: End of file.'
          WRITE(*,*) 'GRDEMO: Number of products =',(JCOUNT-1)
          CALL PBCLOSE(FILE, KRET)
          WRITE (*,*) 'GRDEMO: Number of decoding errors = ',NUMERR
          GOTO 100
!!          STOP 'EOF'
        ELSE
          WRITE (*, *) 'GRDEMO: Return code from PBGRIB = ',KRET
          WRITE (*, *) 'GRDEMO: after ', JCOUNT,' products.'
          CALL PBCLOSE(FILE, KRET)
          STOP 'Fault in PBGRIB'
        ENDIF
      ENDIF
!      WRITE (*, *) 'GRDEMO: Return length from PBGRIB = ',LENOUT
C
C     Decode (unpack) entire GRIB message.
C
      KLENG = (LENOUT+JPBYTES-1)/JPBYTES
      KLENP = JPACK*5
      KRET = 1
      CALL GRIBEX(KSEC0,KSEC1,KSEC2,PSEC2,KSEC3,PSEC3,KSEC4,
     X            PSEC4,KLENP,KGRIB,KLENG,KWORD,'D',KRET)
C
C  *** Some checks for the data validity ***
C  *** KSEC1(7) 100 is isobaric, 1 is sfc, 112 is soil ***
      IF(KSEC1(7).NE.100 .AND. KSEC1(7).NE.1 .AND.
     $   KSEC1(7).NE.112 .AND. KSEC1(7).NE.109) GO TO 50
C
C  *** Check the Vertical Levels***
C  
      L=9999
      DO LV=1,NLEV
         IF((KSEC1(7).EQ.100).AND.(KSEC1(8).EQ.PR(LV))) L=LV
      ENDDO
      IF ((KSEC1(7).EQ.1).AND.(KSEC1(8).EQ.0)) L=0
      IF ((KSEC1(7).EQ.109).AND.(KSEC1(8).EQ.1)) L=0
      IF ((KSEC1(7).EQ.112).AND.(KSEC1(8).EQ.0))  L=1
      IF ((KSEC1(7).EQ.112).AND.(KSEC1(8).EQ.7))  L=2
      IF ((KSEC1(7).EQ.112).AND.(KSEC1(8).EQ.28)) L=3
      IF ((KSEC1(7).EQ.112).AND.(KSEC1(8).EQ.100))L=4
      IF (L.EQ.9999) GOTO 50
C
C     Check return code.
C
      WRITE (*,*) 'GRDEMO: GRIBEX return code = ',KRET
      IF( KRET.EQ.-6 ) WRITE (*,*) 'GRDEMO: Pseudo-grib data found.'
      IF( KRET.GT.0 ) THEN
        NUMERR = NUMERR + 1
        GOTO 50
      ENDIF
C
C     Print section 0 , 1 , 2 and 3 (if present) and 4.
C     Section 1 is the product definition section.
C     Section 2 is the grid definition section.
C     Section 3 is the bitmap section.
C     Section 4 is the data section.
C
!      CALL GRPRS0(KSEC0)
!      CALL GRPRS1(KSEC0,KSEC1)
C
!      IF( (KSEC1(5).EQ.0).OR.(KSEC1(5).EQ.64) ) THEN
!        WRITE (*,*) 'GRDEMO: No section 2 in GRIB message.'
!      ELSE
!        CALL GRPRS2(KSEC0,KSEC2,PSEC2)
!      ENDIF
C
!      IF( (KSEC1(5).EQ.0).OR.(KSEC1(5).EQ.128) ) THEN
!        WRITE (*,*) 'GRDEMO: No section 3 in GRIB message.'
!      ELSE
!        CALL GRPRS3(KSEC0,KSEC3,PSEC3)
!      ENDIF
C
!      CALL GRPRS4(KSEC0,KSEC4,PSEC4)
C
C     Define and Open the Output Files
C
      IF (JCOUNT.EQ.1) THEN
         ALLOCATE(FPDATA2D(KSEC2(2),KSEC2(3)))
         ALLOCATE(HD(KSEC2(2),KSEC2(3),NLEV))
         ALLOCATE(UD(KSEC2(2),KSEC2(3),NLEV))
         ALLOCATE(VD(KSEC2(2),KSEC2(3),NLEV))
         ALLOCATE(QD(KSEC2(2),KSEC2(3),NLEV))
         ALLOCATE(SRFC(KSEC2(2),KSEC2(3),NSFC))

         IDAT(1)=KSEC1(12)
         IDAT(2)=KSEC1(11)
         IDAT(3)=KSEC1(10)
         IHRST=KSEC1(13)
         IHR=KSEC1(16)
         N=INDEX(OUTDIR,' ')-1
         WRITE(ATIME,'(I2.2,I2.2,I2.2,I2.2,I3.3)') 
     &         IDAT(3),IDAT(2),IDAT(1),IHRST,IHR
         FFNAME=OUTDIR(1:N)//'/'//ATIME//'.ETA_ecm'
         OPEN (UNIT=16,FILE=FFNAME,STATUS='UNKNOWN',FORM='UNFORMATTED')
         WRITE(CED,'(I4.4)')IHR
         FTMP=OUTDIR(1:N)//'/minmax-ecm.'
         ISTR2=INDEX(FTMP,' ')-1
         FTMP(ISTR2+1:ISTR2+4)=CED(1:4)
         FTMP(ISTR2+5:ISTR2+8)='.DAT'
         OPEN (12,FILE=FTMP(1:ISTR2+8),FORM='FORMATTED')
      ENDIF
C
C     Convert 1D to 2D
C
      INDX=0
      DO JJ=KSEC2(3),1,-1
      DO II=1,KSEC2(2)
         INDX=INDX+1
         FPDATA2D(II,JJ)=PSEC4(INDX)
      ENDDO
      ENDDO
C
C     Print out the data values
C
C     129 is Geopotential (m**2 s**-2)
      IF (KSEC1(6).EQ.129 .AND. KSEC1(7).EQ.100) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS 
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN

            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               HD(ii,jj,l)=FPDATA2D(ii,jj)/9.81
            END DO
            END DO
            PRINT*,JCOUNT,' Geopotential at',KSEC1(8),L,'level',PR(L)
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     131 is U-velocity (m s**-1)
      IF (KSEC1(6).EQ.131 .AND. KSEC1(7).EQ.100) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               UD(ii,jj,l)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' U-velocity at',KSEC1(8),L,'level',PR(L)
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     132 is V-velocity (m s**-1)
      IF (KSEC1(6).EQ.132 .AND. KSEC1(7).EQ.100) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               VD(ii,jj,l)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' V-velocity at',KSEC1(8),L,'level',PR(L)
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     133 is Specific humidity (Kg/Kg)
      IF (KSEC1(6).EQ.133 .AND. KSEC1(7).EQ.100) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               QD(ii,jj,l)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,'Spec. Humidity at',KSEC1(8),L,'level',PR(L)
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     172 is Land/Sea Mask (0/1)
      IF (KSEC1(6).EQ.172 .AND. KSEC1(7).EQ.1) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,1)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,'Land/Sea Mask (0/1) at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     151 is Mean Sea-Level Pressure (Pa)
      IF (KSEC1(6).EQ.151 .AND. KSEC1(7).EQ.1) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,2)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,'Mean SeaLevel Pressure at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     134 is Surface Pressure (Pa)
      IF ((KSEC1(6).EQ.134 .AND. KSEC1(7).EQ.109 .AND. KSEC2(1).EQ.0) 
     &.OR.
     &    (KSEC1(6).EQ.134 .AND. KSEC1(7).EQ.1 .AND. KSEC2(1).EQ.10) )
     &THEN
cioan      IF (KSEC1(6).EQ.134 .AND. KSEC1(7).EQ.1) THEN  ! rotated
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,3)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,'Surface Pressure at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     129 is  Geopotential (m2/s2)
      IF (KSEC1(6).EQ.129 .AND. KSEC1(7).EQ.1) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,4)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,'Surface Geopotential at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     139,170,183,236 is Soil Temperature (K)
      IF (KSEC1(6).EQ.139 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,5)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Temperature at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     139,170,183,236 is Soil Temperature (K)
      IF (KSEC1(6).EQ.170 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,7)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Temperature at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     139,170,183,236 is Soil Temperature (K)
      IF (KSEC1(6).EQ.183 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,9)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Temperature at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     139,170,183,236 is Soil Temperature (K)
      IF (KSEC1(6).EQ.236 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,11)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Temperature at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     140,171,184,237 is Soil Moisture(39,40,41,42)
      IF (KSEC1(6).EQ.039 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,6)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Moisture at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     140,171,184,237 is Soil Moisture(39,40,41,42)
      IF (KSEC1(6).EQ.040 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,8)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Moisture at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     140,171,184,237 is Soil Moisture(39,40,41,42)
      IF (KSEC1(6).EQ.041 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,10)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Moisture at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     140,171,184,237 is Soil Moisture(39,40,41,42)
      IF (KSEC1(6).EQ.042 .AND. KSEC1(7).EQ.112) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(16)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
 
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
               SRFC(ii,jj,12)=FPDATA2D(ii,jj)
            END DO
            END DO
            PRINT*,JCOUNT,' Soil Moisture at',KSEC1(8),L,'level'
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C
C     Go round again for the next GRIB message.
C
      GOTO 50
 100  CONTINUE
C
C     Write out the decoded fields
C
      WRITE(16)NLEV
      WRITE(16)UD
      WRITE(16)VD
      WRITE(16)HD
      WRITE(16)QD
      WRITE(16)PR
      WRITE(16)SRFC
      CLOSE (16)
C
C ------ saving geographical info -------
C
      DO II=1,200
         KGDS(II)=KSEC2(II)
      ENDDO
      ITMP=KGDS(4)
      KGDS(4)=KGDS(7)
      KGDS(7)=ITMP
 
      PRINT*,'writing kgds',(kgds(ii),ii=1,14)
 
      OPEN (UNIT=17,FILE="../../data/prep/gdsinfo.ETA_ecm",
     $form='unformatted',access='sequential')
      write(17)KGDS
      CLOSE(17)
C
C ------ saving grib time/date info -------
C
      OPEN (UNIT=18,FILE="../../SCRIPTS/grib-date.ecm",FORM='FORMATTED')
      WRITE(18,'(I2.2)') KSEC1(12)
      WRITE(18,'(I2.2)') KSEC1(11)
      WRITE(18,'(I4.4)') KSEC1(10)+2000
      WRITE(18,'(I2.2)') KSEC1(13)
      WRITE(18,'(I2.2)') KSEC1(16)
      CLOSE(18)
C
C
C ------ some diagnostics -------
C
      write(12,*)'IDAT: ',IDAT,' IHRST: ',IHRST,' IHR: ',IHR
      DO L=1,NLEV
         write(12,*)'======================================='
         write(12,*)'Level: ',L,' --> ',PR(L),' hPa'
         amin(L) = 100000.
         amax(L) = -100000.
         do jj=1,KSEC2(3)
         do ii=1,KSEC2(2)
           if (HD(ii,jj,l) .ge. amax(l)) amax(l)=HD(ii,jj,l)
           if (HD(ii,jj,l) .le. amin(l)) amin(l)=HD(ii,jj,l)
         enddo
         enddo
         write(12,*)'G.H : amin,amax',amin(l),amax(l)
C
         amin(l) = 100000.
         amax(l) = -100000.
         do jj=1,KSEC2(3)
         do ii=1,KSEC2(2)
           if (UD(ii,jj,l) .ge. amax(l)) amax(l)=UD(ii,jj,l)
           if (UD(ii,jj,l) .le. amin(l)) amin(l)=UD(ii,jj,l)
         enddo
         enddo
         write(12,*)'U : amin,amax',amin(l),amax(l)
C
         amin(l) = 100000.
         amax(l) = -100000.
         do jj=1,KSEC2(3)
         do ii=1,KSEC2(2)
           if (VD(ii,jj,l) .ge. amax(l)) amax(l)=VD(ii,jj,l)
           if (VD(ii,jj,l) .le. amin(l)) amin(l)=VD(ii,jj,l)
         enddo
         enddo
         write(12,*)'V : amin,amax',amin(l),amax(l)
C
         amin(l) = 100000.
         amax(l) = -100000.
         do jj=1,KSEC2(3)
         do ii=1,KSEC2(2)
           if (QD(ii,jj,l) .ge. amax(l)) amax(l)=QD(ii,jj,l)
           if (QD(ii,jj,l) .le. amin(l)) amin(l)=QD(ii,jj,l)
         enddo
         enddo
         write(12,*)'Q : amin,amax',amin(l),amax(l)
      ENDDO

      write(12,*)
      write(12,*)'SURFACE FIELDS'
      DO L=1,NSFC
         amin(l) = 1000000.
         amax(l) = -1000000.
         do jj=1,KSEC2(3)
         do ii=1,KSEC2(2)
           if (SRFC(ii,jj,l).ge.amax(l))amax(l)=SRFC(ii,jj,l)
           if (SRFC(ii,jj,l).le.amin(l))amin(l)=SRFC(ii,jj,l)
         enddo
         enddo
         write(12,*)L,'SFC FIELD : amin,amax',amin(l),amax(l)
      ENDDO

      CLOSE(12)

      STOP
      END
