C     Arrays are dimensioned to accommodate T213/N160 data volumes.
C
      INTEGER JPACK, JPBYTES
      PARAMETER (JPACK=280000)
      PARAMETER (JPBYTES=4)
C                        `---> The number of bytes in an INTEGER
C
C     Integer arguments for GRIBEX call
C
      INTEGER KSEC0(2)
      INTEGER KSEC1(1024)
      INTEGER KSEC2(1024)
      INTEGER KSEC3(2)
      INTEGER KSEC4(512)
C
C     Floating point arguments for GRIBEX call
C
      REAL PSEC2(512)
      REAL PSEC3(2)
      REAL PSEC4(JPACK*5)
C
C     Array for the GRIB product
C
      INTEGER KGRIB
      DIMENSION KGRIB(JPACK)
C
      INTEGER FILE, JCOUNT, NUMERR, KLENG, LENOUT
      INTEGER KLENP, KRET, KWORD, LOOP

      REAL,ALLOCATABLE:: FPDATA2D(:,:)
C
      CHARACTER CARG1*6,CARG2*2, CARG3*3
      CHARACTER CED*4
      CHARACTER FFNAME*128,FTMP*128
      CHARACTER FN_GRIB*128,OUTDIR*128
      CHARACTER ATIME*11

      DIMENSION IDAT(3), IDATS(3)
      REAL ESAT,ES, AMIN, AMAX

C
C --Check the command input
C
!      read(5,'(a)')   FN_GRIB
!      read(5,'(a)')   outdir
!      read(5,'(3I2)') idat
!      read(5,'(I2)')  ihrst      
!      read(5,'(I3)')  ihr     


      CALL GETARG (1,fn_grib)
      CALL GETARG (2,outdir)

      print*,fn_grib
      print*,outdir

C
C --End command input
C
C
      print*,'Decoding file: ',FN_GRIB(1:INDEX(FN_GRIB,' '))
C
      I=0
C
C     Open the data file
C
      CALL PBOPEN( FILE, FN_GRIB, 'r', KRET)
      IF( KRET.NE.0 ) THEN
        WRITE (*, *) 'GRDEMO: Return code from PBOPEN = ',KRET
        CALL PBCLOSE(FILE, KRET)
        STOP 'Fault in PBOPEN'
      ENDIF
C
C     Loop through GRIB products in the file.
C
      NUMERR = 0
      JCOUNT = 0
C
   50 CONTINUE
C
C     Increment count of products.
C
      JCOUNT = JCOUNT + 1
C
C     Read the GRIB-coded field into KGRIB.
C
      KLENG = JPACK*JPBYTES
      CALL PBGRIB( FILE, KGRIB, KLENG, LENOUT, KRET )
      IF( KRET.LT.0 ) THEN
        IF( KRET.EQ.-1 ) THEN
          WRITE  (*, *) 'GRDEMO: End of file.'
          WRITE(*,*) 'GRDEMO: Number of products =',(JCOUNT-1)
          CALL PBCLOSE(FILE, KRET)
          WRITE (*,*) 'GRDEMO: Number of decoding errors = ',NUMERR
          STOP 'EOF'
        ELSE
          WRITE (*, *) 'GRDEMO: Return code from PBGRIB = ',KRET
          WRITE (*, *) 'GRDEMO: after ', JCOUNT,' products.'
          CALL PBCLOSE(FILE, KRET)
          STOP 'Fault in PBGRIB'
        ENDIF
      ENDIF
      WRITE (*, *) 'GRDEMO: Return length from PBGRIB = ',LENOUT
C
C     Decode (unpack) entire GRIB message.
C
      KLENG = (LENOUT+JPBYTES-1)/JPBYTES
      KLENP = JPACK*5
      KRET = 1
      CALL GRIBEX(KSEC0,KSEC1,KSEC2,PSEC2,KSEC3,PSEC3,KSEC4,
     X            PSEC4,KLENP,KGRIB,KLENG,KWORD,'D',KRET)
C
C     Check return code.
C
      WRITE (*,*) 'GRDEMO: GRIBEX return code = ',KRET
      IF( KRET.EQ.-6 ) WRITE (*,*) 'GRDEMO: Pseudo-grib data found.'
      IF( KRET.GT.0 ) THEN
        NUMERR = NUMERR + 1
        GOTO 50
      ENDIF
C
C     Print section 0 , 1 , 2 and 3 (if present) and 4.
C     Section 1 is the product definition section.
C     Section 2 is the grid definition section.
C     Section 3 is the bitmap section.
C     Section 4 is the data section.
C
      CALL GRPRS0(KSEC0)
      CALL GRPRS1(KSEC0,KSEC1)
C
      IF( (KSEC1(5).EQ.0).OR.(KSEC1(5).EQ.64) ) THEN
        WRITE (*,*) 'GRDEMO: No section 2 in GRIB message.'
      ELSE
        CALL GRPRS2(KSEC0,KSEC2,PSEC2)
      ENDIF
C
      IF( (KSEC1(5).EQ.0).OR.(KSEC1(5).EQ.128) ) THEN
        WRITE (*,*) 'GRDEMO: No section 3 in GRIB message.'
      ELSE
        CALL GRPRS3(KSEC0,KSEC3,PSEC3)
      ENDIF
C
      CALL GRPRS4(KSEC0,KSEC4,PSEC4)
C
C     Define and Open the Output Files
C
      IF (JCOUNT.EQ.1) THEN
         ALLOCATE(FPDATA2D(KSEC2(2),KSEC2(3)))

         IDAT(1)=KSEC1(12)
         IDAT(2)=KSEC1(11)
         IDAT(3)=KSEC1(10)
         IHRST=KSEC1(13)
         IHR=KSEC1(14)
         N=INDEX(OUTDIR,' ')-1
         WRITE(ATIME,'(I2.2,I2.2,I2.2,I2.2,I3.3)') 
     &         IDAT(3),IDAT(2),IDAT(1),IHRST,IHR
cpk         FFNAME=OUTDIR(1:N)//'/'//ATIME//'.ETA_SST'
         FFNAME=OUTDIR(1:N)//'/ecmwf-sst.dat'
         OPEN (UNIT=16,FILE=FFNAME,STATUS='UNKNOWN',FORM='FORMATTED')
         WRITE(16,*) KSEC2(2),KSEC2(3),KSEC2(9),KSEC2(10),
     &             KSEC2(5),KSEC2(8),KSEC2(7),KSEC2(4)
         WRITE(CED,'(I4.4)')IHR
         FTMP=OUTDIR(1:N)//'/minmax-sst.DAT'
         print*,'Diagnostics at: ',FTMP(1:75)
cpk         ISTR2=INDEX(FTMP,' ')-1
cpk         FTMP(ISTR2+1:ISTR2+4)=CED(1:4)
cpk         FTMP(ISTR2+5:ISTR2+8)='.DAT'
         OPEN (12,FILE=FTMP,FORM='FORMATTED')
         WRITE(12,*) KSEC2(2),KSEC2(3),KSEC2(9),KSEC2(10),
     &               KSEC2(5),KSEC2(8),KSEC2(7),KSEC2(4)
         WRITE(12,*) KSEC1(12), KSEC1(11), KSEC1(10), 
     &               KSEC1(13), KSEC1(14)
      ENDIF
C
C     Convert 1D to 2D
C
      INDX=0
      DO JJ=KSEC2(3),1,-1
      DO II=1,KSEC2(2)
         INDX=INDX+1
         FPDATA2D(II,JJ)=PSEC4(INDX)
      ENDDO
      ENDDO
C
C     Print out the data values
C
C     Sea Surface Temperature (K)  SSTK
      IF (KSEC1(6).EQ.034 .AND. KSEC1(7).EQ.1) THEN
         WRITE(*,*) 'Data values for the requested product ', JCOUNT
         IDATS(1)=KSEC1(12)
         IDATS(2)=KSEC1(11)
         IDATS(3)=KSEC1(10)
         IHRSTS=KSEC1(13)
         IHRS=KSEC1(14)
         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS 
     &       .AND. IDAT(1).EQ.IDATS(1)) THEN

            PRINT*,'WRITE TO FILE: ',FFNAME(1:N+20)
            WRITE(16,*) FPDATA2D
            PRINT*,'WRITE TO FILE: ',FTMP
            AMIN = 100000.
            AMAX = -100000.
            DO JJ=1,KSEC2(3)
            DO II=1,KSEC2(2)
              IF (FPDATA2D(II,JJ).GT.270.) THEN
                 IF (FPDATA2D(II,JJ).GE.AMAX) AMAX=FPDATA2D(II,JJ)
                 IF (FPDATA2D(II,JJ).LT.AMIN) AMIN=FPDATA2D(II,JJ)
              ENDIF
            ENDDO
            ENDDO
            WRITE(12,*)'SST FIELD : AMIN,AMAX',AMIN,AMAX
         ELSE
            STOP "Date Mismatch"
         ENDIF
      ENDIF
C     Sea Ice (0/1)  SI
cpk      IF (KSEC1(6).EQ.031 .AND. KSEC1(7).EQ.1) THEN
cpk         WRITE(*,*) 'Data values for the requested product ', JCOUNT
cpk         IDATS(1)=KSEC1(12)
cpk         IDATS(2)=KSEC1(11)
cpk         IDATS(3)=KSEC1(10)
cpk         IHRSTS=KSEC1(13)
cpk         IHRS=KSEC1(14)
cpk         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
cpk     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
cpk 
cpk            PRINT*,'WRITE TO FILE: ',FFNAME(1:N+20)
cpk            WRITE(16) FPDATA2D
cpk            PRINT*,'WRITE TO FILE: ',FTMP
cpk            AMIN = 100000.
cpk            AMAX = -100000.
cpk            DO JJ=1,KSEC2(3)
cpk            DO II=1,KSEC2(2)
cpk              IF (FPDATA2D(II,JJ).GE.AMAX) AMAX=FPDATA2D(II,JJ)
cpk              IF (FPDATA2D(II,JJ).LT.AMIN) AMIN=FPDATA2D(II,JJ)
cpk            ENDDO
cpk            ENDDO
cpk            WRITE(12,*)'SI FIELD : AMIN,AMAX',AMIN,AMAX
cpk         ELSE
cpk            STOP "Date Mismatch"
cpk         ENDIF
cpk      ENDIF
C     Land Sea Mask (0/1)  LSM
cpk      IF (KSEC1(6).EQ.172 .AND. KSEC1(7).EQ.1) THEN
cpk         WRITE(*,*) 'Data values for the requested product ', JCOUNT
cpk         IDATS(1)=KSEC1(12)
cpk         IDATS(2)=KSEC1(11)
cpk         IDATS(3)=KSEC1(10)
cpk         IHRSTS=KSEC1(13)
cpk         IHRS=KSEC1(14)
cpk         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
cpk     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
cpk 
cpk            PRINT*,'WRITE TO FILE: ',FFNAME(1:N+20)
cpk            WRITE(16) FPDATA2D
cpk            PRINT*,'WRITE TO FILE: ',FTMP
cpk            AMIN = 100000.
cpk            AMAX = -100000.
cpk            DO JJ=1,KSEC2(3)
cpk            DO II=1,KSEC2(2)
cpk              IF (FPDATA2D(II,JJ).GE.AMAX) AMAX=FPDATA2D(II,JJ)
cpk              IF (FPDATA2D(II,JJ).LT.AMIN) AMIN=FPDATA2D(II,JJ)
cpk            ENDDO
cpk            ENDDO
cpk            WRITE(12,*)'LSM FIELD : AMIN,AMAX',AMIN,AMAX
cpk         ELSE
cpk            STOP "Date Mismatch"
cpk         ENDIF
cpk      ENDIF
C     Snow Depth (m)  SD
cpk      IF (KSEC1(6).EQ.141 .AND. KSEC1(7).EQ.1) THEN
cpk         WRITE(*,*) 'Data values for the requested product ', JCOUNT
cpk         IDATS(1)=KSEC1(12)
cpk         IDATS(2)=KSEC1(11)
cpk         IDATS(3)=KSEC1(10)
cpk         IHRSTS=KSEC1(13)
cpk         IHRS=KSEC1(14)
cpk         IF (IHR.EQ.IHRS .AND. IHRST.EQ.IHRSTS
cpk     &       .AND. IDAT(1).EQ.IDATS(1)) THEN
cpk 
cpk            PRINT*,'WRITE TO FILE: ',FFNAME(1:N+20)
cpk            WRITE(16) FPDATA2D
cpk            PRINT*,'WRITE TO FILE: ',FTMP
cpk            AMIN = 100000.
cpk            AMAX = -100000.
cpk            DO JJ=1,KSEC2(3)
cpk            DO II=1,KSEC2(2)
cpk              IF (FPDATA2D(II,JJ).GE.AMAX) AMAX=FPDATA2D(II,JJ)
cpk              IF (FPDATA2D(II,JJ).LT.AMIN) AMIN=FPDATA2D(II,JJ)
cpk            ENDDO
cpk            ENDDO
cpk            WRITE(12,*)'SD FIELD : AMIN,AMAX',AMIN,AMAX
cpk         ELSE
cpk            STOP "Date Mismatch"
cpk         ENDIF
cpk      ENDIF
C
C     Go round again for the next GRIB message.
C
      GOTO 50

      CLOSE (12)
      CLOSE (16)

      STOP
      END
