/*
Author: Ethan Coon

Painter's permafrost model with freezing point depression.

 */

#ifndef AMANZI_FLOWRELATIONS_WRM_FPD_PERMAFROST_MODEL_
#define AMANZI_FLOWRELATIONS_WRM_FPD_PERMAFROST_MODEL_

#include "wrm_permafrost_model.hh"
#include "wrm_permafrost_factory.hh"

namespace Amanzi {
namespace Flow {
namespace FlowRelations {

class WRM;

class WRMFPDPermafrostModel : public WRMPermafrostModel {

 public:
  explicit
  WRMFPDPermafrostModel(Teuchos::ParameterList& plist) :
      WRMPermafrostModel(plist) {}

  // required methods from the base class
  // sats[0] = sg, sats[1] = sl, sats[2] = si
  virtual bool freezing(double T, double pc_liq, double pc_ice) { 
    return pc_liq <= 0. ? T < 273.15 : pc_liq < pc_ice;
  }

  virtual void saturations(double pc_liq, double pc_ice, double (&sats)[3]);
  virtual void dsaturations_dpc_liq(double pc_liq, double pc_ice, double (&dsats)[3]);
  virtual void dsaturations_dpc_ice(double pc_liq, double pc_ice, double (&dsats)[3]);

 protected:
  double deriv_regularization_;

 private:
  // factory registration
  static Utils::RegisteredFactory<WRMPermafrostModel,WRMFPDPermafrostModel> factory_;

};


} //namespace
} //namespace
} //namespace

#endif
