/* -*-  mode: c++; c-default-style: "google"; indent-tabs-mode: nil -*- */

// -----------------------------------------------------------------------------
// ATS
//
// License: see $ATS_DIR/COPYRIGHT
// Author: Ethan Coon (ecoon@lanl.gov)
//
// Scheme for taking coefficients for div-grad operators from cells to
// faces.
// -----------------------------------------------------------------------------

#ifndef AMANZI_UPWINDING_SCHEME_
#define AMANZI_UPWINDING_SCHEME_

#include "Teuchos_RCP.hpp"
#include "Teuchos_SerialDenseMatrix.hpp"

#include "dbc.hh"
#include "MatrixMFD_Defs.hh"
#include "CompositeVector.hh"

namespace Amanzi {

// forward declaration
class State;
class Debugger;

namespace Operators {

enum UpwindMethod {
  UPWIND_METHOD_CENTERED = 0,
  UPWIND_METHOD_GRAVITY,
  UPWIND_METHOD_TOTAL_FLUX,
  UPWIND_METHOD_ARITHMETIC_MEAN,
  UPWIND_METHOD_POTENTIAL_DIFFERENCE
};

class Upwinding {

 public:
  virtual void
  Update(const Teuchos::Ptr<State>& S, const Teuchos::Ptr<Debugger>& db=Teuchos::null) = 0;

  virtual void
  UpdateDerivatives(const Teuchos::Ptr<State>& S, 
                    std::string potential_key,
                    const CompositeVector& dconductivity,
                    const std::vector<MatrixBC>& bc_markers,
                    const std::vector<double>& bc_values,
                    std::vector<Teuchos::RCP<Teuchos::SerialDenseMatrix<int, double> > >* Jpp_faces) const {
    ASSERT(0);
  }

};

} // namespace
} // namespace

#endif
