!------------------------------------------------------------------------------!
! ATS
!
! License: see $ATS_DIR/COPYRIGHT
!
! F90 test program
!------------------------------------------------------------------------------!

program main
   use ats
   implicit none
   include "mpif.h"

   integer(int32_t) :: ierr

   !---------------------------------------------------------------------------!
   ! Setup MPI to mimic input from CLM.
   !---------------------------------------------------------------------------!

   call MPI_INIT(ierr)

   if(ierr.ne.ATS_SUCCESS) then
      print *, 'Error: ', ierr
   end if

   !---------------------------------------------------------------------------!
   ! Initialize ATS layer.
   !---------------------------------------------------------------------------!

!   call ats_init(MPI_COMM_WORLD, ierr)

   !---------------------------------------------------------------------------!
   ! Shut down ATS layer.
   !---------------------------------------------------------------------------!

   call ats_finalize(ierr)

   !---------------------------------------------------------------------------!
   ! Exit MPI.
   !---------------------------------------------------------------------------!

   call MPI_FINALIZE(ierr)

end
