#
# This bit of code exists to autogenerate an include file
# that contains the registration of evaluator factories.
#
# The autogenerated include file is only to be included in 
# the file that contains main, and not in any file that is 
# to be included in a library.
#
# How to use this...
#
# Use the macro
#
# register_evaluator_with_factory(HEADERFILE bla_reg.hh  LISTNAME REGISTER_FILE_LIST)
#
# to add the file bla_reg.hh to the list of files that is going
# to be used to autogenerate an include file that is a concatenation
# of all the _reg.hh files. This is where all specific evaluators 
# are registered with the factory. This concatentated include file
# is created by calling the macro
#
# generate_evaluators_registration_header(HEADERFILE eval_reg.hh LISTNAME REGISTER_FILE_LIST  INSTALL True)
#
# It autogenerates the file eval_reg.hh, which must be included in the
# .cc file that contains main. The argument INSTALL is optional
# and if set to TRUE, True, or true, the concatenated header file
# will be installed.
#
# The macro
#
# include_evaluators_directories(LISTNAME REGISTER_FILE_LIST_INCLUDES)
#
# must be used in the CMakeCache.txt file to add the necessary include_directories
# calls. Note that the macro  generate_evaluators_registration_header  creates
# a global list that contains all the necessary include directories, and names
# this global list the list file name used in that macro with an appended _INCLUDES.
# In the example above, the global list that stores the include directories is
# called REGISTER_FILE_LIST_INCLUDES.
#


include(CMakeParseArguments)


macro(amanzi_file_cat)
  set(singleValueArgs DESTINATION)
  set(multiValueArgs SOURCES)
  set(options "")
  
  cmake_parse_arguments(LOCAL "${options}" "${singleValueArgs}" "${multiValueArgs}" ${ARGN})

  foreach(FILE ${LOCAL_SOURCES})
    file(READ ${FILE} CONTENTS)
    file(APPEND ${LOCAL_DESTINATION} "${CONTENTS}")
  endforeach()

endmacro(amanzi_file_cat)




macro(generate_evaluators_registration_header)
  set(singleValueArgs HEADERFILE LISTNAME)
  set(multiValueArgs "")
  set(options INSTALL)
  
  cmake_parse_arguments(LOCAL "${options}" "${singleValueArgs}" "${multiValueArgs}" ${ARGN})  
  
  # prepare a temporary file to "cat" to:
  file(WRITE ${LOCAL_HEADERFILE}.in "")
  # remove stale files
  file(REMOVE ${LOCAL_HEADERFILE})

  get_property(VAR_LIST GLOBAL PROPERTY ${LOCAL_LISTNAME})

  # concatenate the sources
  amanzi_file_cat(SOURCES ${VAR_LIST} DESTINATION ${LOCAL_HEADERFILE}.in)

  # copy the temporary file to the final location
  configure_file(${LOCAL_HEADERFILE}.in ${CMAKE_CURRENT_SOURCE_DIR}/${LOCAL_HEADERFILE} COPYONLY)
  
  # install the header file 
  if ((LOCAL_INSTALL STREQUAL "TRUE") OR (LOCAL_INSTALL STREQUAL "true") OR (LOCAL_INSTALL STREQUAL "True"))
    #add_install_include_file(${LOCAL_HEADERFILE})
    install(FILES ${LOCAL_HEADERFILE} DESTINATION include)
  endif()

  # collect the necessary include directories into the list LISTNAME_INCLUDES
  list(APPEND MY_INCLUDES ${CMAKE_CURRENT_SOURCE_DIR})
  foreach(FILE  ${VAR_LIST})
    get_filename_component(INCLUDE_PATH ${FILE} PATH)
    list(APPEND  MY_INCLUDES ${INCLUDE_PATH})
  endforeach()
  
  set_property(GLOBAL PROPERTY ${LOCAL_LISTNAME}_INCLUDES ${MY_INCLUDES})

endmacro(generate_evaluators_registration_header)




macro(register_evaluator_with_factory)
  set(singleValueArgs HEADERFILE LISTNAME)
  set(multiValueArgs "")
  set(options "")
  
  cmake_parse_arguments(LOCAL "${options}" "${singleValueArgs}" "${multiValueArgs}" ${ARGN})  

  get_property(VAR_TMP GLOBAL PROPERTY "${LOCAL_LISTNAME}")
  set(VAR_TMP ${VAR_TMP} ${CMAKE_CURRENT_SOURCE_DIR}/${LOCAL_HEADERFILE})
  list(REMOVE_DUPLICATES VAR_TMP)

  set_property(GLOBAL PROPERTY "${LOCAL_LISTNAME}" ${VAR_TMP})
endmacro(register_evaluator_with_factory)




macro(include_evaluators_directories)
  set(singleValueArgs LISTNAME)
  set(multiValueArgs "")
  set(options "")

  cmake_parse_arguments(LOCAL "${options}" "${singleValueArgs}" "${multiValueArgs}" ${ARGN})  

  get_property(VAR GLOBAL PROPERTY ${LOCAL_LISTNAME})
  include_directories(${VAR})

endmacro(include_evaluators_directories)
