#  -*- mode: cmake -*-

#
# Build TPL:  HDF5 
#    
# --- Define all the directories and common external project flags
define_external_project_args(HDF5
                             TARGET hdf5
                             DEPENDS ${MPI_PROJECT} ZLIB)

# add HDF5 version to the autogenerated tpl_versions.h file
amanzi_tpl_version_write(FILENAME ${TPL_VERSIONS_INCLUDE_FILE}
  PREFIX HDF5
  VERSION ${HDF5_VERSION_MAJOR} ${HDF5_VERSION_MINOR} ${HDF5_VERSION_PATCH})


# --- Define configure parameters

# Use the common cflags, cxxflags
include(BuildWhitespaceString)
build_whitespace_string(hdf5_cflags
                       -I${TPL_INSTALL_PREFIX}/include
                       ${Amanzi_COMMON_CFLAGS} )

build_whitespace_string(hdf5_cxxflags
                       -I${TPL_INSTALL_PREFIX}/include
                       ${Amanzi_COMMON_CXXFLAGS} )
set(cpp_flag_list 
    -I${TPL_INSTALL_PREFIX}/include
    ${Amanzi_COMMON_CFLAGS}
    ${Amanzi_COMMON_CXXFLAGS})
list(REMOVE_DUPLICATES cpp_flag_list)
build_whitespace_string(hdf5_cppflags ${cpp_flags_list})

# Add
if ( ( NOT BUILD_MPI) AND ( NOT MPI_WRAPPERS_IN_USE ) AND (MPI_C_LIBRARIES) )
  build_whitespace_string(hdf5_ldflags -L${TPL_INSTALL_PREFIX}/lib ${MPI_C_LIBRARIES} ${CMAKE_EXE_LINKER_FLAGS} )
else()
  build_whitespace_string(hdf5_ldflags -L${TPL_INSTALL_PREFIX}/lib ${CMAKE_EXE_LINKER_FLAGS} )
endif()  

# --- Set the name of the patch
set(HDF5_patch_file hdf5-1.8.8-comment.patch)
# --- Configure the bash patch script
set(HDF5_sh_patch ${HDF5_prefix_dir}/hdf5-patch-step.sh)
configure_file(${SuperBuild_TEMPLATE_FILES_DIR}/hdf5-patch-step.sh.in
               ${HDF5_sh_patch}
               @ONLY)
# --- Configure the CMake patch step
set(HDF5_cmake_patch ${HDF5_prefix_dir}/hdf5-patch-step.cmake)
configure_file(${SuperBuild_TEMPLATE_FILES_DIR}/hdf5-patch-step.cmake.in
               ${HDF5_cmake_patch}
               @ONLY)
# --- Set the patch command
set(HDF5_PATCH_COMMAND ${CMAKE_COMMAND} -P ${HDF5_cmake_patch})     

# --- Add external project build and tie to the ZLIB build target
ExternalProject_Add(${HDF5_BUILD_TARGET}
                    DEPENDS   ${HDF5_PACKAGE_DEPENDS}             # Package dependency target
                    TMP_DIR   ${HDF5_tmp_dir}                     # Temporary files directory
                    STAMP_DIR ${HDF5_stamp_dir}                   # Timestamp and log directory
                    # -- Download and URL definitions
                    DOWNLOAD_DIR ${TPL_DOWNLOAD_DIR}              # Download directory
                    URL          ${HDF5_URL}                      # URL may be a web site OR a local file
                    URL_MD5      ${HDF5_MD5_SUM}                  # md5sum of the archive file
                    # -- Patch 
                    PATCH_COMMAND ${HDF5_PATCH_COMMAND}
                    # -- Configure
                    SOURCE_DIR       ${HDF5_source_dir}           # Source directory
                    CONFIGURE_COMMAND
                                     <SOURCE_DIR>/configure
                                                 --prefix=<INSTALL_DIR>
                                                 --disable-fortran
                                                 --disable-cxx
                                                 --enable-production
                                                 --enable-largefile
                                                 --enable-parallel
                                                 --with-zlib=${TPL_INSTALL_PREFIX}
                                                 CC=${CMAKE_C_COMPILER_USE}
                                                 CFLAGS=${hdf5_cflags}
                                                 CXX=${CMAKE_CXX_COMPILER_USE}
                                                 CXXFLAGS=${hdf5_cxxflags}
                                                 CPPFLAGS=${hdf5_cppflags}
                                                 LDFLAGS=${hdf5_ldflags}
                    # -- Build
                    BINARY_DIR        ${HDF5_build_dir}           # Build directory 
                    BUILD_COMMAND     $(MAKE)                     # $(MAKE) enables parallel builds through make
                    BUILD_IN_SOURCE   ${HDF5_BUILD_IN_SOURCE}     # Flag for in source builds
                    # -- Install
                    INSTALL_DIR      ${TPL_INSTALL_PREFIX}        # Install directory
                    # -- Output control
                    ${HDF5_logging_args})

# --- Useful variables for packages that depend on HDF5 (NetCDF)
include(BuildLibraryName)
build_library_name(hdf5 HDF5_C_LIBRARY APPEND_PATH ${TPL_INSTALL_PREFIX}/lib)
build_library_name(hdf5_hl HDF5_HL_LIBRARY APPEND_PATH ${TPL_INSTALL_PREFIX}/lib)
set(HDF5_LIBRARIES ${HDF5_HL_LIBRARY} ${HDF5_C_LIBRARY} ${ZLIB_LIBRARIES} m)
set(HDF5_INCLUDE_DIRS ${TPL_INSTALL_PREFIX}/include ${ZLIB_INCLUDE_DIRS})
list(REMOVE_DUPLICATES HDF5_INCLUDE_DIRS)
