#-------------------------------------------------------------------------------
# Name:        module1
# Purpose:
#
# Author:      Arghya Goswami
#
# Created:     01/04/2013
#
# Copyright:   (c) arghya.goswam 2013
#
# Licence:     This program is free software; you can redistribute it and/or
#              modify it under the terms of the GNU General Public License,
#              version 2, as published by the Free Software Foundation.
#
#              This program is distributed in the hope that it will be useful,
#              but WITHOUT ANY WARRANTY; without even the implied warranty of
#              MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#              GNU General Public License for more details.
#
#              You should have received a copy of the GNU General Public License
#              along with this program; if not, write to:
#
#              Free Software Foundation, Inc.,
#              51 Franklin St, Fifth Floor,
#              Boston, MA, 02110-1301  USA
#-------------------------------------------------------------------------------
#!/usr/bin/env python
#
#-------------------------------------------------------------------------------

import arcpy, sets, sys, os, glob, time, fileinput, string, Tkinter, tkFileDialog
from Tkinter import *

#-------------------------------------------------------------------------------
# Definitions used in this Script
#-------------------------------------------------------------------------------
def BrowseFile(msg1,indir):
    #Creating Main Window
    root = Tk()
    # Creating Secondary Window for File Browsing
    filename = tkFileDialog.askopenfilename(filetypes = [('CSV Files','*.csv'),('All files','*')], title = msg1, initialdir = indir)
    # Close the Main Window
    root.withdraw()
    # Return Filename
    return filename

def BrowseDir(msg2,indir):
    #Creating Main Window
    root = Tk()
    # Creating Secondary Window for Folder Browsing
    dirname = tkFileDialog.askdirectory(title = msg2, initialdir=indir)
    # Close the Main Window
    root.withdraw()
    # Return Dirname
    return dirname

def DirCheck(filename):
	if os.path.exists(os.path.dirname(filename)):
	    pass
	else:
	    os.mkdir(os.path.dirname(filename))

#-------------------------------------------------------------------------------
# Main Script
#-------------------------------------------------------------------------------

# Report file generator
StartTime = time.asctime(time.localtime(time.time()))
print "Start Time: ", StartTime

# Select input file
inFile = BrowseFile("Select File: ","C:/Temp/")

# Read the input file
fin = open(inFile,'r')
finText = fin.readlines()
fin.close()

# Create output file
outFolder =os.path.dirname(inFile)
outFile = outFolder + "/" + (os.path.basename(inFile)).split(".")[0] + "_outermost.csv"
fout = open(outFile,'w')
header = "lon,lat,bathy\n"
fout.write(header)


bathy=[]
for lines in finText:
	line = lines.replace("\n","")
	print line
	linesplit = line.split(",")
	print len(linesplit)
	lats = []
	for items in linesplit:
		lats.append(items)
	print len(lats)
	bathy.append(lats)
	print bathy[0][3599]
	print bathy[0][3600]

print [0][0]

print [0][3600]



i= 0
while i<3601:
	j = 0
	while j<1800:
		z = []
		if i==0:
			if j==0:
				z = [ [bathy[3600][j] , bathy[i][j] , bathy[i+1][j] ],[bathy[3600][j+1] , bathy[i][j+1] , bathy[i+1][j+1] ] ]
			elif j == 1800:
				z = [ [bathy[3600][j-1],bathy[i][j-1],bathy[i+1][j-1]],[bathy[3600][j],bathy[i][j],bathy[i+1][j]]]
			else:
				z = [ [bathy[3600][j-1],bathy[i][j-1],bathy[i+1][j-1]],[bathy[3600][j],bathy[i][j],bathy[i+1][j]],[bathy[3600][j+1],bathy[i][j+1],bathy[i+1][j+1]]]
		elif i == 3600:
			if j==0:
				z = [ [bathy[i-1][j],bathy[i][j],bathy[0][j]],[bathy[i-1][j+1],bathy[i][j+1],bathy[0][j+1]]]
			elif j == 1800:
				z = [ [bathy[i-1][j-1],bathy[i][j-1],bathy[0][j-1]],[bathy[i-1][j],bathy[i][j],bathy[0][j]]]
			else:
				z = [ [bathy[i-1][j-1],bathy[i][j-1],bathy[0][j-1]],[bathy[i-1][j],bathy[i][j],bathy[0][j]],[bathy[i-1][j+1],bathy[i][j+1],bathy[0][j+1]]]
		else:
			if j==0:
				z = [ [bathy[i-1][j],bathy[i][j],bathy[i+1][j]],[bathy[i-1][j+1],bathy[i][j+1],bathy[i+1][j+1]]]
			elif j == 1800:
				z = [ [bathy[i-1][j-1],bathy[i][j-1],bathy[i+1][j-1]],[bathy[i-1][j],bathy[i][j],bathy[i+1][j]]]
			else:
				z = [ [bathy[i-1][j-1],bathy[i][j-1],bathy[i+1][j-1]],[bathy[i-1][j],bathy[i][j],bathy[i+1][j]],[bathy[i-1][j+1],bathy[i][j+1],bathy[i+1][j+1]]]

		if z[1][1] !="NaN" and z[0][0] == "NaN" or z[0][1] == "NaN" or z[0][2] == "NaN" or z[1][0] == "NaN" or z[1][2] == "NaN" or z[2][0] == "NaN" or z[2][1] == "NaN" or z[2][2] == "NaN":
			lon = (i*0.1) - 180
			lat = (j*0.1) - 90
			depth = bathy[i,j]
			wLine = lon + "," + lat + "," + depth + "\n"
			fout.write(wLine)
		j = j + 1
	i = i + 1

fout.close()
#-------------------------------------------------------------------------------
# End of Script
#-------------------------------------------------------------------------------
EndTime = time.asctime(time.localtime(time.time()))
print "End Time: ", EndTime