function Bathymetry()
% load the matlab dataset
load ('AllBathy.mat');

% calculate Muller sediment 
M_Sed = zeros(1801,3601);
M_Sed(:) = abs(M_D2B(:))-abs(M_Bathy(:));

%Divine Sediment
ST_ME = zeros(1801,3601);
ST_ME(:)=ST(:);
idx=arrayfun(@sign ,ST_ME(:).*M_Sed(:));
ST_ME(idx==1 | isnan(idx))=nan;
% 
% sediment correction assuming average sediment density to be 1.58 mg m^-3
Avg_Sed_Corr = zeros(1801,3601);
Avg_Sed_Corr(:) = M_Sed(:)*1.58;
% 
% sediment correction assuming average sediment thickness is equivalent 
% to Muller Sediment mean value (320m) and sediment density is 1.82 mg m^-3
% based on linear model calculated from datapoints in Crosby et al, 2006
M_Avg_Sed_Corr = zeros(1801,3601);
M_Avg_Sed_Corr(:) = M_Sed(:)*1.82;
% 
% sediment correction assuming average sediment thickness is equivalent 
% to Modern Sediemnt Thickness mean value (383m) and sediment density is 
% 1.87 mg m^-3 based on linear model calculated from datapoints in 
% Crosby et al, 2006
ST_Avg_Sed_Corr = zeros(1801,3601);
ST_Avg_Sed_Corr(:) = M_Sed(:)*1.82;

% Two layer sediment density weighted model
L2_Sed_Corr = zeros(1801,3601);
% density of mantle in mg/m^3
rhom = 3300e6;
% density of water in mg/m^3
rhow = 1000e6;
