module mod_read_grib
  implicit none
  public :: read_grib_hybrid
  !----------------------------------------------------------------------------
contains
  !----------------------------------------------------------------------------
  subroutine read_grib_hybrid
!
! This subroutine reads the atmospheric input data which is provided as a GRIB
! files, especially for ECMWF's "hybrid" coordinate.
!
    use grib_api
    use mod_adm
    use mod_time
    implicit none
    character(len=20)  :: name_space
    integer            :: kiter,igrib,iret
    integer            :: lev1, ix,iy, iz
		integer    				 :: nFiles
    character(len=256) :: key
    character(len=256) :: value
    character(len=256) :: lev
    character(len=256) :: dname
    character(len=512) :: all
    integer            :: grib_count
    integer            :: inum
  
    double precision :: values(nx*ny)
    double precision :: lat_tmp(nx*ny)
    double precision :: lon_tmp(nx*ny)

    integer :: idx, stat, ifile, i
    integer :: shortNameSize,numberSize,levelSize,stepSize
    character(len=20),dimension(:),allocatable :: shortName
    character(len=256) :: dataDate
    character(len=256) :: dataTime
    character(len=256) :: dataStep
    character(len=3) :: cstep

    !character(len=8),dimension(:),allocatable :: dataDate
    !character(len=4),dimension(:),allocatable :: dataTime
    integer,dimension(:),allocatable :: level
    character(256) :: fname, tmp_fname

    if (len(trim(ifile_orog)) == 0) Nfiles = numoffile
    ! Include orography grib file in iteration process when specified by user
    if (len(trim(ifile_orog)) /= 0) Nfiles = numoffile+1

    write(*,*) 'Reading GRIB input data'            
    do inum = 1, Nfiles 
      ! Open GRIB file
      call grib_open_file(ifile, trim(ifile_grib(1)), 'r', stat )
      call grib_new_from_file(ifile,igrib, iret)

      ! Create index for opened GRIB file
      call grib_index_create(idx,trim(ifile_grib(1)),'shortName,level')

      ! Get the number of the elements and allocate the array
      call grib_index_get_size(idx,'shortName',shortNameSize)
      allocate(shortName(shortNameSize))
      call grib_index_get(idx,'shortName',shortName)
      write(*,'(a,i3)') 'shortNameSize=',shortNameSize
      write(*,*) shortName

      ! Get the number of the vertical levels and allocate the array
      call grib_index_get_size(idx,'level',levelSize)
      allocate(level(levelSize))
      call grib_index_get(idx,'level',level)
      write(*,'(a,i3)') 'levelSize=',levelSize
      write(*,*) level

      do while (iret /= GRIB_END_OF_FILE)
        grib_count=grib_count+1
        name_space='ls'

        call grib_keys_iterator_new(igrib,kiter,name_space)
        call grib_get(igrib,'shortName',dname)
        call grib_get(igrib,'level',lev)
        call grib_get(igrib,'dataDate',dataDate)
        call grib_get(igrib,'dataTime',dataTime)
        call grib_get(igrib,'step',dataStep)

        ! write(*,*) 'Data date: ',dataDate
        ! write(*,*) 'Data time: ',dataTime
        ! write(*,*) 'Data step: ',dataStep, adjustr(datastep)
        write(cstep,'(a3)') dataStep
        cstep = adjustr(cstep)
        do i = 1,3
          if(cstep(i:i)==' ') cstep(i:i)='0'
        end do 
!        write(*,*) 'Data step: ',cstep
        if(trim(dataDate)//dataTime(1:4)//cstep(1:3) /= trim(cdate)) then
          write(*,*) '### Time is inconsistent ###'
          write(*,*) 'The date in data is ', trim(dataDate)//dataTime(1:4)//cstep(1:3)
          write(*,*) 'The date you gave is ', trim(cdate)
        end if
        
        read(lev,'(i4)') lev1
        if(trim(dname)=='u') then
          call grib_get_data(igrib,lat_tmp,lon_tmp,values)
          do iy = 1,ny
            do ix = 1,nx
              u_input(ix,iy,nz-lev1+1)=values(ix+nx*(iy-1))
            end do
          end do
        end if
        if(trim(dname)=='v') then
          call grib_get_data(igrib,lat_tmp,lon_tmp,values)
          do iy = 1,ny
            do ix = 1,nx
              v_input(ix,iy,nz-lev1+1)=values(ix+nx*(iy-1))
            end do
          end do
        end if
        if(trim(dname)=='t') then
          call grib_get_data(igrib,lat_tmp,lon_tmp,values)
          do iy = 1,ny
            do ix = 1,nx
              t_input(ix,iy,nz-lev1+1)=values(ix+nx*(iy-1))
            end do
          end do
        end if
        if(trim(dname)=='q') then
          call grib_get_data(igrib,lat_tmp,lon_tmp,values)
          do iy = 1,ny
            do ix = 1,nx
              q_input(ix,iy,nz-lev1+1)=values(ix+nx*(iy-1))
            end do
          end do
        end if
        if(trim(dname)=='lnsp') then
          call grib_get_data(igrib,lat_tmp,lon_tmp,values)
          do iy = 1,ny
            do ix = 1,nx
              ppp(ix,iy)=values(ix+nx*(iy-1))
            end do
          end do
        end if
        if(trim(dname)=='z') then
          call grib_get_data(igrib,lat_tmp,lon_tmp,values)
          do iy = 1,ny
            do ix = 1,nx
              orog(ix,iy)=values(ix+nx*(iy-1))
            end do
          end do
        end if
        call grib_keys_iterator_delete(kiter)
        call grib_release(igrib)
        call grib_new_from_file(ifile,igrib, iret)

      end do
      call grib_close_file(ifile)

! tmp fix: reading orog from the file as fc input files contain no orog field
!!      write(*,*) 'Reading orography from binary file'
!!      call input_2d('Orog_N64', orog, nx, ny, 1, .true., 8) 
          
! save surface pressure for later use during the inversion
      if(saveps) then
!          fname='Ps_'
          tmp_fname=trim(ps_fname)//trim(cdate)
          call output_2d(trim(tmp_fname), ppp, nx, ny, 1, .true., 8) 
      end if
                     
      deallocate( shortName )
      deallocate( level )
    end do

  end subroutine read_grib_hybrid
  !----------------------------------------------------------------------------
end module mod_read_grib
