module mod_interpolation
  implicit none

  public  :: linear_interpolation
  private :: find_closest_grid
  !----------------------------------------------------------------------------
contains
  !----------------------------------------------------------------------------
  subroutine linear_interpolation(n, m, x1, y1, x2, y2)
    implicit none
    integer :: n ! Num. of points for original data
    integer :: m ! Num. of points which you want to interpolate
    double precision :: x1(n) ! value of grid for original data
    double precision :: y1(n) ! value of original data
    double precision :: x2(m) ! value of grid which you want to interpolate
    double precision, intent(out) :: y2(m) ! value of interpolated data

    integer :: iz, ibelow, iabove
    double precision :: pbelow, pabove

    do iz = 1,m
      call find_closest_grid(x2(iz), n, x1(:), ibelow, iabove)
      if(ibelow==iabove) then
        y2(iz)=y1(ibelow)
      else
        y2(iz)=( y1(ibelow)*(x1(iabove)-x2(iz)) +  &
                 y1(iabove)*(x2(iz)-x1(ibelow) ) ) / (x1(iabove)-x1(ibelow))
      end if
    end do

  end subroutine linear_interpolation 
  !----------------------------------------------------------------------------
  subroutine find_closest_grid(x1,m,x2,ibelow,iabove)
    implicit none
    integer, intent(in) :: m
    integer, intent(out) :: ibelow, iabove
    double precision, intent(in) :: x2(m)
    double precision, intent(in) :: x1

    integer :: ibe, iab, k
    double precision :: pabove, pbelow, pz, zlittle

    pz = 0.0d0
    ibelow = 0
    iabove = m
    zlittle = 1.0d-15

    ! Find a nearest grid point below a given point
    pbelow = x1 - x2(1) 
    ibe = 1
    if(pbelow < 0.0d0) then
      pbelow = 0.0d0
      ibe    = 1
    end if
    do k = m-1, 1, -1
      pz = x1 - x2(k)
      if(pz>0.0d0 .and. pz<pbelow) then
        pbelow = pz
        ibe    = k
      end if
    end do
    ibelow = ibe

    ! Find a nearest grid point above a given point
    pabove = x2(m) - x1
    iab    = m
    do k = 1, m
      pz = x2(k) - x1
      if(pz>0.0d0 .and. pz<pabove) then
        pabove = pz
        iab    = k
      end if
    end do
    iabove = iab

  end subroutine find_closest_grid
  !----------------------------------------------------------------------------
end module mod_interpolation
