module mod_geopotential_ecmwf
  implicit none
  
contains
  !----------------------------------------------------------------------------
  subroutine compute_geoheight_ecmwf
    use mod_adm, only : &
        nx, ny, nz,     &
        aa, bb,         &
        t_input,        &
        q_input,        &
        ppp,            &
        orog,           &
        z_input, output_3d_gmt
    use mod_const
      
    implicit none
    double precision, dimension(0:nz) :: phalf
    double precision, dimension(nx,ny,0:nz) :: hhalf
    double precision :: a, b, ph, pf, alpha, pfull, dP, dlogP, &
                        R, Cp, dpg, tpres, hydr
    integer :: ierr, index, ix, iy, iz

    z_input(:,:,:) = 0.d0
    hhalf(:,:,:) = 0.d0
    phalf(:) = 0.d0
 
!    call output_3d_gmt('t_model.dat', t_input, nx, ny, nz)
!    call output_3d_gmt('q_model.dat', q_input, nx, ny, nz)    
!
! Pressure at half levels and height fields at half and full model
! levels
!
    do ix = 1, nx
      do iy = 1, ny
        hhalf(ix,iy,nz) = orog(ix,iy)/g
        do iz = nz,1,-1
          phalf(iz) = aa(iz) + bb(iz) * dexp(ppp(ix,iy))
          phalf(iz-1) = aa(iz-1) + bb(iz-1) * dexp(ppp(ix,iy))
          pfull = (phalf(iz)+phalf(iz-1))*0.5d0
          dP = phalf(iz)-phalf(iz-1)
          if(iz == 1 .and. nz == 91) then
            tpres = 0.1d0
            hydr = 1.0d0
            dlogP = dlog(phalf(iz)/tpres)
            alpha = hydr
          elseif(iz == 1 .and. nz /= 91) then
            tpres = 0.1d0
            dlogP = dlog(phalf(iz)/tpres)
            hydr = 1.0d0
            alpha = hydr !dlog(2.0d0)
          else
            dlogP = dlog(phalf(iz)/phalf(iz-1))
            alpha = 1.d0 - phalf(iz-1)/dP*dlogP
          end if
          Cp = cpd*(1.d0-q_input(ix,iy,iz)) + Cvd*q_input(ix,iy,iz)
          R  =  Rd*(1.d0-q_input(ix,iy,iz)) +  Rv*q_input(ix,iy,iz)
          z_input(ix,iy,iz) = hhalf(ix,iy,iz) + R*t_input(ix,iy,iz)*alpha/g
          hhalf(ix,iy,iz-1) = hhalf(ix,iy,iz) + R*t_input(ix,iy,iz)*dlogP/g
        end do
  
        if(ix.eq.10.and.iy.eq.46) then
          write(6,*) 'Surface pressure in point (10,46) = ', dexp(ppp(ix,iy))/100.0,'hPa'
          write(6,*) 'Orography in point (10,46) = ', orog(ix,iy)/g
!          do iz = 1,nz
!            write(6,*) iz, (phalf(iz)+phalf(iz-1))*0.5/100.0, z_input(ix,iy,iz)
!         end do
        end if

      end do
    end do

  end subroutine compute_geoheight_ecmwf
  !----------------------------------------------------------------------------
end module mod_geopotential_ecmwf
