module mod_gauss
  implicit none
  contains
  subroutine gauss(N, x, w)
    implicit none
    integer, intent(in) :: N
    real(8), intent(inout) :: x(N)
    real(8), intent(inout) :: w(N)
    real(8) :: a, b
    real(8) :: lambak
    real(8) :: pi
    integer  :: i, m, k, kk

    pi = dacos(-1.0d0)
    
    if(mod(N,2)==0) then
      m = N/2
    else
      m = (N-1)/2
    end if 

    do i = 1,m
      a = dsin(pi*dfloat(N-2*i)/dfloat(2*N)) 
      b = dsin(pi*dfloat(N+2-2*i)/dfloat(2*N)) 
      x(N+1-i) = NIBUN(N,a,b)
      x(i) = -x(N+1-i)
    end do

    if(mod(N,2)==1) x(m) = 0.0d0

!$omp parallel
!$omp do
    do i = 1,N
      w(i) = 0.0d0
      do k = 0,N
        lambak = 2.0d0 / ( 2.0d0*dfloat(k)+1.0d0)
        w(i) = w(i) + P_k(k,x(i))**2 / lambak
      end do
      w(i) = 1.0d0 / w(i)
    end do
!$omp end do
!$omp end parallel

  end subroutine gauss

  double precision function nibun(N,a,b)
    integer :: N
    integer :: k
    real(8) :: a, b, c
    real(8) :: delta, epsi

    delta = 1.0d-15
    epsi  = 1.0d-15

    do k = 1, 100000
      c = (a+b)/2.0d0
      if( dabs(P_k(N,c)) < delta .or. dabs(a-b) < epsi ) then
        nibun = c
        return
      end if 
      if( P_k(N,c)*P_k(N,a) < 0.0d0) then
        b=c
      else
        a=c
      end if
    end do

    write(*,*) 'Error'
    stop

  end function nibun

  double precision function P_k(k,x)
    integer :: n, k
    real(8) :: p0, p1,p2, x
    
    p0=1.0d0
    p1=x
    if(k==0) then
      P_k = p0
      return
    else
      !do n = 1, k
      do n = 1, k-1
        p2 = ( (2.0d0*dfloat(n)+1.0d0)*x*p1 - dfloat(n)*p0) / ( dfloat(n)+1.0d0)
        p0 = p1
        p1 = p2
      end do
    end if

    P_k = p1

  end function P_k

end module mod_gauss
