  program main
    implicit none
    integer :: i, j
    integer, parameter :: num_vmode=60 ! no vertical modes
    integer, parameter :: mp=60 ! number of vertical levels in input model data
    double precision :: vsf(mp,num_vmode)
    double precision :: vgrid(mp), stab(mp), eqd(mp)

 
    open(unit=1,file='eqdepth.data', form='unformatted',&
         access='direct',recl=mp*8)
    read(1,rec=1) eqd(:)
    close(1)
    write(*,*)'Equivalent depth:'
    do i = 1,mp
     write(*,*) eqd(i)
    end do

    open(10,file='vsf.data', form='unformatted', &
          access='direct',recl=mp*num_vmode*8)
    read(10,rec=1) vsf(:,:)
    close(10)

    do j=1, num_vmode 
     do i = 1,mp
      write(*,*)  j,i, vsf(i,j)
     end do
    end do
      
!    open(unit=1,file='sgrid.data', form='unformatted',&
!         access='direct',recl=mp*8)
!    read(1,rec=1) vgrid(:)
!    close(1)
    
!    open(unit=10,file='stab.data', form='unformatted',&
!         access='direct',recl=mp*8) 
!    read(10,rec=1) stab(:)
!    close(10)

!    do i = 1,mp
!     write(*,*) vgrid(i)
!    end do
!    do i = 1,mp
!     write(*,*) stab(i)
!    end do
    
  end program main
