module mod_special_function
  implicit none
  private

  double precision, allocatable, public, save :: p0(:,:)
  double precision, allocatable, public, save :: p1(:,:)

  public :: legendre

contains
  !----------------------------------------------------------------------------
  subroutine legendre(n1, n2, gp, gw)
    use mod_const
    implicit none
    integer, intent(in) :: n1
    integer, intent(in) :: n2
    double precision, intent(in) :: gp(n1)
    double precision, intent(in) :: gw(n1)
    double precision :: colat(n1)
    double precision :: del, pb, sq
    double precision, allocatable :: cp(:)
    integer :: i, n

    allocate(p0(n1+1,0:n2))
    allocate(p1(n1+1,0:n2))

    do i = 1, n1
      colat(i) = pai*(90.0d0 - dasin(gp(i))*180.0d0/pai) / 180.0d0
    end do

    del=0.5d0
    do n = 0, n2
      allocate( cp(n/2+1) )
      call dalfk(n,0,cp)
      do i = 1, n1
        call dlfpt(n,0,colat(i),cp,pb)
        p0(i,n)=pb*dsqrt( del*4.0d0/(2.0d0*dfloat(n)+1.0d0) )
      end do
      deallocate( cp )
    end do
    p0(n1+1,:)=1.0d0
     
    do n = 0,n2
      sq=0.0d0
      do i = 1,n1
        sq=sq+p0(i,n)**2*gw(i)
      end do
      sq=dsqrt(sq)
      p0(:,n)=p0(:,n)/sq
    end do

    do n = 1,n2-1
      sq=dsqrt((2.0d0*dfloat(n)+1.0d0)/(2.0d0*dfloat(n)+3.0d0))
      do i = 1,n1
        p1(i,n)=(sq*p0(i,n+1)-gp(i)*p0(i,n))*dfloat(n+1) / &
                (gp(i)**2 - 1.0d0)
      end do
    end do

  end subroutine legendre
  !----------------------------------------------------------------------------
end module mod_special_function
