module mod_const
  implicit none

  !--- circular constant
  double precision, parameter, public :: pai   = 4.0d0 * datan(1.0d0)
  double precision, parameter, public :: hfpai = 0.5d0 * pai
  double precision, parameter, public :: dtr   = pai / 180.0d0

  !--- Gas constant for dry air
  !double precision, parameter, public :: Rd = 287.04d0
  !--- Gas constant for water vapor
  !double precision, parameter, public :: Rv = 461.52d0
  !--- Gravity
  double precision, parameter, public :: g = 9.80616d0
  !--- Angular speed of the Earth
  double precision, parameter, public :: omega = pai / 43200.d0
  !--- Radius of the Earth
  double precision, parameter, public :: ae = 2.0d7 / pai
  !--- Surface Pressure
  double precision, parameter, public :: ps = 1000.0d0
  !--- Boltzmann constant
  double precision, parameter, public :: Boltzmann = 1.380658d-23
  !--- Avogadro constant
  double precision, parameter, public :: Avogadro  = 6.0221367d+23
  !---
  double precision, parameter, public :: UnGascon  = Boltzmann*Avogadro
  !---
  double precision, parameter, public :: Md = 28.9644d0
  !---
  double precision, parameter, public :: Mv = 18.0153d0
  !---
  double precision, parameter, public :: Rd = 1000.0d0*UnGascon/Md
  !---
  double precision, parameter, public :: Rv = 1000.0d0*UnGascon/Mv
  !--- Specific heat for dry air at constant pressure
  double precision, parameter, public :: cpd = 3.5d0*Rd
  !--- Specific heat for dry air at constant volume
  double precision, parameter, public :: cvd = Cpd-Rd
  !--- cv/cp
  double precision, parameter, public :: kap = cvd/cpd
  !--- Imaginary
  double complex, parameter, public :: img=(0.0d0, 1.0d0)

end module mod_const
