module mod_normal
  implicit none
  private
  public :: read_inputdata
  public :: NMF_output
  public :: NMF_outputw
  private :: global_mean
  public :: grid_data_order
  !
contains
  !----------------------------------------------------------------------------
  subroutine read_inputdata
    use mod_adm
    use mod_time
    use mod_const, only :&
        g, rd
    use mod_read_grib
    use mod_read_netcdf
    use mod_interpolation
    use mod_geopotential_ecmwf
    implicit none
    integer :: iz, ix, iy, ip
    integer :: i 
    double precision :: glob(nz)
    double precision :: in_sigma(nz)
    double precision :: out_sigma(mp)
    double precision :: sfull(mp)
    double precision :: phalf(0:nz), pfull(nz)
!    double precision :: ztmp
!    character(128) :: test
!    character(128) :: Linter = 'ECMWF'
    character(256) :: fname, tmp_fname
    double precision, allocatable :: uuu1(:,:,:)
    double precision, allocatable :: vvv1(:,:,:)
    double precision, allocatable :: zzz1(:,:,:)
    double precision, allocatable :: ttt1(:,:,:)

    allocate(uuu1(nz,nx,ny))
    allocate(vvv1(nz,nx,ny))
    allocate(zzz1(nz,nx,ny))
    allocate(ttt1(nz,nx,ny))
    
! IFs for the specified datatype
    if (trim(dataformat_input) == 'grib' ) then  
      write(*,*) "============= Input data file(s) =============="
      do i = 1, numoffile
        ifile_grib(i)=trim(ifile_head(i))//trim(cdate) 
!        write(*,*) trim(ifile_head(i)), trim(cdate)
        write(*,*) trim(ifile_grib(i))
      end do
      if (len(trim(ifile_orog)) /= 0)  then
      	ifile_grib(numoffile+1) = trim(ifile_orog)
				write(*,*) "Orography file: ", ifile_grib(numoffile+1)
      end if
      write(*,*) "==============================================="       
      write(*,*) ""

      ! Reading GRIB file
      ! Output data are sorted NP to SP and bottom to top level upward
      call read_grib_hybrid
    
      ! change  from the bottom to top to order from top to bottom for the input fields
      call grid_data_order

!    call output_3d_3var_gmt('InputData_',aformat,cdate,u_input,v_input,t_input,nx,ny,nz)

    elseif (trim(dataformat_input) == 'binary' ) then

    
    elseif (trim(dataformat_input) == 'netcdf' ) then
      write(*,*) ""
      write(*,*) "============ Input NetCDF files ==============="
      do i = 1, numoffile
        ifile_netcdf(i)=trim(ifile_head(i))//trim(cdate)//trim(".nc")
!        write(*,*) trim(ifile_head(i)), trim(cdate), trim(".nc") 
        write(*,*) trim(ifile_netcdf(i))
      end do
      if (len(trim(ifile_orog)) /= 0)  then
      	ifile_netcdf(numoffile+1) = trim(ifile_orog)
				write(*,*) "Orography file: ", ifile_netcdf(numoffile+1)
      end if
      write(*,*) "==============================================="
      write(*,*) ""

    ! Reading NetCDF file
    ! Output data are sorted NP to SP and bottom to top level upward
      call read_netcdf_hybrid

    ! change from the bottom to top to order from top to bottom for the input fields 
    !  call grid_data_order        !<< this part is already done in read_netcdf_hybrid!! >>
    else
      write(*,*) "Please specify a proper dataformat_input parameter in the namelist. Choose: 'grib' or 'netcdf'"
    end if 
        
    ! Compute geopotential height
    call compute_geoheight_ecmwf

!    ! save input files on model levels
    if ( saveasci ) then
      call output_3d_3var_gmt(afname,aformat,cdate,u_input,v_input,z_input,nx,ny,nz)
    end if
          
    ! Interpolate from model levels to other coordinate
    if (zgrid_type == 'hybrid' ) then
     do iy = 1,ny
       do ix = 1,nx
           call interpolation_hybrid2sigma(nz,u_input(ix,iy,:),nz,uuu1(:,ix,iy),ppp(ix,iy))
           call interpolation_hybrid2sigma(nz,v_input(ix,iy,:),nz,vvv1(:,ix,iy),ppp(ix,iy))
           call interpolation_hybrid2sigma(nz,z_input(ix,iy,:),nz,zzz1(:,ix,iy),ppp(ix,iy))
           call interpolation_hybrid2sigma(nz,t_input(ix,iy,:),nz,ttt1(:,ix,iy),ppp(ix,iy))
       end do
     end do
    
    else
    ! this currently do not work well
    ! do iy = 1,ny
    !   do ix = 1,nx   
    !    do iz = 1,nz
    !      phalf(iz-1) = aa(iz-1) + bb(iz-1) * dexp(ppp(ix,iy))! hybrid half levels pressure
    !      phalf(iz) = aa(iz) + bb(iz) * dexp(ppp(ix,iy))!
    !      pfull(iz) = (phalf(iz-1)+phalf(iz))*0.5d0 ! hybrid full levels pressure
    !      sfull(iz) = pfull(iz)/dexp(ppp(ix,iy)) ! current sigma levels 
    !    end do
    !    do iz = 1,nz
    !      in_sigma(iz)=-dlog(sfull(nz-iz+1))
    !    end do        
    !    do iz = 1,mp
    !      out_sigma(iz) = -dlog(vgrid(iz)) ! full sigma levels to interpolate sorted top to bottom
    !    end do
    !    call linear_interpolation(nz,mp,  &
    !                              in_sigma(:), u_input(ix,iy,nz:-1:1), &
    !                              out_sigma(:), uuu1(:,ix,iy))
    !    call linear_interpolation(nz,mp,  &
    !                              in_sigma(:), v_input(ix,iy,:), &
    !                              out_sigma(:), vvv1(:,ix,iy))
    !    call linear_interpolation(nz,mp,  &
    !                              in_sigma(:), z_input(ix,iy,:), &
    !                              out_sigma(:), zzz1(:,ix,iy))
    !    call linear_interpolation(nz,mp,  &
    !                              in_sigma(:), t_input(ix,iy,:), &
    !                              out_sigma(:), ttt1(:,ix,iy))  
    !         
    !   end do
    !  end do 
      
    end if

! compute the globally averaged mean level temperature
!
    call global_mean(nx,ny,nz,dcos(dasin(ygrid)),ttt1,glob)

    write(*,*) 'Check after interpolation for Z'
    write(*,*) 'minimum, maximum and average T at every sigma model level'
    do ip = 1,nz
      write(*,'(i4,3F10.4)') ip, minval(ttt1(ip,:,:)), maxval(ttt1(ip,:,:)), &
                             glob(ip)
    end do

! save the profile of the global mean T for later use during the inversion
      if(savemeant) then
          tmp_fname=trim(meant_fname)//trim(cdate)
          call output_1d(trim(tmp_fname), glob, mp, 1, .true., 8)
      end if
        
!   Kasahara&Puri modified geopotential height
!    if(trim(zgrid)=='Sigma') then
      do ip = 1,nz
       do iy = 1,ny
        do ix = 1,nx
         zzz1(ip,ix,iy) = zzz1(ip,ix,iy)+Rd*glob(ip)*ppp(ix,iy)/g
        end do
       end do 
      end do
!    end if
    
    write(*,*) 'maximum and minimum for surface pressure'
    write(*,*) minval(dexp(ppp)), maxval(dexp(ppp))

! this is in order to be more selected in term of data levels
!
    do ip = 1,mp
      do iy = 1,ny
       do ix = 1,nx
         uuu(ip,ix,iy) = uuu1(ip,ix,iy) ! uuu1(ip,ix,iy) or uuu1(5+ip-1,ix,iy)
         vvv(ip,ix,iy) = vvv1(ip,ix,iy)
         zzz(ip,ix,iy) = zzz1(ip,ix,iy)
        end do
      end do 
    end do
    
    deallocate(uuu1)
    deallocate(vvv1)
    deallocate(zzz1)
    deallocate(ttt1)
    
  end subroutine read_inputdata
  !----------------------------------------------------------------------------
  subroutine NMF_output(itime)
    use mod_adm
    use mod_time, only: &
        cdate
    implicit none
    integer, intent(in) :: itime
    character(256) :: tmp_fname

    if(output_3DNMF) then
      if(separate_time) then
        tmp_fname=trim(coef3DNMF_fname)//trim(cdate)
        open(1,file=trim(tmp_fname),form='unformatted',access='direct', &
             recl=16*(num_zw+1)*maxl*3*num_vmode)
        write(1,rec=1) w0
        close(1)
      else
        open(1,file=trim(coef3DNMF_fname),form='unformatted',access='direct', &
             recl=16*(num_zw+1)*maxl*3*num_vmode)
        write(1,rec=itime) w0
        close(1)
      end if
    end if

  end subroutine NMF_output
  !----------------------------------------------------------------------------
  subroutine NMF_outputw(itime)
    use mod_adm
    use mod_time, only: &
        cdate
    implicit none
    integer, intent(in) :: itime
    character(256) :: tmp_fname

    if(output_3DNMF) then
      if(separate_time) then
        tmp_fname=trim(coef3DNMF_windfname)//trim(cdate)
        open(1,file=trim(tmp_fname),form='unformatted',access='direct', &
             recl=16*(num_zw+1)*maxl*3*num_vmode)
        write(1,rec=1) ww0
        close(1)
      else
        open(1,file=trim(coef3DNMF_windfname),form='unformatted',access='direct', &
             recl=16*(num_zw+1)*maxl*3*num_vmode)
        write(1,rec=itime) ww0
        close(1)
      end if
    end if

  end subroutine NMF_outputw
  !----------------------------------------------------------------------------
  subroutine global_mean(nx,ny,nz,ygrid_weight,ttt,glob)
    implicit none
    integer, intent(in) :: nx
    integer, intent(in) :: ny
    integer, intent(in) :: nz
    double precision, intent(in) :: ygrid_weight(ny)
    double precision, intent(inout) :: ttt(nz,nx,ny)
    double precision, intent(inout) :: glob(nz)
    integer :: ix, iy, ip

    glob(:)=0.0d0
    do ip = 1,nz
      do iy = 1,ny
        glob(ip)=glob(ip)+sum(ttt(ip,:,iy))*ygrid_weight(iy)
      end do
    end do
    glob(:)=glob(:)/dfloat(nx)/sum(ygrid_weight)

  end subroutine global_mean
  !----------------------------------------------------------------------------
  subroutine grid_data_order 
  
! This subroutine reorders the input data so that the level 1 is the top level
! it also removes negative orography 
    
    use mod_adm
    implicit none
    integer ::  iz, iy, ix
    double precision :: x(nx,ny,nz)
    double precision :: flilla
    
    x(:,:,:) = 0.0d0
    do iz = 1, nz
      x(:,:,iz) = u_input(:,:,nz-iz+1)
    end do
    u_input(:,:,:) = x(:,:,:)    
    x(:,:,:) = 0.0d0
    do iz = 1, nz
      x(:,:,iz) = v_input(:,:,nz-iz+1)
    end do
    v_input(:,:,:) = x(:,:,:)
    x(:,:,:) = 0.0d0
    do iz = 1, nz
      x(:,:,iz) = t_input(:,:,nz-iz+1)
    end do
    t_input(:,:,:) = x(:,:,:)
    x(:,:,:) = 0.0d0
    do iz = 1, nz
      x(:,:,iz) = q_input(:,:,nz-iz+1)
    end do
    q_input(:,:,:) = x(:,:,:)      

    flilla = 1.0d0-15
    do ix = 1, nx
     do iy = 1, ny
      if ( orog(ix,iy) < 0.0d0 )  orog(ix,iy) = flilla
     end do
    end do
  
  end subroutine grid_data_order 
!----------------------------------------------------------------------------
end module mod_normal
