module mod_output
  implicit none
  private
  !
  public :: output_for_gmt
  public :: output_for_binary
  !
contains
  !----------------------------------------------------------------------------
  subroutine output_for_gmt( ls, m, hftbl, iparj )
    use mod_gaussg, only : &
        deg
    use mod_adm, only :    &
        mk, maxl,          & 
        ofname_gmt,        & 
        bin_combine,        &
        make_idstr
        
    implicit none
    integer, intent(in) :: ls, m
    double precision, intent(in) :: hftbl(mk,3*maxl, 4)
    integer, intent(in) :: iparj(3*maxl)

    integer :: i
    integer :: iy, my
    double precision :: sym
    character(128) :: hough_fname
    double precision, allocatable :: h0(:,:,:) 

      my = 2*mk
      allocate( h0( my, 3*maxl, 3 ) )

      do i = 1, maxl * 3
        if( iparj(i) == 1 ) sym =  1.0d0
        if( iparj(i) == 2 ) sym = -1.0d0
        do iy = 1, mk
          h0(iy, i, 1) = -sym*hftbl(iy, i, 1)
          h0(iy, i, 2) =  sym*hftbl(iy, i, 2)
          h0(iy, i, 3) = -sym*hftbl(iy, i, 3)
          h0(my-iy+1, i, 1) = hftbl(iy, i, 1)
          h0(my-iy+1, i, 2) = hftbl(iy, i, 2)
          h0(my-iy+1, i, 3) = hftbl(iy, i, 3)
        end do
      end do

      if( trim(bin_combine) == 'zonal' ) then
!        call make_idstr( hough_fname, trim(ofname_gmt), 'wn', ls)
        write(*,*) 'Writing: ', ls 
!        open(100+ls, file=trim(hough_fname), position='append', &
!             status='unknown')
       do i = 1, maxl * 3
        do iy = 1, my
          write(100+ls,'(3f20.12,1X)') h0(iy, i, 1),h0(iy, i, 2),h0(iy, i, 3)
        end do
       end do
!        close(100+ls)
      end if
      
! Koji's code       
!    do i = 1, maxl*3
!      if( iparj(i) == 1 ) sym =  1.0d0
!      if( iparj(i) == 2 ) sym = -1.0d0
!      do iy = 1, mk
!        write(101,'(3i4,2f20.12)') ls, m, i, deg(iy), hftbl(iy, i, 1)
!        write(102,'(3i4,2f20.12)') ls, m, i, deg(iy), hftbl(iy, i, 2)
!        write(103,'(3i4,2f20.12)') ls, m, i, deg(iy), hftbl(iy, i, 3)
!      end do
!      do iy = mk, 1, -1
!        write(101,'(3i4,2f20.12)') ls, m, i, -deg(iy), -sym*hftbl(iy, i, 1)
!        write(102,'(3i4,2f20.12)') ls, m, i, -deg(iy),  sym*hftbl(iy, i, 2)
!        write(103,'(3i4,2f20.12)') ls, m, i, -deg(iy), -sym*hftbl(iy, i, 3)
!      end do
!    end do

  end subroutine output_for_gmt
  !----------------------------------------------------------------------------
  subroutine output_for_binary( ls, m, hftbl, iparj )
    use mod_gaussg, only : &
        deg
    use mod_adm, only :    &
        mk, maxl,          &
        bin_combine,       &
        output_global,     &
        ofname_bin,        &
        make_idstr
        
    implicit none
    integer, intent(in) :: ls
    integer, intent(in) :: m
    double precision, intent(in) :: hftbl(mk,3*maxl, 4)
    integer, intent(in) :: iparj(3*maxl)

    character(128) :: hough_fname
    double precision, allocatable :: h0(:,:,:) 
    integer :: i
    integer :: my, iy
    double precision :: sym
    integer :: irec = 0

    irec = irec + 1

    if( output_global ) then

      my = 2*mk
      allocate( h0( my, 3*maxl, 3 ) )

      do i = 1, maxl * 3
        if( iparj(i) == 1 ) sym =  1.0d0
        if( iparj(i) == 2 ) sym = -1.0d0
        do iy = 1, mk
          h0(iy, i, 1) = -sym*hftbl(iy, i, 1)
          h0(iy, i, 2) =  sym*hftbl(iy, i, 2)
          h0(iy, i, 3) = -sym*hftbl(iy, i, 3)
          h0(my-iy+1, i, 1) = hftbl(iy, i, 1)
          h0(my-iy+1, i, 2) = hftbl(iy, i, 2)
          h0(my-iy+1, i, 3) = hftbl(iy, i, 3)
        end do
      end do

      if( trim(bin_combine) == 'zonal' ) then
        call make_idstr( hough_fname, trim(ofname_bin), 'wn', ls)
        write(*,*) ls, trim(hough_fname),my,maxl,m
        open(11, file=trim(hough_fname), form='unformatted', &
          access='direct', recl=8*my*maxl*3*3, status='unknown')
          !access='direct', recl=8*mk*2*maxl*3*3, status='unknown')
        write(11,rec=m) h0
        close(11)
      end if

    else 

      my = mk

      if( trim(bin_combine) == 'zonal' ) then
        open(11, file=trim(ofname_bin), form='unformatted', &
             access='direct', recl=8*mk*2*maxl*3*3)
             !access='direct', recl=8*my*maxl*3*3)
        write(11,rec=1) h0
        close(11)
      end if

    end if

  end subroutine output_for_binary
  !----------------------------------------------------------------------------
end module mod_output
