module mod_numvsf_sigma
  implicit none
  !----------------------------------------------------------------------------
  public :: numvsf_sigma
  !----------------------------------------------------------------------------
contains
  !----------------------------------------------------------------------------
  subroutine numvsf_sigma
    use mod_const
    use mod_adm
    implicit none
    integer :: k, kk, i
    double precision, allocatable :: dsig(:)
    double precision, allocatable :: c(:)
    double precision, allocatable :: d(:)
    double precision, allocatable :: rcon(:)
    double precision, allocatable :: qm(:,:)
    double precision, allocatable :: ort(:)
    double precision :: sufst
    double precision :: rsufc
    double precision :: acon

    double precision, allocatable :: w(:)
    double precision, allocatable :: wr(:)
    double precision, allocatable :: wi(:)
    double precision, allocatable :: vr(:,:)
    double precision, allocatable :: vi(:,:)
    double precision, allocatable :: work(:)
    double precision, allocatable :: oth(:)
    double precision :: summ
    integer :: lwork
    integer :: info

    allocate(dsig(mp+1))
    allocate(c(mp))
    allocate(d(mp))
    allocate(rcon(mp))
    allocate(qm(mp,mp))
    allocate(ort(mp))

    lwork=4*mp
    allocate(w(mp))
    allocate(wr(mp))
    allocate(wi(mp))
    allocate(vr(mp,mp))
    allocate(vi(mp,mp))
    allocate(work(lwork))
    allocate(oth(mp))

    sufst=stab(1)
    acon =sufst/suft

    do k = 2,mp
      dsig(k)=vgrid(k-1)-vgrid(k)
    end do
    dsig(   1)=2.0d0*(1.0d0-vgrid(1))
    dsig(mp+1)=2.0d0*vgrid(mp)

    do k = 1,mp
      d(k)=dsqrt(0.5d0*(dsig(k)+dsig(k+1)))
    end do

    do k = 1,mp-1
      rcon(k)=g*hstd/(rd*stab(k+1))
    end do
    rsufc=g*hstd/(rd*sufst)
    
    do k = 2,mp
      c(k)=-0.5d0*(vgrid(k)+vgrid(k-1))*rcon(k-1)/dsig(k)
    end do
    c(1)=-rsufc*acon/(1.0d0+0.5d0*acon*dsig(1))

    do k = 1,mp+1
      write(*,*) k, dsig(k)
    end do 
    do k = 1,mp
      write(*,'(i4,3f20.9)') k, c(k), d(k), rcon(k)
    end do 

    qm(:,:)=0.0d0

    do k = 2,mp-1
      qm(k,k-1)=c(k)/(d(k-1)*d(k))
      qm(k,k  )=-(c(k)+c(K+1))/(d(k)*d(k))
      qm(k,k+1)=c(k+1)/(d(k)*d(k+1))
    end do

    qm(1,1)=-(c(1)+c(2))/(d(1)*d(1)) 
    qm(1,2)= c(2)/(d(1)*d(2)) 
    qm(mp,mp-1)=c(mp)/(d(mp-1)*d(mp))
    qm(mp,mp  )=-c(mp)/(d(mp)*d(mp))

    call dsyev('V','U',mp,qm,mp,w,work,lwork,info)
    write(*,*) hstd/w

    do k = 1,num_vmode
      evht(k)=hstd/w(k)
    end do
    
    do k = 1,mp
      summ=0.0d0
      do kk = 1,mp
        summ = summ + qm(kk,k)**2
      end do
      summ = dsqrt(summ)
      qm(:,k) = qm(:,k)/summ
    end do

    do k = 1,mp
      oth(:)=0.0d0
      do kk = 1,mp
        do i = 1,mp
          oth(kk)=oth(kk)+qm(i,k)*qm(i,kk)
        end do
      end do
      if(ocheck) then
        write(*,*) oth
      end if
    end do

    vsf(1:mp,1:num_vmode)=qm(1:mp,1:num_vmode)

  end subroutine numvsf_sigma
  !----------------------------------------------------------------------------
end module mod_numvsf_sigma
