#include <meteoio/MeteoIO.h>
#include <iostream>
#include <sstream>
#include <fstream>
#include <string>
#include <vector>
#include <cstdlib>

using namespace mio; //The MeteoIO namespace is called mio
using namespace std;

void read_with_meteoio()
{
	cout << endl << "-- Reading SMET ASCII through MeteoIO --" << endl;
	Config cfg("io.ini");
	UsageTimer timer;

	IOManager io(cfg);
	io.setProcessingLevel(IOManager::raw);
	const double tz = cfg.get("TIME_ZONE", "Input");

	Date d1(2000,10,1,0,0,tz); // start date
	Date d2(2001,10,1,0,0,tz); // end date

	vector< vector<MeteoData> > vecMeteo;

	timer.start();
	io.getMeteoData(d1, d2, vecMeteo);	
	timer.stop();

	cout << timer.getElapsed() << "  USR: " << timer.getElapsedUserTime() << "  SYS: " << timer.getElapsedSystemTime() << endl;
	timer.restart();

	//cout << endl << "Writing output data:" << endl;
	//io.writeMeteoData(vecMeteo);
	//timer.stop();
	//cout << timer.getElapsed() << "  USR: " << timer.getElapsedUserTime() << "  SYS: " << timer.getElapsedSystemTime() << endl;
}

double convert_to_double(const std::string& in_string)
{
	cout << in_string << endl;
	istringstream ss(in_string);
	double value;
	if (!(ss >> value)) throw;

	return value;
}

void read_pure_cpp() 
{
	cout << endl << "-- Reading SMET ASCII through CPP --" << endl;
	Config cfg("io.ini");
	string filename = cfg.get("Station1", "Input");
	filename += ".smet";

	UsageTimer timer;
	timer.start();
	cout << "Reading file: " << filename << endl;

	vector< vector<string> > result_str;
	vector< vector<double> > result_dbl;
	ifstream input(filename.c_str());
	string lineData = "";

	vector<string> row_str;
	vector<double> row_dbl;

	//static double parsing = 0;
	//clock_t start = std::clock();
	while(getline(input, lineData)) {
		row_str.clear();
		row_dbl.clear();

		string d;

		stringstream lineStream(lineData);
		char* end;
		while (lineStream >> d) {
			//start = std::clock();
			//row_str.push_back(d);

			double value = strtod(d.c_str(),&end);
			if (*end=='\0') {
				//cout << d << endl;
				row_dbl.push_back(value);
			} else {
				//cout << d << endl;
				row_str.push_back(d);
			}
			//parsing += ( std::clock() - start );
		}
		result_str.push_back(row_str);
		result_dbl.push_back(row_dbl);
	}
	
	//double o = parsing / (double)CLOCKS_PER_SEC;
	//cout << "Mere parsing: " << setprecision(10) << fixed << o << endl;
	timer.stop();
	cout << timer.getElapsed() << "  USR: " << timer.getElapsedUserTime() << "  SYS: " << timer.getElapsedSystemTime() << endl;
}

int main() {
	try {
		read_with_meteoio();
		read_pure_cpp();
	} catch(const std::exception &e) {
		std::cerr << e.what();
		exit(1);
	}
	return 0;
}
