#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

int main(void)
{
	clock_t start, end;
     double cpu_time_used;
	start = clock();

	FILE * fp;
	char * line = NULL;
	size_t len = 0;
	ssize_t read;
	char seps[]   = " ,\t\n";
	char **matrix = NULL;
	double **matrix_num = NULL;
	int lines=0, i=0, data=0;

	fp = fopen("WFJ10.smet", "r");
	if (fp == NULL) exit(EXIT_FAILURE);
	
	while ((read = getline(&line, &len, fp)) != -1) {
		char *token=NULL, *res=NULL;
		double *numbers=NULL;
		int n_spaces=0, number=0;

		token = strtok (line, seps);

		if (data) {
			lines++;

			while (token != NULL) {
				char *name = malloc(25*sizeof(char));
				char *tmp = malloc(25*sizeof(char));
				char* end = NULL;
				double t;

				strcpy(tmp, token);
				t = strtod(tmp, &end); 

				if ((*end != 0)) { //we have a string
					n_spaces++;
					strcpy(name, token);
					res = name;
				} else { //we have a number
					number++;
					numbers = realloc (numbers, sizeof (double) * number);
					numbers[number-1] = t;
					free(name);
				}

				free(tmp);
				token = strtok (NULL, seps);
			}

			matrix_num = realloc (matrix_num, sizeof (double**) * lines);
			matrix_num[lines-1] = numbers;

			matrix = realloc (matrix, lines * sizeof (char*));
			matrix[lines-1] = res;
		}

		if (strcmp(line, "[DATA]") == 0) data = 1; // Skip the header
	}


	end = clock();
     cpu_time_used = ((double) (end - start)) / CLOCKS_PER_SEC;

	printf("Read %i lines in %5.3f seconds\n", lines, cpu_time_used);

	//
	// Deallocation is not a part of the benchmark:
	//
	free(line);
	fclose(fp);
	if (matrix_num != NULL) {
		for (i=0; i<lines; i++) {
			free(matrix_num[i]);
		}
	}
	free(matrix_num);

	if (matrix != NULL) {
		for (i=0; i<lines; i++) {
			free(matrix[i]);
		}
	}
	free(matrix);

	exit(EXIT_SUCCESS);
}
