#include <iostream>
#include <meteoio/MeteoIO.h>

using namespace mio; //The MeteoIO namespace is called mio
using namespace std;

void real_main() {
	Config cfg("io.ini");
	UsageTimer timer;


	IOManager io(cfg);
	//io.setProcessingLevel(IOManager::raw | IOManager::resampled);

	const double tz       = cfg.get("TIME_ZONE", "Input");
	const double timestep = 1./3./24.; //sampling rate = 1/24 day = 1 hour

	Date d1(2000,10,1,0,0,tz); // start date
	Date d2(2012,10,1,0,0,tz); // end date

	vector<MeteoData> meteo;
	vector< vector<MeteoData> > vecMeteo;

	timer.start();
	//io.getMeteoData(d1, d2, vecMeteo);	
	
	io.getMeteoData(d1, meteo);
	vecMeteo.insert(vecMeteo.begin(), meteo.size(), std::vector<MeteoData>()); //allocation for the vectors

	for(; d1<=d2; d1+=timestep) { //time loop
		//cout << "Reading timestep: " << d1.toString(Date::ISO) << endl;

		io.getMeteoData(d1, meteo); //read 1 timestep at once, forcing resampling to the timestep
		for(size_t ii=0; ii<meteo.size(); ii++) {
			vecMeteo.at(ii).push_back(meteo[ii]); //fill the data manually into the vector of vectors
		}
	}
	timer.stop();
	
	cout << timer.getElapsed() << "  USR: " << timer.getElapsedUserTime() << "  SYS: " << timer.getElapsedSystemTime() << endl;
	//io.print_times();
	timer.restart();

	cout << endl << "Writing output data:" << endl;
	io.writeMeteoData(vecMeteo);
	timer.stop();
	cout << timer.getElapsed() << "  USR: " << timer.getElapsedUserTime() << "  SYS: " << timer.getElapsedSystemTime() << endl;
}

int main() {
	try {
		real_main();
	} catch(const std::exception &e) {
		std::cerr << e.what();
		exit(1);
	}
	return 0;
}
