C---------------------------------------------------------------------
      PROGRAM main
C---------------------------------------------------------------------
C     12/01/13/ Aitbala Sargent and James Fastook
C        Solves 1-D shelf equation using
C          (a) direct linear algorithm and
C          (b) traditional iterative non-linear algorithm.
C     Ice parameters: rho, rhow, n, g, and
C     model parameters: omega, tana, c, ab, Lx, and
C     scale parameter: xs, zs, us, taus 
C         - are assigned in "parameter1d.h". 
C 
C     Linear and non-linear algorithm solutions are dumped to files 
C          1du.data and 1dtau.data.
C     Time of calculations and errors of the algorithms are dumped to files
C          1dtime.data and 1derr.data.
C---------------------------------------------------------------------
      IMPLICIT none
      INTEGER nx
      print *,'enter the size of the problem'
      read *,nx
      call algorithm(nx)
      STOP
      END
C---------------------------------------------------------------------
      SUBROUTINE algorithm(nx)
C---------------------------------------------------------------------
      IMPLICIT none
      INTEGER nx,iter
      DOUBLE PRECISION x(nx),surf(nx),h(nx),ss(nx)
      DOUBLE PRECISION u(nx),tau(nx)
      DOUBLE PRECISION ux(nx),taux(nx)
      DOUBLE PRECISION ui(nx),taui(nx)
      DOUBLE PRECISION sf,erru,errtau,errui,errtaui
      REAL dtime,t1,t2,ta(2)
      LOGICAL existtime,existerr
C ---
C   create or open files to write the errors and time of calculation of algorithms.
C ---
      INQUIRE(FILE='1dtime.data',EXIST=existtime)
      if(existtime) then
        OPEN(20,file='1dtime.data',status='old',access='append')
      else
        OPEN(20,file='1dtime.data',status='new',access='append')
      endif
      INQUIRE(FILE='1derr.data',EXIST=existerr)
      if(existerr) then
        OPEN(21,file='1derr.data',status='old',access='append')
      else
        OPEN(21,file='1derr.data',status='new',access='append')
      endif
C ---
C --- calculate manufactured analytical solution of 1d shelf equation
C ---
      call EXACT(nx,x,ux,taux,h,surf,ss,sf)
      print *,'grid size = ',nx
C ---
C --- calculate velocity,u, and stress,tau, with linear algorithm
C ---
      t1 = dtime(ta)
      CALL DIRECT(nx,x,h,surf,ss,sf,u,tau,ux,taux,erru,errtau)
      t1 = dtime(ta)
      print *,'Direct method took:',t1,' seconds.'
      print *,'erru=',erru,' errtau=',errtau
C ---
C --- calculate velocity,ui, and stress,taui, with iterative algorithm
C ---
      t2 = dtime(ta)
      CALL ITERAT(nx,x,h,surf,ss,sf,ui,taui,ux,taux,errui,errtaui,iter)
      t2 = dtime(ta)
      print *,'Iterative method took:',t2,' seconds.'
      print *,'errui=',errui,' errtaui=',errtaui,' iter=',iter
      write(20,10) nx,t1,t2
      close(20)
      write(21,10) nx,erru,errtau,errui,errtaui,iter
      close(21)
C ---
C --- dump the calculated solutions and errors
C ---
      CALL dump(nx,x,u,h,ux,surf,ss,tau,taux,ui,taui)
10    format(i8,2x,4(e10.3,2x),i4)
      RETURN
      END
C---------------------------------------------------------------------
      SUBROUTINE dump(nx,x,u,h,ux,surf,ss,tau,taux,ui,taui)
C---------------------------------------------------------------------
C     Dumps values of exact solutions (ux, taux) and solutions
C       calculated with linear (u, tau) and iterative (ui, taui) algorithms.  
C---------------------------------------------------------------------
      IMPLICIT none
      INCLUDE "parameter1d.h"
      DOUBLE PRECISION x(nx),surf(nx),h(nx),ss(nx)
      DOUBLE PRECISION u(nx),tau(nx)
      DOUBLE PRECISION ux(nx),taux(nx)
      DOUBLE PRECISION ui(nx),taui(nx)
      DOUBLE PRECISION halfdx,xx,xx2
      INTEGER nx,nstep,i
          OPEN(11,file='1du.data')
          OPEN(12,file='1dtau.data')
          nstep = 1
          if(nx.gt.40000) nstep = (nx-1)/40000+1
          halfdx = (x(2)-x(1))/2.d0
          DO i=1,nx,nstep
            xx=x(i)*xs
            xx2=(x(i)+halfdx)*xs
            WRITE(11,*) xx,u(i)*us,ui(i)*us,ux(i)*us,
     &                  (surf(i)-h(i))*zs,surf(i)*zs
            if(i.ne.nx) WRITE(12,*) xx2,tau(i)*taus,
     &       taui(i)*taus,taux(i)*taus,(surf(i)-h(i))*zs,surf(i)*zs
          ENDDO
          CLOSE(11)
          CLOSE(12)
      END
C---------------------------------------------------------------------
      SUBROUTINE EXACT(nx,x,ux,taux,h,surf,ss,sf)
C---------------------------------------------------------------------
C     Defines manufactured analytical solutions of 1D shelf equation
C---------------------------------------------------------------------
      IMPLICIT none
      INCLUDE "parameter1d.h"
c
      DOUBLE PRECISION x(nx),surf(nx),bed(nx),h(nx),ss(nx)
      DOUBLE PRECISION ux(nx),taux(nx)
      DOUBLE PRECISION dx,sf,s0x,dsdx,d2sdx2,dbdx,d2bdx2,dudx,d2udx2
      DOUBLE PRECISION xx,sinx,cosx,sin2x,cos2x,eta,etap,etap2
      DOUBLE PRECISION hh,dhdx,d2hdx2,xnuu
      DOUBLE PRECISION surf1,bed1,ux1
      INTEGER nx,i
        dx=Lx/(nx-1)
      do i=1,nx
C---  calculate velocity, bed, surface, ice thickness, 
C---      and RHS(ss) functions at the nodes
        xx   = (i-1)*dx
        x(i) = xx
        s0x    = -delta*tana*xx
        surf1  = s0x
        dsdx   = -delta*tana
        d2sdx2 = 0.d0
          cosx   = cos(omega*xx)
          sinx   = sin(omega*xx)
          sin2x  = 2.d0*sinx*cosx
          cos2x  = cosx*cosx-sinx*sinx
          eta    = ab*sinx*sinx
          etap   = ab*omega*sin2x
          etap2  = 2.*ab*omega**2*cos2x
        bed1   = s0x-1+eta
        dbdx   = dsdx+etap
        d2bdx2 = etap2
        hh     = surf1 - bed1
        dhdx   = dsdx-dbdx
        d2hdx2 = d2sdx2-d2bdx2
        ux1    = c/hh
        dudx   = -ux1/hh*dhdx
        d2udx2 = ux1/hh*( dhdx**2*2.d0/hh-d2hdx2 )
        if(dudx.gt.0.) then
          xnuu = (dudx)**(1./n)
        else
          xnuu = -(abs(dudx))**(1./n)
        endif
        bed(i) = bed1
        surf(i)= surf1
        h(i)   = hh
        ux(i)  = ux1
        ss(i)  = xnuu/(dudx+1.e-18)*(hh/n*d2udx2+dhdx*dudx)-hh*dsdx ! RHS(at the nodes)
C---
C---    calculate stress at the staggered grid
C---
        if(i.eq.nx) then       ! define taux at the node of a cell
          taux(i) = xnuu*hh
        else                   ! define at the middles of the cells
          xx    = xx+dx/2.
          surf1 = -delta*tana*xx
          cosx  = cos(omega*xx)
          sinx  = sin(omega*xx)
          sin2x = 2*sinx*cosx
          cos2x = cosx*cosx-sinx*sinx
          eta   = ab*sinx*sinx
          etap  = ab*omega*sin2x
          etap2 = 2.*ab*omega**2*cos2x
          bed1  = surf1-1.d0+eta
          dbdx  = dsdx+etap
          d2bdx2= etap2
          hh    = surf1 - bed1
          dhdx  = dsdx-dbdx
          ux1   = c/hh
          dudx  = -ux1/hh*dhdx
        d2hdx2  = d2sdx2-d2bdx2
        d2udx2  = ux1/hh*( dhdx**2*2.d0/hh-d2hdx2 )
          if(dudx.gt.0.) then
            xnuu = (dudx)**(1./n)
          else
            xnuu = -(abs(dudx))**(1./n)
          endif
          taux(i) = xnuu*hh
        endif
C ---
      enddo
        sf = taux(nx) - 0.25*(1.-rho/rhow)*h(nx)*h(nx)     ! BC RHS at the node n
      RETURN
      END
C---------------------------------------------------------------------
      SUBROUTINE DIRECT(nx,x,h,surf,ss,sf,u,tau,ux,taux,erru,errtau) 
C ---
C ---   solve 1D shelf equation with a linear algorithm
C ---
C---------------------------------------------------------------------
      IMPLICIT none
      INCLUDE "parameter1d.h"
      DOUBLE PRECISION x(nx),surf(nx),h(nx),ss(nx)
      DOUBLE PRECISION u(nx),tau(nx)
      DOUBLE PRECISION ux(nx),taux(nx)
      DOUBLE PRECISION sf,erru,errtau,dx,twodx,dx2
      DOUBLE PRECISION hh,ss1,dsdx,hdsdx,ff
      INTEGER nx,i,im,ip
C ---
c  calculate stress, tau, with the 2-nd order accuracy 
C ---
      dx  = x(2)-x(1)
      twodx = dx*2.d0
      dx2 = dx*dx
      tau(nx)=0.25d0*(1.d0-rho/rhow)*h(nx)*h(nx)+sf
C ---
        hh = 0.75*h(nx)+0.25*h(nx-1)
        ss1 = 0.75*ss(nx)+0.25*ss(nx-1)
        dsdx=(1.25*surf(nx)-1.5*surf(nx-1)+0.25*surf(nx-2))/dx
        tau(nx-1)=tau(nx)-0.5*dx*(hh*dsdx+ss1)
C ---
        do i=nx-1,2,-1
          im = i-1
          hdsdx=h(i)*(surf(i+1)-surf(im))/twodx
          tau(im)=tau(i)-dx*(hdsdx+ss(i))
        enddo
C ---
c  calculate velocity, u
C ---
        u(1)=ux(1)
        do i=1,nx-1
          ip = i+1
          hh = 0.5*(h(i)+h(ip))
          ff = tau(i)/hh
          if(ff.lt.0) then
            ff = -(abs(ff))**n
          else
            ff = ff**n
          endif
          u(ip) = u(i)+dx*ff
        enddo
c --- calculate accuracy
      erru = 0.d0
      errtau = 0.d0
      do i=1,nx-1
        erru = erru+(u(i)-ux(i))*(u(i)-ux(i))
        errtau = errtau+(tau(i)-taux(i))*(tau(i)-taux(i))
      enddo
        erru = erru+(u(nx)-ux(nx))*(u(nx)-ux(nx))
        erru = sqrt(erru/nx)
        errtau = sqrt(errtau/nx)
      return
      end
C---------------------------------------------------------------------
      SUBROUTINE ITERAT(nx,x,h,surf,ss,sf,ui,taui,ux,
     &                  taux,errui,errtaui,iter)
C ---
C ---   solve 1D shelf equation with a traditional iterative algorithm
C ---
C---------------------------------------------------------------------
      IMPLICIT none
      INCLUDE "parameter1d.h"
      DOUBLE PRECISION x(nx),surf(nx),h(nx),ss(nx)
      DOUBLE PRECISION ux(nx),taux(nx)
      DOUBLE PRECISION ui(nx),taui(nx)
C---  for solving 3-diagonal SLE............
      DOUBLE PRECISION uk(nx),xmu(nx)
      DOUBLE PRECISION aa(nx),bb(nx),cc(nx)
      DOUBLE PRECISION al(nx),be(nx),ff(nx)
C ---
      DOUBLE PRECISION dx,dx2,hn,dsdx,dd,dudx
      DOUBLE PRECISION sf,errui,errtaui,errold
      INTEGER iter,nx,i
C ---
      dx=x(2)-x(1)
      dx2 = dx*dx
      errui = 1.e+24
      iter = 0
      do i=1,nx
        if(i/2*2 .eq. i) then
          uk(i) = 1.d0
        else
          uk(i) = 0.d0
        endif
      enddo
      uk(1) = ux(1)
 1    iter = iter+1
      errold = errui
      call UPDATENU(nx,x,uk,xmu)
      hn = (h(1)+h(2))*0.5d0
      aa(1) = xmu(1)*hn/dx2
      cc(1) = 0.d0
      bb(1) = 1.d0
      ff(1) = ux(1)
      do i=2,nx-1
        hn = (h(i)+h(i+1))*0.5d0
        aa(i) = xmu(i)*hn/dx2
        cc(i) = aa(i)
        bb(i) = -aa(i-1)-cc(i)
        dsdx  = ( surf(i+1)-surf(i-1) )/(2.d0*dx)
        ff(i) = h(i)*dsdx+ss(i)
      enddo
      hn = (h(nx)+h(nx-1))*0.5d0
      aa(nx-1) = -xmu(nx-1)*hn/dx
      bb(nx) = -aa(nx-1)
      ff(nx) = taux(nx-1)
c......... calculate alpha and beta ..........
      al(1) = -cc(1)/bb(1)
      be(1) = ff(1)/bb(1)
      do i=2,nx
        dd = bb(i) +aa(i-1)*al(i-1)
        al(i) = -cc(i)/dd
        be(i) = (ff(i)-aa(i-1)*be(i-1))/dd
      enddo
      ui(nx) = be(nx)
      do i=nx-1,1,-1
        ui(i)=al(i)*ui(i+1)+be(i)
      enddo
c........... calculate the criteria of stopping
      errui = 0.d0
      do i=1,nx
        errui = errui+(ui(i)-uk(i))**2
        uk(i) = ui(i)
      enddo
        errui = sqrt(errui/nx)
      if(errui.lt. errold) goto 1
      errui = 0.d0
      errtaui = 0.d0
      do i=1,nx-1
        dudx = (ui(i+1)-ui(i))/dx
        taui(i) = xmu(i)*dudx*(h(i)+h(i+1))/2.
        errtaui = errtaui+(taui(i)-taux(i))*(taui(i)-taux(i))
        errui = errui+(ui(i)-ux(i))*(ui(i)-ux(i))
      enddo
        errui = errui+(ui(nx)-ux(nx))*(ui(nx)-ux(nx))
        taui(nx)=0.25*(1.-rho/rhow)*h(nx)*h(nx)+sf
        errtaui = sqrt(errtaui/nx)
        errui = sqrt(errui/nx)
      return
      end
C---------------------------------------------------------------------
      SUBROUTINE UPDATENU(nx,x,u,xnu)
C---------------------------------------------------------------------
      IMPLICIT none
      INCLUDE "parameter1d.h"
      DOUBLE PRECISION x(nx),u(nx),xnu(nx),dudx,eps
      INTEGER nx,i
      PARAMETER(eps=1.d-15)
C ---
      DO i=1,nx-1
        dudx = (u(i+1)-u(i)) / (x(i+1)-x(i))
        xnu(i) = (abs(dudx)+eps)**((1.-n)/n)
      ENDDO
       xnu(nx)=xnu(nx-1)
C ---
      RETURN
      END
C---------------------------------------------------------------------
