       program OAQGWFv2 
c
       real*8 n,phi0,rra,sig0,k,kp,hpp,r,d,f0,bet,gp,H,a
       integer*8 itr,mm,nt,klk,i
c
       parameter(itr=10000000,mm=500000000,nt=itr+mm)
       parameter(nbparam=1)
c
       parameter(scale=5000000.D0,n=1.50D0,a=1.D0)
       parameter(gp=0.031D0,H=500.D0,f0=0.0001032D0)
       parameter(r=0.00000001D0,d=0.0000002D0,dt=0.01)
       parameter(phi0=45.D0,rra=6370000.D0,sig0=0.1D0)
       parameter(k=0.0200D0, kp=0.0400D0, hpp=0.0400D0)
c
c      V2, 25/08/2013. S. VANNITSEM.
c      
c      WARNING:
c      THE ATMOSPHERIC COMPONENT OF THE MODEL IS BASED ON THE PAPERS OF CHARNEY AND STRAUS (1980) AND REINHOLD AND PIERREHUMBERT
c      (1982), BOTH IN JOURNAL OF ATMOSPHERIC SCIENCES. THE COEFFICIENTS APPEARING IN THE EQUATIONS AS DEFINED BELOW ARE BASED 
c      ON NOTATIONS USED IN BOTH PAPERS. THE NOTATION OF REINHOLD AND PIERREHUMBERT IS USED WHEN THE ADDITIONAL MODES 7 to 
c      10 ARE APPEARING IN THE EQUATIONS. 
c
c      MAIN PARAMETERS:   
c
c                        TIME INTEGRATION PARAMETERS
c
c                        'itr': transient period
c                        'mm': length of trajectory on the attractor
c                        'nbparam': Number of realizations for different parameters or different initial conditions if needed
c                        'dt': the time step
c
c                        SCALE PARAMETERS FOR THE OCEAN AND THE ATMOSPHERE
c
c                        'scale': the characteristic space scale (pi*L).
c                        'f0': the coriolis parameter at 45 degrees latitude
c                        'n': the aspect ratio
c                        'phi0': reference latitude
c                        'rra': Earth radius
c
c                        PARAMETERS FOR THE OCEAN
c
c                        'gp': the reduced gravity.
c                        'r': the frictional coefficient at the bottom
c                        'H': the depth of the water layer
c                        'a': the coefficient characterizing the intensification of the flow on western boundaries
c                        'd': the coupling parameter (should be divided by f0 in order to be adimensional)
c
c                        PARAMETERS FOR THE ATMOSPHERE
c                        
c                        'k': bottom friction coefficient
c                        'kp': internal friction coefficient 
c                        'hpp': coefficient associated with the thermal relaxation time scale (Newtonian Heating)
c                        'sig0': Static stability
c
c
c
c                         AN IMPORTANT PARAMETERS IN THE CORE OF THE PROGRAM ACTING IN THE ATMOSPHERE
c
c                        'thetastar': the thermal forcing
c
c
       real*8 psi(20),theta(20) 
       real*8 psi1(20),theta1(20) 
       real*8 f(20),fff(20),rkkr,rpdp
       real*8 FF,Fp,bete,bett,alph
       real*8 L,tdel,kap,kapp,NN,thet,betpp
       real*8 del,eps,epss,alphp,alphpp,delp,betp
       real*8 fpp,thetastar,bet1,bet2,timeunit
       real*8 C2,C3,C4,C5,C6,rc1,rc2,rc3,rc4,rc5,rc6,CC1
       real*8 rc991,rc992,rc993,fppp,fpppp,kappp,kapppp
       real*8 rc771,rc772,rc773,rc774
       real*8 rc71,rc72,rc73,rc74,rc51
       real*8 rc81,rc82,rc83,rc84
       real*8 rc91,rc92,rc93,rc94
       REAL*8 LX,LY,pi,G,LR,rp,dp
       REAL*8 K12,K13,K14,K32,K33,K34
       REAL*8 K17,K18,K29,K210,K37,K38,K49,K410
       REAL*8 L114,L112,L123,L134,L312,L314,L323,L334
       REAL*8 a1,b1,c1,d1,e1,f1,g12,g13,g14,c0,d0,e0
       real*8 g17,g18,s29,s210,ff0
       REAL*8 u14n,u12n,u23n,u34n,u1l,u3l,u2c,u3c,u4c
       REAL*8 w14n,w12n,w23n,w34n,w1l,w3l,w2c,w3c,w4c
       REAL*8 u7c,u8c,w7c,w8c
       REAL*8 K21,K25,K26,K41,K45,K46
       REAL*8 L211,L233,L213,L411,L433,L413
       REAL*8 n1,m1,o1,p1,q1,r1,s21,s26,s25,p0,o0,q0,r0
       REAL*8 v11n,v33n,v13n,v2l,v4l,v1c,v5c,v6c,v9c,v10c
       REAL*8 x11n,x33n,x13n,x2l,x4l,x1c,x5c,x6c,x9c,x10c
       REAL*8 AA(4),BB(10),a1b1,m1n1
       REAL*8 AAA(4),ff1,ff2,ff3,ff4
       REAL*8 ff31,ff41,ff21,ff11
       REAL*8 C112,C114,C121,C141,C123,C132,C134,C143
       REAL*8 c413,c431,c411,c433
       Real*8 c312,c321,c323,c332
       Real*8 c314,c341,c334,c343
       REAL*8 c231,c213,c211,c233
       REAL*8 Ct112,Ct114,Ct123,Ct134
       REAL*8 ct413,ct411,ct433
       Real*8 ct312,ct323
       Real*8 ct314,ct334
       real*8 ct213,ct211,ct233
       real*8 rmpsi(10)
       real*8 rmtheta(10)
       real*8 rmaa1,rmaa2,rmaa3,rmaa4,rpr
       real*8 D52,D54,D62,D64
       real*8 D71,D73,D81,D83
       real*8 D92,D94,D102,D104
       real*8 D12,D14,D21,D23,D31,D33,D41,D43
       integer*8 nbmean
       
c   
c      SOME GENERAL PARAMETERS (DOMAIN, BETA, GAMMA, COUPLING)
c

       pi=dacos(-1.D0)
       L=scale/pi
       LR=sqrt(gp*H)/f0
       LX=2.*pi*L/n
       LY=pi*L
       G=-L**2/LR**2
       betp=L/rra*cos(pi/4.)/sin(pi/4.)
       rp=r/f0
       dp=d/f0
       rpdp=rp+dp
       write(6,*) 'aspect ratio ',n
       write(6,*) 'space scale ',L
       write(6,*) 'Domain length x ',LX
       write(6,*) 'Domain length y ',LY
       write(6,*) 'beta prime ',betp
       write(6,*) 'gamma ',G
       write(6,*) 'amplitude wind forcing coupling ',dp
       write(6,*) 'bottom friction coeff ',rp
       write(6,*) ' a ',a

C
C      DIMENSIONAL TIME UNIT
C

       tdel=1.D0*dt
       timeunit=1./(0.0001032*24.*3600.)
       write(6,*) 'Time step ', tdel
       write(6,*) ' Time unit (days) ',timeunit

C
C      WRITING FRICTION AND STABILITY PARAMETERS
C
       write(6,*) ' k =  ',k
       write(6,*) ' kp = ',kp
       write(6,*) ' hpp = ',hpp
       write(6,*) 'sig0 = ',sig0

c
c      COEFFICIENTS FOR THE OCEAN MODEL
c
c
c      nonlinear coefficients
c
       c112=2./pi*a*n**4*(4.*a**2-3*n**2-48.)*(1.+exp(-a*2*pi/n))/
     * ((4.*a**2+9*n**2)*(4.*a**2+n**2))
       c121=1./pi*a*n**4*(-4.*a**2+15*n**2+24.)*(1.+exp(-a*2*pi/n))/
     * ((4.*a**2+9*n**2)*(4.*a**2+n**2))
       c114=1./pi*a*n**4*(a**2+n**2-12.)*
     * (1.-exp(-a*2*pi/n))/((a**2+4.*n**2)*(a**2+n**2))
       c141=-1./(4.*pi)*a*n**4*(2.*a**2-19.*n**2-12.)*
     * (1.-exp(-a*2*pi/n))/((a**2+4.*n**2)*(a**2+n**2))
       c123=-1./(2.*pi)*n**4*(a**4-2*a**2*n**2-6.*a**2-3*n**2-3*n**4)*
     * (1.-exp(-a*2*pi/n))/(a*(a**2+4.*n**2)*(a**2+n**2))
       c132=-1./(8.*pi)*n**4*(16.*n**2*a**2-8.*a**4+3.*n**4+48.*n**2
     * +96.*a**2)*(1-exp(-a*2*pi/n))/
     *  (a*(a**2+4.*n**2)*(a**2+n**2))
       c134=-8./pi*a*n**4*(39.*n**4-16*n**2*(-21+a**2)
     *   -16.*a**2*(-12.+a**2))
     * *(1.+exp(-a*2*pi/n))/((4.*a**2+n**2)*(4.*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))
       c143=4./pi*a*n**4*(303.*n**4-16.*a**2*(-6.+a**2)
     *  +8.*n**2*(21.+13.*a**2))
     * *(1.+exp(-a*2.*pi/n))/((4.*a**2+n**2)*(4.*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))

       write(6,*) c112,c121,c114,c141
       write(6,*) c123,c132,c134,c143

       c231=1./(8.*pi)*n**4*(-4.*a**4-22.*a**2*n**2+12.*n**2+3.*n**4)*
     * (1-exp(-a*2.*pi/n))/(a*(a**2+4.*n**2)*(a**2+n**2))
       c213=-1./(2.*pi)*n**4*(a**4+4.*a**2*n**2+3.*n**2+3.*n**4)*
     * (1-exp(-a*2.*pi/n))/(a*(a**2+4.*n**2)*(a**2+n**2))
       c211=-1./pi*n**4*a*(1+exp(-a*2.*pi/n))/(4.*a**2+n**2)
       c233=-4./pi*a*n**4
     * *(1.+exp(-a*2.*pi/n))/(4.*a**2+n**2)

       write(6,*) c231,c213,c211,c233

       c312=1./(8*pi)*n**4*(8*a**4-28*a**2*n**2-96*a**2+3*n**4+48*n**2)*
     * (1.-exp(-a*2.*pi/n))/(a*(a**2+4.*n**2)*(a**2+n**2))
       c321=-1./(8*pi)*n**4*(4*a**4-44*a**2*n**2-24*a**2+3*n**4+12*n**2)
     * *(1.-exp(-a*2.*pi/n))/(a*(a**2+4.*n**2)*(a**2+n**2))
       c323=-4./pi*a*n**4*(-128.*a**2*n**2-120.*n**2-345.*n**4-96.*a**2
     * +16.*a**4)
     * *(1.+exp(-a*2.*pi/n))/((4*a**2+n**2)*(4.*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))
       c332=8./pi*a*n**4*(-56.*a**2*n**2-240.*n**2-15.*n**4-192.*a**2
     * +16.*a**4)
     * *(1.+exp(-a*2.*pi/n))/((4.*a**2+n**2)*(4.*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))
       c314=8./pi*a*n**4*(-8.*a**2*n**2-144.*n**2-81.*n**4-192.*a**2
     * +16.*a**4)
     * *(1.+exp(-a*2.*pi/n))/((4.*a**2+n**2)*(4.*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))
       c341=-4./pi*a*n**4*(-248.*a**2*n**2-72.*n**2-63.*n**4-96.*a**2
     * +16.*a**4)
     * *(1.+exp(-a*2.*pi/n))/((4.*a**2+n**2)*(4.*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))
       c334=-4./(pi)*a*n**4*(-a**2+3.*n**2+12.)*
     * (1.-exp(-a*2.*pi/n))/((a**2+9.*n**2)*(a**2+n**2))
       c343=1./(pi)*a*n**4*(-2.*a**2+30.*n**2+12.)*
     * (1.-exp(-a*2.*pi/n))/((a**2+9.*n**2)*(a**2+n**2))

       write(6,*) c312,c321,c323,c332
       write(6,*) c314,c341,c334,c343

       c433=-2./(pi)*a*n**4*(1.-exp(-a*2.*pi/n))/((a**2+n**2))
       c411=-1./(2.*pi)*a*n**4*(1.-exp(-a*2.*pi/n))/((a**2+n**2))
       c413=-4./pi*a*n**4*(112.*a**2*n**2+48.*n**2+183.*n**4+16.*a**4)
     * *(1.+exp(-a*2.*pi/n))/((4*a**2+n**2)*(4*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))
       c431=-4./pi*a*n**4*(136.*a**2*n**2-48.*n**2+33.*n**4+16.*a**4)
     * *(1.+exp(-a*2.*pi/n))/((4.*a**2+n**2)*(4.*a**2+9.*n**2)
     * *(4.*a**2+25.*n**2))

       write(6,*) c413,c431,c411,c433

       ct112=c112+c121
       ct114=c114+c141
       ct123=c123+c132
       ct134=c134+c143
       write(6,*) 'coeff tot 112 ',ct112
       write(6,*) 'coeff tot 114 ',ct114
       write(6,*) 'coeff tot 123 ',ct123
       write(6,*) 'coeff tot 134 ',ct134
       ct213=c213+c231
       ct211=c211
       ct233=c233
       write(6,*) 'coeff tot 213 ',ct213
       write(6,*) 'coeff tot 211 ',ct211
       write(6,*) 'coeff tot 233 ',ct233
       ct312=c312+c321
       ct323=c323+c332
       ct314=c314+c341
       ct334=c334+c343
       write(6,*) 'coeff tot 312 ',ct312
       write(6,*) 'coeff tot 323 ',ct323
       write(6,*) 'coeff tot 314 ',ct314
       write(6,*) 'coeff tot 334 ',ct334
       ct413=c413+c431
       ct411=c411
       ct433=c433
       write(6,*) 'coeff tot 413 ',ct413
       write(6,*) 'coeff tot 411 ',ct411
       write(6,*) 'coeff tot 433 ',ct433

       if (a.eq.0.) then
          write(6,*) ' a = 0 !! '
          stop
       endif
c
c      INTERMEDIATE COEFFICIENTS OF NONLINEAR TERMS
c
       L112=3.*pi/8./a/n*ct112
       L114=3.*pi/8./a/n*ct114
       L134=3.*pi/8./a/n*ct134
       L123=3.*pi/8./a/n*ct123
       L312=ct312/(a**2-n**2-1.+G)
       L323=ct323/(a**2-n**2-1.+G)
       L314=ct314/(a**2-n**2-1.+G)
       L334=ct334/(a**2-n**2-1.+G)
       L211=3.*pi/8./a/n*ct211
       L233=3.*pi/8./a/n*ct233
       L213=3.*pi/8./a/n*ct213
       L411=ct411/(a**2-n**2-4.+G)
       L433=ct433/(a**2-n**2-4.+G)
       L413=ct413/(a**2-n**2-4.+G)
c
c      LINEAR COEFFICIENTS
c
c
c      K_{i,j}: coefficients of the forcing of the atmosphere on the ocean.
c
       K12=-(n**2+1.)*2./pi*n**2*(1.+exp(a*2.*pi/n))*(4.*a**2-3.*n**2)/
     *      ((4.*a**2+n**2)*(4.*a**2+9.*n**2))
       K13=(n**2+1.)*16./pi*a*n**3*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+n**2)*(4.*a**2+9.*n**2))
       K14=16.*sqrt(2.)/3./pi**2.*n**2*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+n**2))
       K17=n**2/pi*(4.*n**2+1.)*(30.*n**2-8.*a**2)*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+25.*n**2)*(4.*a**2+9.*n**2))
       K18=32.*a*n**3/pi*(4.*n**2+1.)*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+25.*n**2)*(4.*a**2+9.*n**2))

       write(6,*) ' driver K12 ',K12
       write(6,*) ' driver K13 ',K13
       write(6,*) ' driver K14 ',K14
       write(6,*) ' driver K17 ',K17
       write(6,*) ' driver K18 ',K18

       K21=-8.*sqrt(2.)/3./pi**2*n**2*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+n**2))
       K25=-(n**2+4.)*2./pi*n**2*(1.+exp(a*2.*pi/n))*(4.*a**2-3.*n**2)/
     *      ((4.*a**2+n**2)*(4.*a**2+9.*n**2))
       K26=(n**2+4.)*16./pi*a*n**3*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+n**2)*(4.*a**2+9.*n**2))
       K29=4.*n**2/pi*(n**2+1.)*(30.*n**2-8.*a**2)*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+25.*n**2)*(4.*a**2+9.*n**2))
       K210=128.*a*n**3/pi*(n**2+1.)*(1.+exp(a*2.*pi/n))/
     *      ((4.*a**2+25.*n**2)*(4.*a**2+9.*n**2))

       write(6,*) ' driver K21 ',K21
       write(6,*) ' driver K25 ',K25
       write(6,*) ' driver K26 ',K26
       write(6,*) ' driver K29 ',K29
       write(6,*) ' driver K210 ',K210

       K32=-(n**2+1.)/pi*n**2*(1.-exp(a*2.*pi/n))/
     *      ((a**2+4.*n**2))
       K33=2./pi*n**3*(n**2+1.)*(1.-exp(a*2.*pi/n))/(a*(a**2+4.*n**2))
       K34=8.*sqrt(2.)/3./pi**2*n**2*(1.-exp(a*2.*pi/n))/
     *      ((a**2+n**2))
       K37=n**2/pi*(4.*n**2+1.)*(3.*n**2-a**2)*(1.-exp(a*2.*pi/n))/
     *      ((a**2+n**2)*(a**2+9.*n**2))
       K38=4.*a*n**3/pi*(4.*n**2+1.)*(1.-exp(a*2.*pi/n))/
     *      ((a**2+n**2)*(a**2+9.*n**2))

       write(6,*) ' driver K32 ',K32
       write(6,*) ' driver K33 ',K33
       write(6,*) ' driver K34 ',K34
       write(6,*) ' driver K37 ',K37
       write(6,*) ' driver K38 ',K38

       K41=-4.*sqrt(2.)/3./pi**2*n**2*(1.-exp(a*2.*pi/n))/
     *      ((a**2+n**2))
       K45=-(n**2+4.)/pi*n**2*(1.-exp(a*2.*pi/n))/
     *      ((a**2+4.*n**2))
       K46=2./pi*n**3*(n**2+4.)*(1.-exp(a*2.*pi/n))/(a*(a**2+4.*n**2))
       K49=-4.*n**2/pi*(n**2+1.)*(-3.*n**2+a**2)*(1.-exp(a*2.*pi/n))/
     *      ((a**2+n**2)*(a**2+9.*n**2))
       K410=16.*a*n**3/pi*(n**2+1.)*(1.-exp(a*2.*pi/n))/
     *      ((a**2+n**2)*(a**2+9.*n**2))

       write(6,*) ' driver K41 ',K41
       write(6,*) ' driver K45 ',K45
       write(6,*) ' driver K46 ',K46
       write(6,*) ' driver K49 ',K49
       write(6,*) ' driver K410 ',K410

c
c      ADDITIONAL COEFFICIENTS  
c
       a1=3.*pi/8./a/n*(a**2-n**2/4.-1.+G)
       b1=8.*a*n/3./pi/(a**2-n**2-1.+G)
       a1b1=a1+b1
       c1=a*betp/(a**2-n**2-1.+G)-betp/2./a
       d1=-4./3./pi*n*betp/(a**2-n**2-1.+G)-3.*pi*betp/8./n
       e1=-rpdp*((a**2-n**2/4.-1)*3*pi/8/a/n
     *  +8.*a*n/3./pi/(a**2-n**2-1+G))
       f1=-rpdp*(1.-(a**2-n**2-1.)/(a**2-n**2-1.+G))
       c0=a*betp/(a**2-n**2-1.+G)
       d0=-4./3./pi*n*betp/(a**2-n**2-1.+G)
       write(6,*) ' d0 ',d0
       e0=-rpdp*8.*a*n/3./pi/(a**2-n**2-1.+G)
       ff0=rpdp*(a**2-n**2-1)/(a**2-n**2-1.+G)
       g12=dp*(3.*pi/8/a/n*K12-K32/(a**2-n**2-1.+G))
       g13=dp*(3.*pi/8/a/n*K13-K33/(a**2-n**2-1.+G))
       g14=dp*(3.*pi/8/a/n*K14-K34/(a**2-n**2-1.+G))
       g17=dp*(3.*pi/8/a/n*K17-K37/(a**2-n**2-1.+G))
       g18=dp*(3.*pi/8/a/n*K18-K38/(a**2-n**2-1.+G))
       n1=3.*pi/8./a/n*(a**2-n**2/4.-4.+G)
       m1=8.*a*n/3./pi/(a**2-n**2-4.+G)
       p1=a*betp/(a**2-n**2-4.+G)-betp/2./a
       o1=-4./3./pi*n*betp/(a**2-n**2-4.+G)-3*pi*betp/8/n
       q1=-rpdp*((a**2-n**2/4-4.)*3.*pi/8./a/n
     * +8.*a*n/3/pi/(a**2-n**2-4+G))
       r1=-rpdp*(1.-(a**2-n**2-4.)/(a**2-n**2-4.+G))
       p0=a*betp/(a**2-n**2-4.+G)
       o0=-4./3./pi*n*betp/(a**2-n**2-4.+G)
       q0=-rpdp*(8.*a*n/3./pi/(a**2-n**2-4.+G))
       r0=rpdp*(a**2-n**2-4.)/(a**2-n**2-4.+G)
       s21=dp*(3.*pi/8./a/n*K21-K41/(a**2-n**2-4.+G))
       s25=dp*(3.*pi/8./a/n*K25-K45/(a**2-n**2-4.+G))
       s26=dp*(3.*pi/8./a/n*K26-K46/(a**2-n**2-4.+G))
       s29=dp*(3.*pi/8./a/n*K29-K49/(a**2-n**2-4.+G))
       s210=dp*(3.*pi/8./a/n*K210-K410/(a**2-n**2-4.+G))

c
c      FINAL COEFFICIENTS OF THE OCEAN MODEL
c
c      first variable
c
       u14n=-(L114-L314)/a1b1
       u12n=-(L112-L312)/a1b1
       u23n=-(L123-L323)/a1b1
       u34n=-(L134-L334)/a1b1
       u1l=(e1-d1)/a1b1
       u3l=(f1-c1)/a1b1
       u2c=g12/a1b1
       u3c=g13/a1b1
       u4c=g14/a1b1
       u7c=g17/a1b1
       u8c=g18/a1b1
       write(6,*) ' coeff A 1 '
       write(6,*) 'A1 A4 ',u14n
       write(6,*) 'A1 A2 ',u12n
       write(6,*) 'A2 A3 ',u23n
       write(6,*) 'A3 A4 ',u34n
       write(6,*) 'A1 ',u1l
       write(6,*) 'A3 ',u3l
       write(6,*) 'B2 ',u2c
       write(6,*) 'B3 ',u3c
       write(6,*) 'B4 ',u4c
       write(6,*) 'B7 ',u7c
       write(6,*) 'B8 ',u8c
c
c      third variable
c
       w14n=b1*u14n-L314
       w12n=b1*u12n-L312
       w23n=b1*u23n-L323
       w34n=b1*u34n-L334
       w1l=b1*u1l+d0-e0
       w3l=b1*u3l+c0-ff0
       w2c=b1*u2c+dp*K32/(a**2-n**2-1.+G)
       w3c=b1*u3c+dp*K33/(a**2-n**2-1.+G)
       w4c=b1*u4c+dp*K34/(a**2-n**2-1.+G)
       w7c=b1*u7c+dp*K37/(a**2-n**2-1.+G)
       w8c=b1*u8c+dp*K38/(a**2-n**2-1.+G)
       write(6,*) ' coeff A 3 '
       write(6,*) 'A1 A4 ',w14n
       write(6,*) 'A1 A2 ',w12n
       write(6,*) 'A2 A3 ',w23n
       write(6,*) 'A3 A4 ',w34n
       write(6,*) 'A1 ',w1l
       write(6,*) b1,(e1-d1)/a1b1,d0,e0
       write(6,*) 'A3 ',w3l
       write(6,*) 'B2 ',w2c
       write(6,*) 'B3 ',w3c
       write(6,*) 'B4 ',w4c
       write(6,*) 'B7 ',w7c
       write(6,*) 'B8 ',w8c
c
c      second variable
c
       m1n1=m1+n1
       v11n=-(L211-L411)/m1n1
       v33n=-(L233-L433)/m1n1
       v13n=-(L213-L413)/m1n1
       v2l=(q1-o1)/m1n1
       v4l=(r1-p1)/m1n1
       v1c=s21/m1n1
       v5c=s25/m1n1
       v6c=s26/m1n1
       v9c=s29/m1n1
       v10c=s210/m1n1
       write(6,*) ' coeff A 2 '
       write(6,*) 'A1 A1 ',v11n
       write(6,*) 'A3 A3 ',v33n
       write(6,*) 'A1 A3 ',v13n
       write(6,*) 'A2 ',v2l
       write(6,*) 'A4 ',v4l
       write(6,*) (r1-p1),m1n1
       write(6,*) 'B1 ',v1c
       write(6,*) 'B5 ',v5c
       write(6,*) 'B6 ',v6c
       write(6,*) 'B9 ',v9c
       write(6,*) 'B10 ',v10c
c
c      fourth variable
c
       x11n=m1*v11n-L411
       x33n=m1*v33n-L433
       x13n=m1*v13n-L413
       x2l=m1*v2l+o0-q0
       x4l=m1*v4l+p0-r0
       x1c=m1*v1c+dp*K41/(a**2-n**2-4.+G)
       x5c=m1*v5c+dp*K45/(a**2-n**2-4.+G)
       x6c=m1*v6c+dp*K46/(a**2-n**2-4.+G)
       x9c=m1*v9c+dp*K49/(a**2-n**2-4.+G)
       x10c=m1*v10c+dp*K410/(a**2-n**2-4.+G)
       write(6,*) ' coeff A 4 '
       write(6,*) 'A1 A1 ',x11n
       write(6,*) 'A3 A3 ',x33n
       write(6,*) 'A1 A3 ',x13n
       write(6,*) 'A2 ',x2l
       write(6,*) 'A4 ',x4l
       write(6,*) 'B1 ',x1c
       write(6,*) 'B5 ',x5c
       write(6,*) 'B6 ',x6c
       write(6,*) 'B9 ',x9c
       write(6,*) 'B10 ',x10c
c
c      COUPLING COEFFICIENTS, feedback to the atmosphere, D_{i,j}
c

       D12=-2./3./pi**2*sqrt(2.)*(1.+exp(-a*2.*pi/n))*n**2
     * *(4*a**2+n**2+16.)/(4.*a**2+n**2)
       D14=-4./3./pi**2*sqrt(2.)*(1.-exp(-a*2.*pi/n))*n**2
     * *(a**2+n**2+4.)/(a**2+n**2)
       D21=n/pi*(1.+exp(-a*2.*pi/n))*(-8.*a**4*n-28.*a**2*n**3-
     * 8*n*a**2+3./2.*n**5+6.*n**3)/((4.*a**2+n**2)*(4.*a**2+9.*n**2))
       D23=-n**2/pi*(1.-exp(-a*2.*pi/n))*(5.*n**2+a**2+1.)/(a**2+4*n**2)
       D31=-16./pi*(1.+exp(-a*2.*pi/n))*a*n**3*(n**2+1.)/
     * ((4.*a**2+n**2)*(4.*a**2+9.*n**2))
       D33=-2./pi*n**3*(n**2+1.)/(a**2+4.*n**2)*(1.-exp(-a*2.*pi/n))/a
       D41=4./3./pi**2*sqrt(2.)*(1.+exp(-a*2.*pi/n))*n**2
     * *(a**2+n**2/4.+1.)/(4.*a**2+n**2)
       D43=2./3.*sqrt(2.)/pi**2*(1.-exp(-a*2.*pi/n))*n**2*(a**2+n**2+1.)
     * /(a**2+n**2)
       D52=n**2/(2.*pi)*(1.+exp(-a*2.*pi/n))*(-16.*a**2*(a**2+4.)+3*n**4
     * -8.*(7.*a**2-6.)*n**2)/(4.*a**2+n**2)/(4.*a**2+9.*n**2)
       D54=-n**2/pi*(1.-exp(-a*2.*pi/n))*(a**2+5.*n**2+4.)/(a**2+4*n**2)
       D62=-16./pi*n**3*a*(n**2+4.)*(1.+exp(-a*2.*pi/n))
     * /(4.*a**2+n**2)/(4.*a**2+9.*n**2)
       D64=-2.*n**3/pi*(n**2+4.)/(a**2+4.*n**2)*(1.-exp(-a*2.*pi/n))/a

       D71=n/pi*(-8.*a**4*n-100.*a**2*n**3-8*a**2*n+15./2*n**5+30.*n**3)
     */(4.*a**2+25.*n**2)/(4.*a**2+9.*n**2)*(1.+exp(-a*2.*pi/n))
       D73=n**2/pi*(1.-exp(-a*2.*pi/n))*
     *     (-14.*a**2*n**2-a**4-a**2+3.*n**4+3.*n**2)
     * /(a**2+n**2)/(a**2+9.*n**2)
       D81=-32.*a*n**3/pi*(4.*n**2+1.)
     */(4.*a**2+25.*n**2)/(4.*a**2+9.*n**2)*(1.+exp(-a*2.*pi/n))
       D83=-4.*a*n**3/pi*(1.-exp(-a*2.*pi/n))*(4.*n**2+1.)
     * /(a**2+n**2)/(a**2+9.*n**2)
       D92=n**2/(2.*pi)*(-16.*a**2*(a**2+4.)+15.*n**4
     *  -40.*n**2*(5.*a**2-6.))
     */(4.*a**2+25.*n**2)/(4.*a**2+9.*n**2)*(1.+exp(-a*2.*pi/n))
       D94=n/pi*(1.-exp(-a*2.*pi/n))*
     *     (-14.*a**2*n**3-n*a**4-4.*n*a**2+3.*n**5+12.*n**3)
     * /(a**2+n**2)/(a**2+9.*n**2)
       D102=-128.*a*n**3/pi*(n**2+1.)
     */(4.*a**2+25.*n**2)/(4.*a**2+9.*n**2)*(1.+exp(-a*2.*pi/n))
       D104=-16.*a*n**3/pi*(1.-exp(-a*2.*pi/n))*(n**2+1.)
     * /(a**2+n**2)/(a**2+9.*n**2)

       write(6,*) ' D12 ',D12
       write(6,*) ' D14 ',D14
       write(6,*) ' D21 ',D21
       write(6,*) ' D23 ',D23
       write(6,*) ' D33 ',D33
       write(6,*) ' D31 ',D31
       write(6,*) ' D41 ',D41
       write(6,*) ' D43 ',D43
       write(6,*) ' D52 ',D52
       write(6,*) ' D54 ',D54
       write(6,*) ' D62 ',D62
       write(6,*) ' D64 ',D64

       write(6,*) ' D71 ',D71
       write(6,*) ' D73 ',D73
       write(6,*) ' D81 ',D81
       write(6,*) ' D83 ',D83
       write(6,*) ' D92 ',D92
       write(6,*) ' D94 ',D94
       write(6,*) ' D102 ',D102
       write(6,*) ' D104 ',D104

c
c      COEFFICIENTS FOR THE ATMOSPHERIC COMPONENT OF THE MODEL (CHARNEY AND STRAUS, 1980)
c
       NN=n
       eps=3.D0/4.D0
       FF=1.D0/sig0
       epss=(1.D0-eps)*FF
       bett=L/rra*cos(pi/4.)/sin(pi/4.)
       kap=k+2.D0*kp+FF*hpp
       write(6,*) bett,hk,FF,kap
       bete=NN**2/(NN**2+1.D0)
       betpp=(NN**2+3.D0)/(NN**2+4.D0)
       delp=(NN**2-3.D0)/(NN**2+4.D0)
       del=bete
       bet1=bett*NN/(NN**2+1)
       bet2=bett*NN/(NN**2+4)
       alph=8.D0*dsqrt(2.D0)*NN/(3.D0*pi)
       alphp=8.D0*4.D0*dsqrt(2.D0)*NN/(15.D0*pi)
       alphpp=8.D0*8.D0*dsqrt(2.D0)*NN/(15.D0*pi)
       Fp=FF*(1.D0-bete)
       Fpp=FF*(1.D0-betpp)
       Fppp=FF/(4.*NN**2+1.)
       Fpppp=FF/(4.*NN**2+4.)
       kapp=k+2.D0*kp+Fp*hpp
       kappp=k+2.D0*kp+Fppp*hpp
       kapppp=k+2.D0*kp+Fpppp*hpp
c
       write(6,*) bett
       write(6,*) bete,betpp,bet1,bet2
       write(6,*) del,delp
       write(6,*) alph,alphp,alphpp
       write(6,*) Fp,Fpp,kapp
       write(6,*) Fppp,Fpppp
c
c       PARAMETERS FOR THE ADDITIONAL MODES FROM 7 TO 10 (REINHOLD AND PIERREHUMBERT, 1982)
c
       cc1=-alph
       c2=-alphp 
       c3=-2.*alph
       c4=-alphpp
       c5=-2*alphpp
       c6=3.*NN/2.
       rc2=3.*c6*(1-NN**2)/(NN**2+1.)
       rc5=c6/(NN**2+4.)
       rc771=c3/(4.*NN**2+1.)
       rc772=c5/(4.*NN**2+1.)
       rc773=c6/(4.*NN**2+1.)
       rc774=2.*Bett*NN/(4.*NN**2+1.)
       rc71=4.*c3*NN**2/(4.*NN**2+1.)
       rc72=4.*c5*NN**2/(4.*NN**2+1.)
       rc73=2.*NN*bett/(4.*NN**2+1.)
       rc74=c6/(4.*NN**2+1.)
       rc51=c6/(NN**2+1.)
       rc81=4.*c3*NN**2/(4.*NN**2+1.)
       rc82=4.*c5*NN**2/(4.*NN**2+1.)
       rc83=2*NN*Bett/(4.*NN**2+1.)
       rc91=c4*(4.*NN**2+3.)/(4.*NN**2+4.)
       rc92=c5*(4.*NN**2-3.)/(4.*NN**2+4.)
       rc93=2.*NN*Bett/(4.*NN**2+4.)
       rc991=c4/(4.*NN**2+4.)
       rc992=c5/(4.*NN**2+4.)

       write(6,*) c2,C3,C4,C5,C6
       write(6,*) rc2,rc5,rc771,rc772,rc773,rc774
       write(6,*) rc71,rc72,rc73,rc74
       write(6,*) rc51,rc81,rc82,rc83
       write(6,*) rc91,rc92,rc93,rc991,rc992



c     stop

C
C      LOOP FOR DIFFERENT PARAMETERS IF NEEDED
C
       do iji=1,nbparam
       klk=itr+1

c      INITIAL CONDITIONS OF THE MODEL.  

       psi(1)= 0.045418818148
       psi(2)=    -0.056414141468
       psi(3)=    -0.033556217706
       theta(1)=  0.045073531718  
       theta(2)=   0.012203220003 
       theta(3)= -0.029007279839   
       psi(4)=  -0.010475386677  
       psi(5)=  -0.001961130364  
       psi(6)=  -0.004100374565  
       theta(4)=   -0.006230292222 
       theta(5)=   -0.003884035324  
       theta(6)=  0.004032110435    
       psi(7)=   0.006562061273  
       psi(8)= -0.017092209945   
       psi(9)=   -0.001163999927 
       psi(10)=   -0.003791252665  
       theta(7)=   0.000753638020   
       theta(8)=  -0.005344494680 
       theta(9)=  -0.001070086401  
       theta(10)= -0.000859758608   
       AA(1)= -0.000301566549  
       AA(2)= -0.000026338027   
       AA(3)=  -0.000000566901  
       AA(4)=  -0.000230252082 

C
C     VALUE OF THE THERMAL FORCING
C

       thetastar=0.100D0
       thet=thetastar*hpp/(hpp+2*kp*sig0)
       write(6,*) ' forcing ', NN,thetastar,thet
c
c         INITIALISATION OF THE MEAN FIELDS
c
          rmpsi(7)=0.
          rmpsi(8)=0.
          rmpsi(9)=0.
          rmpsi(10)=0.
          rmtheta(7)=0.
          rmtheta(8)=0.
          rmtheta(9)=0.
          rmtheta(10)=0.
          rmpsi(1)=0.
          rmpsi(2)=0.
          rmpsi(3)=0.
          rmpsi(4)=0.
          rmpsi(5)=0.
          rmpsi(6)=0.
          rmtheta(1)=0.
          rmtheta(2)=0.
          rmtheta(3)=0.
          rmtheta(4)=0.
          rmtheta(5)=0.
          rmtheta(6)=0.
          nbmean=0
          rmaa1=0.
          rmaa2=0.
          rmaa3=0.
          rmaa4=0.
C
C        MAIN LOOP FOR THE TEMPORAL INTEGRATION
C
C        WRITING OF THE INITIAL FIELD
C
       write(6,*) psi(1)
       write(6,*) psi(2)
       write(6,*) psi(3)
       write(6,*) psi(4)
       write(6,*) psi(5)
       write(6,*) psi(6)
       write(6,*) psi(7)
       write(6,*) psi(8)
       write(6,*) psi(9)
       write(6,*) psi(10)
       write(6,*) theta(1)
       write(6,*) theta(2)
       write(6,*) theta(3)
       write(6,*) theta(4)
       write(6,*) theta(5)
       write(6,*) theta(6)
       write(6,*) theta(7)
       write(6,*) theta(8)
       write(6,*) theta(9)
       write(6,*) theta(10)
       write(6,*) aa(1)
       write(6,*) aa(2)
       write(6,*) aa(3)
       write(6,*) aa(4)

C
C      TIME LOOP
C


       do i=1,nt

c
c         LOWER LAYER FIELD OF THE ATMOSPHERE USED FOR FORCING THE OCEAN
c
          BB(1)=psi(1)-theta(1)
          BB(2)=psi(2)-theta(2)
          BB(3)=psi(3)-theta(3)
          BB(4)=psi(4)-theta(4)
          BB(5)=psi(5)-theta(5)
          BB(6)=psi(6)-theta(6)
          BB(7)=psi(7)-theta(7)
          BB(8)=psi(8)-theta(8)
          BB(9)=psi(9)-theta(9)
          BB(10)=psi(10)-theta(10)

C
C         TENDENCIES OF THE FIELDS
C
C         ATMOSPHERE TENDENCIES
C

C
C         ATMOSPHERE TENDENCIES
C
C         FOR PSI(1)
          f(1)=-k*(psi(1)-theta(1))
     *         -k*(D12*AA(2)+D14*AA(4))
C         FOR PSI(2)
          f(2)=-(alph*bete*psi(1)-bet1)*psi(3)
     *         -alph*bete*theta(3)*theta(1)
     *         -k*(psi(2)-theta(2))
     *         -k*(D23*AA(3)+D21*AA(1))/(nn**2+1.)
     *         -del*alphpp*(psi(6)*psi(4)+theta(6)*theta(4))
     *         +rc2*(psi(5)*psi(8)+theta(5)*theta(8)
     *         -psi(6)*psi(7)-theta(6)*theta(7))
C         FOR PSI(3)
          f(3)=(alph*bete*psi(1)-bet1)*psi(2)
     *         +alph*bete*theta(2)*theta(1)
     *         -k*(psi(3)-theta(3))
     *         +del*alphpp*(psi(5)*psi(4)+theta(5)*theta(4))
     *         -k*(D31*AA(1)+D33*AA(3))/(nn**2+1.)
     *         -rc2*(psi(5)*psi(7)+theta(5)*theta(7)
     *         +psi(6)*psi(8)+theta(6)*theta(8))
C         FOR THETA(1) 
          f(4)=-FF*alph*(theta(2)*psi(3)-psi(2)*theta(3))
     *         -FF*alphp*(theta(5)*psi(6)-psi(5)*theta(6))
     *         - kap*theta(1) +k*psi(1)
     *         + FF* hpp*thetastar
     *         +k*(D12*AA(2)+D14*AA(4))
     *          +FF*c3*(theta(7)*psi(8)-psi(7)*theta(8)) 
     *          +FF*c4*(theta(9)*psi(10)-psi(9)*theta(10)) 
C         FOR THETA(2) 
          f(5)=-(alph*(bete+Fp)*psi(1)-bet1)*theta(3)
     *         -alph*(bete-Fp)*theta(1)*psi(3)-kapp*theta(2)+k*psi(2)
     *         -del*alphpp*(theta(6)*psi(4)+psi(6)*theta(4))
     *         -FF*(1-bete)*alphpp*(theta(6)*psi(4)-psi(6)*theta(4))
     *         +k*(D23*AA(3)+D21*AA(1))/(nn**2+1.)
     *         +FF*rc51*((1+3./FF*(1-NN**2))*(theta(5)*psi(8)
     *         -theta(6)*psi(7))
     *         +(3./FF*(1.-NN**2)-1)*(theta(8)*psi(5)-theta(7)*psi(6)))
C         FOR THETA(3) 
          f(6)=(alph*(bete+Fp)*psi(1)-bet1)*theta(2)
     *         +alph*(bete-Fp)*theta(1)*psi(2) -kapp*theta(3)+k*psi(3)
     *         +del*alphpp*(theta(5)*psi(4)+psi(5)*theta(4))
     *         -FF*(1-bete)*alphpp*(theta(4)*psi(5)-psi(4)*theta(5))
     *         +k*(D31*AA(1)+D33*AA(3))/(nn**2+1.)
     *         -FF*rc51*((1+3./FF*(1-NN**2))*(theta(5)*psi(7)
     *         +theta(6)*psi(8))
     *         +(3./FF*(1.-NN**2)-1)*(theta(8)*psi(6)+theta(7)*psi(5)))
C         FOR PSI(4)
          f(7)=eps*alphpp*(psi(2)*psi(6)+theta(2)*theta(6))
     *         -eps*alphpp*(psi(5)*psi(3)+theta(5)*theta(3))
     *         -k*(psi(4)-theta(4))
     *         -k*(D41*AA(1)+D43*AA(3))/4.
     *         +0.75*c5*(psi(8)*psi(9)+theta(8)*theta(9))
     *         -0.75*c5*(psi(7)*psi(10)
     *         +theta(7)*theta(10))
C         FOR PSI(5)
          f(8)=-betpp*alphp*(psi(1)*psi(6)+theta(1)*theta(6))
     *         -delp*alphpp*(psi(4)*psi(3)+theta(4)*theta(3))
     *         +bet2*psi(6)
     *         -k*(psi(5)-theta(5))
     *         -k*(D52*AA(2)+D54*AA(4))/(nn**2+4.)
     *         +rc5*(3.*nn**2*(psi(2)*psi(8)+theta(2)*theta(8)
     *         -psi(3)*psi(7)-theta(3)*theta(7))) 
C         FOR PSI(6)
          f(9)=betpp*alphp*(psi(1)*psi(5)+theta(1)*theta(5))
     *         +delp*alphpp*(psi(4)*psi(2)+theta(4)*theta(2))
     *         -bet2*psi(5)
     *         -k*(psi(6)-theta(6))
     *         -k*(D62*AA(2)+D64*AA(4))/(nn**2+4.)
     *         -rc5*(3.*nn**2*(psi(3)*psi(8)+theta(3)*theta(8)
     *         +psi(2)*psi(7)+theta(2)*theta(7))) 
C         FOR THETA(4) 
          f(10)=eps*alphpp*(theta(2)*psi(6)+psi(2)*theta(6))
     *         -eps*alphpp*(theta(5)*psi(3)+psi(5)*theta(3))
     *         -epss*alphpp*(theta(2)*psi(6)-psi(2)*theta(6))
     *         -epss*alphpp*(theta(5)*psi(3)-psi(5)*theta(3))
     *         +k*psi(4)
     *         -(k+2*kp+hpp*epss)*theta(4)
     *         +k*(D41*AA(1)+D43*AA(3))/4.
     *         +FF*0.25*c5*((1.-3./FF)*(theta(7)*psi(10)
     *         -theta(8)*psi(9))
     *         -(1.+3./FF)*(psi(7)*theta(10)-psi(8)*theta(9)))
C         FOR THETA(5) 
          f(11)=-betpp*alphp*(theta(6)*psi(1)+psi(6)*theta(1))
     *         -delp*alphpp*(theta(3)*psi(4)+psi(3)*theta(4))
     *         -Fpp*alphp*(theta(6)*psi(1)-psi(6)*theta(1))
     *         -Fpp*alphpp*(theta(3)*psi(4)-psi(3)*theta(4))
     *         +k*psi(5)
     *         +bet2*theta(6)
     *         -(k+2*kp+hpp*Fpp)*theta(5)
     *         +k*(D52*AA(2)+D54*AA(4))/(nn**2+4.)
     *         +FF*rc5*((1.-3./FF*NN**2)*(theta(3)*psi(7)
     *         -theta(2)*psi(8))
     *         -(1.+3./FF*NN**2)*(psi(3)*theta(7)-psi(2)*theta(8)))
C         FOR THETA(6) 
          f(12)=betpp*alphp*(theta(5)*psi(1)+psi(5)*theta(1))
     *         +delp*alphpp*(theta(2)*psi(4)+psi(2)*theta(4))
     *         -Fpp*alphp*(theta(1)*psi(5)-psi(1)*theta(5))
     *         -Fpp*alphpp*(theta(4)*psi(2)-psi(4)*theta(2))
     *         +k*psi(6)
     *         -bet2*theta(5)
     *         -(k+2*kp+hpp*Fpp)*theta(6)
     *         +k*(D62*AA(2)+D64*AA(4))/(nn**2+4.)
     *         +FF*rc5*((1.-3./FF*NN**2)*(theta(2)*psi(7)
     *         +theta(3)*psi(8))
     *         -(1.+3./FF*NN**2)*(psi(2)*theta(7)+psi(3)*theta(8)))
C         FOR PSI(7) 
          f(13)=rc71*(psi(1)*psi(8)+theta(1)*theta(8))
     *          +rc72*(psi(4)*psi(10)+theta(4)*theta(10))
     *          +rc73*psi(8)
     *          -k*(psi(7)-theta(7))
     *          +rc74*(3.*(psi(2)*psi(6)+theta(2)*theta(6)
     *          +psi(3)*psi(5)+theta(3)*theta(5)))
     *          -k*(D71*AA(1)+D73*AA(3))/(4.*nn**2+1.)
C         FOR PSI(8) 
          f(14)=-rc81*(psi(1)*psi(7)+theta(1)*theta(7))
     *          -rc82*(psi(4)*psi(9)+theta(4)*theta(9))
     *          -rc83*psi(7)
     *          -k*(psi(8)-theta(8))
     *          +rc74*(3.*(psi(3)*psi(6)+theta(3)*theta(6)
     *          -psi(2)*psi(5)-theta(2)*theta(5)))
     *          -k*(D81*AA(1)+D83*AA(3))/(4.*nn**2+1.)
C         FOR PSI(9) 
          f(15)=rc91*(psi(1)*psi(10)+theta(1)*theta(10))
     *          +rc92*(psi(4)*psi(8)+theta(4)*theta(8))
     *          +rc93*psi(10)
     *          -k*(psi(9)-theta(9))
     *          -k*(D92*AA(2)+D94*AA(4))/(4.*nn**2+4.)
C         FOR PSI(10) 
          f(16)=-rc91*(psi(1)*psi(9)+theta(1)*theta(9))
     *          -rc92*(psi(4)*psi(7)+theta(4)*theta(7))
     *          -rc93*psi(9)
     *          -k*(psi(10)-theta(10))
     *          -k*(D102*AA(2)+D104*AA(4))/(4.*nn**2+4.)
C         FOR THETA(7) 
          f(17)=-FF*rc771*((1.-4./FF*NN**2)*theta(1)*psi(8)-
     *                     (1.+4./FF*NN**2)*theta(8)*psi(1))
     *          -FF*rc772*((1.-4./FF*NN**2)*theta(4)*psi(10)-
     *                     (1.+4./FF*NN**2)*theta(10)*psi(4)) 
     *          -FF*rc773*((1.-3./FF)*(theta(3)*psi(5)+theta(2)*psi(6))-
     *                     (1.+3./FF)*(theta(5)*psi(3)+psi(2)*theta(6))) 
     *          +rc774*theta(8)
     *          +k*psi(7)
     *          -kappp*theta(7)
     *         +k*(D71*AA(1)+D73*AA(3))/(4.*nn**2+1.)
C         FOR THETA(8) 
          f(18)=FF*rc771*((1.-4./FF*NN**2)*theta(1)*psi(7)-
     *                   (1.+4./FF*NN**2)*psi(1)*theta(7))
     *          +FF*rc772*((1.-4./FF*NN**2)*theta(4)*psi(9)
     *                    -(1.+4./FF*NN**2)*psi(4)*theta(9))
     *          +FF*rc773*((1.-3./FF)*(theta(2)*psi(5)-theta(3)*psi(6))
     *                    -(1.+3./FF)*(psi(2)*theta(5)-psi(3)*theta(6)))
     *          -rc774*theta(7)
     *          +k*psi(8)
     *          -kappp*theta(8)
     *         +k*(D81*AA(1)+D83*AA(3))/(4.*nn**2+1.)
C         FOR THETA(9) 
          f(19)=-FF*rc991*((1.-(4.*NN**2+3)/FF)*theta(1)*psi(10)-
     *                    (1.+(4.*NN**2+3)/FF)*theta(10)*psi(1))
     *          -FF*rc992*((1.-(4.*NN**2-3)/FF)*theta(4)*psi(8)-
     *                    (1.+(4.*NN**2-3)/FF)*theta(8)*psi(4))
     *          +rc93*theta(10)
     *          +k*psi(9)
     *          -kapppp*theta(9)
     *         +k*(D92*AA(2)+D94*AA(4))/(4.*nn**2+4.)
C         FOR THETA(10) 
          f(20)=FF*rc991*((1.-(4.*NN**2+3)/FF)*theta(1)*psi(9)-
     *                    (1.+(4.*NN**2+3)/FF)*theta(9)*psi(1))
     *          +FF*rc992*((1.-(4.*NN**2-3)/FF)*theta(4)*psi(7)-
     *                    (1.+(4.*NN**2-3)/FF)*theta(7)*psi(4))
     *          -rc93*theta(9)
     *          +k*psi(10)
     *          -kapppp*theta(10)
     *         +k*(D102*AA(2)+D104*AA(4))/(4.*nn**2+4.)

C
C         OCEAN TENDENCIES
C

C         FOR A(1)
          ff1=u14n*AA(1)*AA(4)+u12n*AA(1)*AA(2)+u23n*AA(3)*AA(2)
     *        +u34n*AA(3)*AA(4)+u1l*AA(1)+u3l*AA(3)
     *        +(u2c*BB(2)+u3c*BB(3)+u4c*BB(4))
     *        +(u7c*BB(7)+u8c*BB(8))
C         FOR A(2)
          ff2=v11n*AA(1)*AA(1)+v33n*AA(3)*AA(3)+v13n*AA(3)*AA(1)
     *        +v2l*AA(2)+v4l*AA(4)
     *        +(v1c*BB(1)+v5c*BB(5)+v6c*BB(6))
     *        +(v9c*BB(9)+v10c*BB(10))
C         FOR A(3)
          ff3=w14n*AA(1)*AA(4)+w12n*AA(1)*AA(2)+w23n*AA(3)*AA(2)
     *        +w34n*AA(3)*AA(4)+w1l*AA(1)+w3l*AA(3)
     *        +(w2c*BB(2)+w3c*BB(3)+w4c*BB(4))
     *        +(w7c*BB(7)+w8c*BB(8))
C         FOR A(4)
          ff4=x11n*AA(1)*AA(1)+x33n*AA(3)*AA(3)+x13n*AA(3)*AA(1)
     *        +x2l*AA(2)+x4l*AA(4)
     *        +(x1c*BB(1)+x5c*BB(5)+x6c*BB(6))
     *        +(x9c*BB(9)+x10c*BB(10))

c
c         EULER STEP OF THE INTEGRATION SCHEME
c

          AAA(1)=AA(1)+ff1*dt
          AAA(2)=AA(2)+ff2*dt
          AAA(3)=AA(3)+ff3*dt
          AAA(4)=AA(4)+ff4*dt

	  psi1(1)=psi(1)+tdel*f(1)
	  psi1(2)=psi(2)+tdel*f(2)
	  psi1(3)=psi(3)+tdel*f(3)
	  theta1(1)=theta(1)+tdel*(f(4)/(1.D0+FF))
	  theta1(2)=theta(2)+tdel*(f(5)/(1.D0+Fp))
	  theta1(3)=theta(3)+tdel*(f(6)/(1.D0+Fp))
	  psi1(4)=psi(4)+tdel*f(7)
	  psi1(5)=psi(5)+tdel*f(8)
	  psi1(6)=psi(6)+tdel*f(9)
	  theta1(4)=theta(4)+tdel*(f(10)/(1.D0+epss))
	  theta1(5)=theta(5)+tdel*(f(11)/(1.D0+Fpp))
	  theta1(6)=theta(6)+tdel*(f(12)/(1.D0+Fpp))
          psi1(7)=psi(7)+tdel*f(13)
          psi1(8)=psi(8)+tdel*f(14)
          psi1(9)=psi(9)+tdel*f(15)
          psi1(10)=psi(10)+tdel*f(16)
	  theta1(7)=theta(7)+tdel*(f(17)/(1.D0+Fppp))
	  theta1(8)=theta(8)+tdel*(f(18)/(1.D0+Fppp))
	  theta1(9)=theta(9)+tdel*(f(19)/(1.D0+Fpppp))
	  theta1(10)=theta(10)+tdel*(f(20)/(1.D0+Fpppp))

C
C         SECOND ESTIMATION OF THE TENDENCIES
C

          fff(1)=-k*(psi1(1)-theta1(1))
     *         -k*(D12*AAA(2)+D14*AAA(4))
          fff(2)=-(alph*bete*psi1(1)-bet1)*psi1(3)
     *         -alph*bete*theta1(3)*theta1(1)
     *         -k*(psi1(2)-theta1(2))
     *         -del*alphpp*(psi1(6)*psi1(4)+theta1(6)*theta1(4))
     *         -k*(D21*AAA(1)+D23*AAA(3))/(nn**2+1.)
     *         +rc2*(psi1(5)*psi1(8)+theta1(5)*theta1(8)
     *         -psi1(6)*psi1(7)-theta1(6)*theta1(7))
          fff(3)=(alph*bete*psi1(1)-bet1)*psi1(2)
     *         +alph*bete*theta1(2)*theta1(1)
     *         -k*(psi1(3)-theta1(3))
     *         +del*alphpp*(psi1(5)*psi1(4)+theta1(5)*theta1(4))
     *         -k*(D31*AAA(1)+D33*AAA(3))/(nn**2+1.)
     *         -rc2*(psi1(5)*psi1(7)+theta1(5)*theta1(7)
     *         +psi1(6)*psi1(8)+theta1(6)*theta1(8))
          fff(4)=-FF*alph*(theta1(2)*psi1(3)-psi1(2)*theta1(3))
     *         -FF*alphp*(theta1(5)*psi1(6)-psi1(5)*theta1(6))
     *         - kap*theta1(1) +k*psi1(1)
     *         + FF* hpp*thetastar
     *         +k*(D12*AAA(2)+D14*AAA(4))
     *          +FF*c3*(theta1(7)*psi1(8)-psi1(7)*theta1(8)) 
     *          +FF*c4*(theta1(9)*psi1(10)-psi1(9)*theta1(10)) 
          fff(5)=-(alph*(bete+Fp)*psi1(1)-bet1)*theta1(3)
     *         -alph*(bete-Fp)*theta1(1)*psi1(3)-kapp*theta1(2)
     *         +k*psi1(2)
     *         -del*alphpp*(theta1(6)*psi1(4)+psi1(6)*theta1(4))
     *         -FF*(1-bete)*alphpp*(theta1(6)*psi1(4)-psi1(6)*theta1(4))
     *         +k*(D21*AAA(1)+D23*AAA(3))/(nn**2+1.)
     *         +FF*rc51*((1+3./FF*(1-NN**2))*(theta1(5)*psi1(8)
     *         -theta1(6)*psi1(7))
     *         +(3./FF*(1.-NN**2)-1)*(theta1(8)*psi1(5)
     *         -theta1(7)*psi1(6)))
          fff(6)=(alph*(bete+Fp)*psi1(1)-bet1)*theta1(2)
     *         +alph*(bete-Fp)*theta1(1)*psi1(2)-kapp*theta1(3)
     *         +k*psi1(3)
     *         +del*alphpp*(theta1(5)*psi1(4)+psi1(5)*theta1(4))
     *         -FF*(1-bete)*alphpp*(theta1(4)*psi1(5)-psi1(4)*theta1(5))
     *         +k*(D31*AAA(1)+D33*AAA(3))/(nn**2+1.)
     *         -FF*rc51*((1+3./FF*(1-NN**2))*(theta1(5)*psi1(7)
     *         +theta1(6)*psi1(8))
     *         +(3./FF*(1.-NN**2)-1)*(theta1(8)*psi1(6)
     *         +theta1(7)*psi1(5)))
          fff(7)=eps*alphpp*(psi1(2)*psi1(6)+theta1(2)*theta1(6))
     *         -eps*alphpp*(psi1(5)*psi1(3)+theta1(5)*theta1(3))
     *         -k*(psi1(4)-theta1(4))
     *         -k*(D41*AAA(1)+D43*AAA(3))/4.
     *         +0.75*c5*(psi1(8)*psi1(9)+theta1(8)*theta1(9))
     *         -0.75*c5*(psi1(7)*psi1(10)+theta1(7)*theta1(10))
          fff(8)=-betpp*alphp*(psi1(1)*psi1(6)+theta1(1)*theta1(6))
     *         -delp*alphpp*(psi1(4)*psi1(3)+theta1(4)*theta1(3))
     *         +bet2*psi1(6)
     *         -k*(psi1(5)-theta1(5))
     *         -k*(D52*AAA(2)+D54*AAA(4))/(nn**2+4.)
     *         +rc5*(3.*nn**2*(psi1(2)*psi1(8)+theta1(2)*theta1(8)
     *         -psi1(3)*psi1(7)-theta1(3)*theta1(7))) 
          fff(9)=betpp*alphp*(psi1(1)*psi1(5)+theta1(1)*theta1(5))
     *         +delp*alphpp*(psi1(4)*psi1(2)+theta1(4)*theta1(2))
     *         -bet2*psi1(5)
     *         -k*(psi1(6)-theta1(6))
     *         -k*(D62*AAA(2)+D64*AAA(4))/(nn**2+4.)
     *         -rc5*(3.*nn**2*(psi1(3)*psi1(8)+theta1(3)*theta1(8)
     *         +psi1(2)*psi1(7)+theta1(2)*theta1(7))) 
          fff(10)=eps*alphpp*(theta1(2)*psi1(6)+psi1(2)*theta1(6))
     *         -eps*alphpp*(theta1(5)*psi1(3)+psi1(5)*theta1(3))
     *         -epss*alphpp*(theta1(2)*psi1(6)-psi1(2)*theta1(6))
     *         -epss*alphpp*(theta1(5)*psi1(3)-psi1(5)*theta1(3))
     *         +k*psi1(4)
     *         -(k+2*kp+hpp*epss)*theta1(4)
     *         +k*(D41*AAA(1)+D43*AAA(3))/4.
     *         +FF*0.25*c5*((1.-3./FF)*(theta1(7)*psi1(10)
     *         -theta1(8)*psi1(9))
     *         -(1.+3./FF)*(psi1(7)*theta1(10)-psi1(8)*theta1(9)))
          fff(11)=-betpp*alphp*(theta1(6)*psi1(1)+psi1(6)*theta1(1))
     *         -delp*alphpp*(theta1(3)*psi1(4)+psi1(3)*theta1(4))
     *         -Fpp*alphp*(theta1(6)*psi1(1)-psi1(6)*theta1(1))
     *         -Fpp*alphpp*(theta1(3)*psi1(4)-psi1(3)*theta1(4))
     *         +k*psi1(5)
     *         +bet2*theta1(6)
     *         -(k+2*kp+hpp*Fpp)*theta1(5)
     *         +k*(D52*AAA(2)+D54*AAA(4))/(nn**2+4.)
     *         +FF*rc5*((1.-3./FF*NN**2)*(theta1(3)*psi1(7)
     *         -theta1(2)*psi1(8))
     *         -(1.+3./FF*NN**2)*(psi1(3)*theta1(7)-psi1(2)*theta1(8)))
          fff(12)=betpp*alphp*(theta1(5)*psi1(1)+psi1(5)*theta1(1))
     *         +delp*alphpp*(theta1(2)*psi1(4)+psi1(2)*theta1(4))
     *         -Fpp*alphp*(theta1(1)*psi1(5)-psi1(1)*theta1(5))
     *         -Fpp*alphpp*(theta1(4)*psi1(2)-psi1(4)*theta1(2))
     *         +k*psi1(6)
     *         -bet2*theta1(5)
     *         -(k+2*kp+hpp*Fpp)*theta1(6)
     *         +k*(D62*AAA(2)+D64*AAA(4))/(nn**2+4.)
     *         +FF*rc5*((1.-3./FF*NN**2)*(theta1(2)*psi1(7)
     *         +theta1(3)*psi1(8))
     *         -(1.+3./FF*NN**2)*(psi1(2)*theta1(7)+psi1(3)*theta1(8)))
          fff(13)=rc71*(psi1(1)*psi1(8)+theta1(1)*theta1(8))
     *          +rc72*(psi1(4)*psi1(10)+theta1(4)*theta1(10))
     *          +rc73*psi1(8)
     *          -k*(psi1(7)-theta1(7))
     *          +rc74*(3.*(psi1(2)*psi1(6)+theta1(2)*theta1(6)
     *          +psi1(3)*psi1(5)+theta1(3)*theta1(5)))
     *          -k*(D71*AAA(1)+D73*AAA(3))/(4.*nn**2+1.)
          fff(14)=-rc81*(psi1(1)*psi1(7)+theta1(1)*theta1(7))
     *          -rc82*(psi1(4)*psi1(9)+theta1(4)*theta1(9))
     *          -rc83*psi1(7)
     *          -k*(psi1(8)-theta1(8))
     *          +rc74*(3.*(psi1(3)*psi1(6)+theta1(3)*theta1(6)
     *          -psi1(2)*psi1(5)-theta1(2)*theta1(5)))
     *          -k*(D81*AAA(1)+D83*AAA(3))/(4.*nn**2+1.)
          fff(15)=rc91*(psi1(1)*psi1(10)+theta1(1)*theta1(10))
     *          +rc92*(psi1(4)*psi1(8)+theta1(4)*theta1(8))
     *          +rc93*psi1(10)
     *          -k*(psi1(9)-theta1(9))
     *          -k*(D92*AAA(2)+D94*AAA(4))/(4.*nn**2+4.)
          fff(16)=-rc91*(psi1(1)*psi1(9)+theta1(1)*theta1(9))
     *          -rc92*(psi1(4)*psi1(7)+theta1(4)*theta1(7))
     *          -rc93*psi1(9)
     *          -k*(psi1(10)-theta1(10))
     *          -k*(D102*AAA(2)+D104*AAA(4))/(4.*nn**2+4.)
          fff(17)=-FF*rc771*((1.-4./FF*NN**2)*theta1(1)*psi1(8)-
     *                     (1.+4./FF*NN**2)*theta1(8)*psi1(1))
     *          -FF*rc772*((1.-4./FF*NN**2)*theta1(4)*psi1(10)-
     *                     (1.+4./FF*NN**2)*theta1(10)*psi1(4)) 
     *          -FF*rc773*((1.-3./FF)*(theta1(3)*psi1(5)
     *          +theta1(2)*psi1(6))
     *          -(1.+3./FF)*(theta1(5)*psi1(3)+psi1(2)*theta1(6))) 
     *          +rc774*theta1(8)
     *          +k*psi1(7)
     *          -kappp*theta1(7)
     *         +k*(D71*AAA(1)+D73*AAA(3))/(4.*nn**2+1.)
          fff(18)=FF*rc771*((1.-4./FF*NN**2)*theta1(1)*psi1(7)
     *           -(1.+4./FF*NN**2)*psi1(1)*theta1(7))
     *           +FF*rc772*((1.-4./FF*NN**2)*theta1(4)*psi1(9)
     *           -(1.+4./FF*NN**2)*psi1(4)*theta1(9))
     *           +FF*rc773*((1.-3./FF)*(theta1(2)*psi1(5)
     *           -theta1(3)*psi1(6))
     *           -(1.+3./FF)*(psi1(2)*theta1(5)-psi1(3)*theta1(6)))
     *           -rc774*theta1(7)
     *           +k*psi1(8)
     *           -kappp*theta1(8)
     *           +k*(D81*AAA(1)+D83*AAA(3))/(4.*nn**2+1.)
          fff(19)=-FF*rc991*((1.-(4.*NN**2+3)/FF)*theta1(1)*psi1(10)-
     *                    (1.+(4.*NN**2+3)/FF)*theta1(10)*psi1(1))
     *          -FF*rc992*((1.-(4.*NN**2-3)/FF)*theta1(4)*psi1(8)-
     *                    (1.+(4.*NN**2-3)/FF)*theta1(8)*psi1(4))
     *          +rc93*theta1(10)
     *          +k*psi1(9)
     *          -kapppp*theta1(9)
     *         +k*(D92*AAA(2)+D94*AAA(4))/(4.*nn**2+4.)
          fff(20)=FF*rc991*((1.-(4.*NN**2+3)/FF)*theta1(1)*psi1(9)-
     *                    (1.+(4.*NN**2+3)/FF)*theta1(9)*psi1(1))
     *          +FF*rc992*((1.-(4.*NN**2-3)/FF)*theta1(4)*psi1(7)-
     *                    (1.+(4.*NN**2-3)/FF)*theta1(7)*psi1(4))
     *          -rc93*theta1(9)
     *          +k*psi1(10)
     *          -kapppp*theta1(10)
     *         +k*(D102*AAA(2)+D104*AAA(4))/(4.*nn**2+4.)
          ff11=u14n*AAA(1)*AAA(4)+u12n*AAA(1)*AAA(2)+u23n*AAA(3)*AAA(2)
     *        +u34n*AAA(3)*AAA(4)+u1l*AAA(1)+u3l*AAA(3)
     *        +(u2c*BB(2)+u3c*BB(3)+u4c*BB(4))
     *        +(u7c*BB(7)+u8c*BB(8))
          ff21=v11n*AAA(1)*AAA(1)+v33n*AAA(3)*AAA(3)+v13n*AAA(3)*AAA(1)
     *        +v2l*AAA(2)+v4l*AAA(4)
     *        +(v1c*BB(1)+v5c*BB(5)+v6c*BB(6))
     *        +(v9c*BB(9)+v10c*BB(10))
          ff31=w14n*AAA(1)*AAA(4)+w12n*AAA(1)*AAA(2)+w23n*AAA(3)*AAA(2)
     *        +w34n*AAA(3)*AAA(4)+w1l*AAA(1)+w3l*AAA(3)
     *        +(w2c*BB(2)+w3c*BB(3)+w4c*BB(4))
     *        +(w7c*BB(7)+w8c*BB(8))
          ff41=x11n*AAA(1)*AAA(1)+x33n*AAA(3)*AAA(3)+x13n*AAA(3)*AAA(1)
     *        +x2l*AAA(2)+x4l*AAA(4)
     *        +(x1c*BB(1)+x5c*BB(5)+x6c*BB(6))
     *        +(x9c*BB(9)+x10c*BB(10))
c
c               FINAL SOLUTION WITH AVERAGED TENDENCIES, HEUN METHOD
c

	  psi(1)=psi(1)+0.5*tdel*(f(1)+fff(1))
	  psi(2)=psi(2)+0.5*tdel*(f(2)+fff(2))
	  psi(3)=psi(3)+0.5*tdel*(f(3)+fff(3))
	  theta(1)=theta(1)+0.5*tdel*(f(4)/(1.+FF)+fff(4)/(1.+FF))
	  theta(2)=theta(2)+0.5*tdel*(f(5)/(1.+Fp)+fff(5)/(1.+Fp))
	  theta(3)=theta(3)+0.5*tdel*(f(6)/(1.+Fp)+fff(6)/(1.+Fp))
	  psi(4)=psi(4)+0.5*tdel*(f(7)+fff(7))
	  psi(5)=psi(5)+0.5*tdel*(f(8)+fff(8))
	  psi(6)=psi(6)+0.5*tdel*(f(9)+fff(9))
          theta(4)=theta(4)+0.5*tdel*(f(10)/(1.+epss)+fff(10)/(1.+epss))
	  theta(5)=theta(5)+0.5*tdel*(f(11)/(1.+Fpp)+fff(11)/(1.+Fpp))
	  theta(6)=theta(6)+0.5*tdel*(f(12)/(1.+Fpp)+fff(12)/(1.+Fpp))
	  psi(7)=psi(7)+0.5*tdel*(f(13)+fff(13))
	  psi(8)=psi(8)+0.5*tdel*(f(14)+fff(14))
	  psi(9)=psi(9)+0.5*tdel*(f(15)+fff(15))
	  psi(10)=psi(10)+0.5*tdel*(f(16)+fff(16))
	  theta(7)=theta(7)+0.5*tdel*(f(17)/(1.+Fppp)+fff(17)/(1.+Fppp))
	  theta(8)=theta(8)+0.5*tdel*(f(18)/(1.+Fppp)+fff(18)/(1.+Fppp))
	  theta(9)=theta(9)+0.5*tdel*(f(19)/(1.+Fpppp)
     *             +fff(19)/(1.+Fpppp))
	  theta(10)=theta(10)+0.5*tdel*(f(20)/(1.+Fpppp)
     *             +fff(20)/(1.+Fpppp))

             AA(1)=AA(1)+0.5*(ff1+ff11)*dt
             AA(2)=AA(2)+0.5*(ff2+ff21)*dt
             AA(3)=AA(3)+0.5*(ff3+ff31)*dt
             AA(4)=AA(4)+0.5*(ff4+ff41)*dt
C
C         WRITING THE EVOLUTION AFTER THE TRANSIENT ITR
C

          if (i.gt.itr) then
c          if (klk.eq.i) then
c          klk=klk+500
c          write(6,1003) klk*timeunit*tdel
c    *     ,psi(1),psi(2),psi(3),theta(1),theta(3),theta(2)
c    *     ,psi(4),psi(5),psi(6),theta(4),theta(5),theta(6)
c    *     ,psi(7),psi(8),psi(9),psi(10),theta(7),theta(8)
c    *     ,theta(9),theta(10)
c    *     ,aa(1),aa(2),aa(3),aa(4)
c          endif
 1003      format(f15.5,60f18.12)
 1004      format(i6,22f15.9)


c         COMPUTATION OF THE AVERAGED FIELDS    

          rmpsi(1)=rmpsi(1)+psi(1)
          rmpsi(2)=rmpsi(2)+psi(2)
          rmpsi(3)=rmpsi(3)+psi(3)
          rmpsi(4)=rmpsi(4)+psi(4)
          rmpsi(5)=rmpsi(5)+psi(5)
          rmpsi(6)=rmpsi(6)+psi(6)
          rmtheta(1)=rmtheta(1)+theta(1)
          rmtheta(2)=rmtheta(2)+theta(2)
          rmtheta(3)=rmtheta(3)+theta(3)
          rmtheta(4)=rmtheta(4)+theta(4)
          rmtheta(5)=rmtheta(5)+theta(5)
          rmtheta(6)=rmtheta(6)+theta(6)
          rmaa1=rmaa1+aa(1)
          rmaa2=rmaa2+aa(2)
          rmaa3=rmaa3+aa(3)
          rmaa4=rmaa4+aa(4)
          rmpsi(7)=rmpsi(7)+psi(7)
          rmpsi(8)=rmpsi(8)+psi(8)
          rmpsi(9)=rmpsi(9)+psi(9)
          rmpsi(10)=rmpsi(10)+psi(10)
          rmtheta(7)=rmtheta(7)+theta(7)
          rmtheta(8)=rmtheta(8)+theta(8)
          rmtheta(9)=rmtheta(9)+theta(9)
          rmtheta(10)=rmtheta(10)+theta(10)

          nbmean=nbmean+1
           if (klk.eq.i) then
           klk=klk+5000000
           write(6,1003) klk*timeunit*tdel
     *     ,rmpsi(1)/nbmean,rmpsi(2)/nbmean,rmpsi(3)/nbmean,
     *     rmtheta(1)/nbmean,rmtheta(3)/nbmean,rmtheta(2)/nbmean
     *     ,rmpsi(4)/nbmean,rmpsi(5)/nbmean,rmpsi(6)/nbmean
     *     ,rmtheta(4)/nbmean,rmtheta(5)/nbmean,rmtheta(6)/nbmean
     *     ,rmpsi(7)/nbmean,rmpsi(8)/nbmean,rmpsi(9)/nbmean
     *     ,rmpsi(10)/nbmean,rmtheta(7)/nbmean,rmtheta(8)/nbmean
     *     ,rmtheta(9)/nbmean,rmtheta(10)/nbmean
     *     ,rmaa1/nbmean,rmaa2/nbmean,rmaa3/nbmean,rmaa4/nbmean
           endif
      endif
      enddo

C
C     AVERAGED FIELDS
C
      rpr=f0*(L)**2
      write(6,*) 'dimensional mean field '
      write(6,*) nbmean,rpr
      write(6,*) 'ocean 1 ',rpr*rmaa1/nbmean
      write(6,*) 'ocean 2 ',rpr*rmaa2/nbmean
      write(6,*) 'ocean 3 ',rpr*rmaa3/nbmean
      write(6,*) 'ocean 4 ',rpr*rmaa4/nbmean
      write(6,*) 'psi 1 ',rpr*rmpsi(1)/nbmean
      write(6,*) 'psi 2 ',rpr*rmpsi(2)/nbmean
      write(6,*) 'psi 3 ',rpr*rmpsi(3)/nbmean
      write(6,*) 'psi 4 ',rpr*rmpsi(4)/nbmean
      write(6,*) 'psi 5 ',rpr*rmpsi(5)/nbmean
      write(6,*) 'psi 6 ',rpr*rmpsi(6)/nbmean
      write(6,*) 'theta 1 ',rpr*rmtheta(1)/nbmean
      write(6,*) 'theta 2 ',rpr*rmtheta(2)/nbmean
      write(6,*) 'theta 3 ',rpr*rmtheta(3)/nbmean
      write(6,*) 'theta 4 ',rpr*rmtheta(4)/nbmean
      write(6,*) 'theta 5 ',rpr*rmtheta(5)/nbmean
      write(6,*) 'theta 6 ',rpr*rmtheta(6)/nbmean
      write(6,*) 'psi 7 ',rpr*rmpsi(7)/nbmean
      write(6,*) 'psi 8 ',rpr*rmpsi(8)/nbmean
      write(6,*) 'psi 9 ',rpr*rmpsi(9)/nbmean
      write(6,*) 'psi 10 ',rpr*rmpsi(10)/nbmean
      write(6,*) 'theta 7 ',rpr*rmtheta(7)/nbmean
      write(6,*) 'theta 8 ',rpr*rmtheta(8)/nbmean
      write(6,*) 'theta 9 ',rpr*rmtheta(9)/nbmean
      write(6,*) 'theta 10 ',rpr*rmtheta(10)/nbmean
  
      enddo
1023   format(i10,24f24.16)
      close(3)
      close(7)
       stop
       end
