%Yubin 2013.10
%ZL: stability parameter
%Rib: bulk Richardson number
%zz: observation height
%z0m: aerodynamic roughness length 
%z0h: thermal roughness length

function ZL= NEW2013_main(Rib,zz,z0m,z0h) 

x11 = log(log(zz/z0m));
x12 = x11.^2;
x21 = log(z0m/z0h);
x22 = x21.^2;

s21 = log(zz/z0m);
s22 = s21^2;
s23 = s21^3;
s31 = log(z0m/z0h);
s32 = s31^2;
s33 = s31^3;

s11 = Rib;
s12 = s11^2;
s13 = s11^3;

XX1 = [1, x11, x12, x21, x11.*x21, x12.*x21, x22, x11.*x22];
SS1 = [1, s11, s12, s13, s31, s11.*s31, s12.*s31, s13.*s31, ...
    s32, s11.*s32, s12.*s32,s33, s11.*s33, s21, s11.*s21, ...
    s12.*s21, s13.*s21, s21.*s31, s11.*s21.*s31,          ...
    s12.*s21.*s31, s21.*s32, s11.*s21.*s32, s21.*s33,     ...
    s22, s11.*s22, s12.*s22, s22.*s31, s11.*s22.*s31,     ...
    s22.*s32, s23, s11.*s23, s23.*s31];
if zz/z0m<160 && zz/z0m>=10 && z0m/z0h>=0.607 && z0m/z0h<100  %%region 1**************************
    
    coef_ribc = [0.3095	-0.2852	0.07955	0.03388	-0.01605	0	0	-0.0001079;
        0.3219	-0.2613	0.06753	0.04838	-0.03101	0.003908	-0.00178	0.001165;
        0.3545	-0.2569	0.06609	0.05837	-0.03934	0.005643	-0.003381	0.002194;
        0.439	-0.3133	0.08619	0.0893	-0.07112	0.01403	-0.005965	0.003806;
        0.6887	-0.5375	0.1616	0.1754	-0.1564	0.03489	-0.01277	0.008101;
        1.706	-1.62	0.5231	0.5124	-0.5026	0.1239	-0.03577	0.02238];
    Ribc=nan(1,6);
    for i=1:6
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end
    coef_ZL =  [-1.134	31.1	-71.16	227.4	-0.2094	3.293	-20.11	14.42	0.1476	-0.07325	0.5627	-0.01178	0.0218	1.405	-32.47	46.59	-38.25	-0.2286	-1.097	-0.3394	0	0	0	0	10.71	0	0	0	0	-0.007485	-0.9671	0.003402;
        0	86.35	0	0	-11.53	194.9	-975.4	1472	-2.535	28.24	-61.13	-0.2378	0.7405	13.6	-316.2	1067	-1494	8.023	-91.31	213.7	1.035	-5.072	0.03622	-4.699	97.46	-152.4	-1.704	9.069	-0.09576	0.4446	-7.991	0.1138;
        0	-280.4	3235	-6165	-10.64	193.8	-1194	2161	-4.603	52.02	-110.7	-0.5367	1.503	30.26	-314.9	186	0	9.038	-87.06	198.6	1.529	-7.439	0.07369	-10.71	122.1	-76.91	-2.035	8.248	-0.1263	1.015	-10.96	0.1426;
        0	0	0	0	0	0	-12.37	0	0	11.99	-15.63	-0.3157	0.2948	0	0	-108.1	317.8	0	-12.52	0	0	-1.025	0.04669	-1.896	28.39	-14.19	0	2.214	-0.01472	0.3069	-3.635	-0.008769;
        0	0	0	0	0	1.113	-97.56	159.4	0	16.33	-25.67	-0.6447	0.9718	6.821	-57.13	227.3	-244	0.9287	-17.88	34.41	0.319	-2.452	0.08583	-2.195	22.21	-31.44	-0.1355	1.976	-0.04636	0.1708	-1.623	0;
        0	-17.32	8.773	0	0	0	0	0	1.919	0	0.2679	-0.2892	0	10.27	0	0	0	-3.457	-1.617	0	-0.07536	0	0.05146	-3.108	7.948	-2.985	0.8751	0.3139	-0.05131	0.2598	-0.8513	-0.05427;
        0	-6.343	7.66	-0.7661	0.0125	-2.203	0.8896	-0.1273	-0.008274	0.3327	-0.04613	0	-0.04968	7.513	0	-4.799	0.5598	-1.612	0	0	0.4666	0.0605	-0.01808	0	2.442	0.1584	0	-0.04377	-0.0694	-0.1675	-0.2181	0.05052];
    if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib<=Ribc(4)
        ZL = sum(coef_ZL(4,:).*SS1);
    elseif Rib<=Ribc(5)
        ZL = sum(coef_ZL(5,:).*SS1);
    elseif Rib<=Ribc(6)
        ZL = sum(coef_ZL(6,:).*SS1);
    elseif Rib>Ribc(6)
        ZL = sum(coef_ZL(7,:).*SS1);
    end
elseif zz/z0m<=10^5 && zz/z0m>=160 && z0m/z0h>=0.607 && z0m/z0h<100 %region 2**************************
    coef_ribc = [0	0.08606	-0.03048	0.09019	-0.07682	0.01693	0	0;
        0.2002	0	-0.01589	0	0.00367	0	0.005057	-0.002399;
        0.4499	0	-0.02397	0.0388	-0.01145	0	0	0];
    Ribc=nan(1,3);
    for i=1:3
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end
    coef_ZL =  [0	0	0	0	0	0	0	0	0	0	0	0	0	0.9996	0	56.57	0	-0.1456	0	-12.1	0	0.1303	0	0	0.295	0	0.005508	-0.0359	0.0004067	0	0	0;
        0	0	0	0	0	-12.35	0	0	0	0.5183	0	0	0	0.8247	0	112.5	0	-0.09054	0	-2.249	0.01653	0	0	0	0.8326	-9.554	0	0.07022	-0.001333	0	0	0;
        0	41.53	0	0	-1.616	0	0	0	0	0	0	0	0	0	15.82	-27.37	0	0	0	0	0	0.02288	0	0.1062	-0.9992	1.56	0	0	0	0	0	0;
        0	0	0	0	-2.57	-2.91	0	0	0.874	0.3377	0	-0.002092	-0.01343	7.453	5.4	-1.623	0.1999	0	0.4753	0	-0.2047	-0.02581	0	-0.9043	-0.3386	0.04556	0.04682	-0.01924	0.01217	0.03944	0.006516	-0.003571];
    if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib>Ribc(3)
        ZL = sum(coef_ZL(4,:).*SS1);
    end
    
elseif zz/z0m<80 && zz/z0m>=10 && z0m/z0h>=100 && z0m/z0h<10^7 %region 3**************************
    coef_ribc = [0.3063	-0.2849	0.07886	0.03104	-0.01423	-0.0005632	0.000003684	-0.000002926;
        0.3555	-0.3002	0.07855	0.02617	-0.004769	-0.004012	-0.00001298	0.000009907;
        0.5064	-0.4282	0.1229	0.02138	0	-0.00441	0	0;
        1.638	-1.743	0.5813	0.04471	-0.01874	0	0	0];
    Ribc=nan(1,4);
    for i=1:4
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end
    coef_ZL =  [2.001	-0.7876	0	60.42	-0.1401	-0.1085	-2.065	-2.98	0.01334	0.0213	0.1963	-0.0003704	-0.002957	-1.442	1.047	0	0	0	0	-1.121	0	0.0273	0	0.6868	0	3.82	-0.01898	-0.1228	0.0002845	-0.06543	0.1469	0.00179;
        0	0	0	368.9	3.514	-8.524	-18.05	-4.852	0.08174	0.5791	0.1207	-0.007021	0	1.207	-31.68	32.78	-25.65	-2.096	2.222	0.3871	-0.004486	-0.06669	0.001086	-0.07632	14.32	2.353	0.3396	-0.3281	-0.00036	0	-1.505	-0.01529;
        -68.85	756.9	-1100	0	0	-30.13	86.99	5.71	0.7274	-2.554	-0.2169	0.01587	0.003912	76.25	-874.1	1636	-1040	4.942	-17.32	14.97	-0.09096	0.2281	-0.002971	-21.66	232.4	-224.1	-1.724	3.144	-0.0004477	1.875	-18.02	0.1523;
        -1.514	0	0	19.63	0.559	0	0	-2.424	-0.002248	0	0.1259	0.0008267	-0.004141	-8.751	51.96	-76.51	27.69	-1.349	1.297	-0.09621	0	0	0.0002192	3.734	-6.438	6.284	0.2422	-0.2272	0	-0.4111	0.2556	-0.009961;
        0	0	0	0	0	0	0	0	0	0	0	0.0002413	0.00007107	0	1.905	-1.761	0.3658	-0.05227	0	0	0	0	0	2.165	0.6139	-0.1166	-0.07307	0.005656	0	-0.3134	0	0.008105];
    if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib<=Ribc(4)
        ZL = sum(coef_ZL(4,:).*SS1);
    elseif Rib>Ribc(4)
        ZL = sum(coef_ZL(5,:).*SS1);
    end
elseif zz/z0m<=10^5 && zz/z0m>=80 && z0m/z0h>=100 && z0m/z0h<10^7 %region 4**************************
    coef_ribc = [0.09742,0,-0.01096,0.04544,-0.03299,0.006383,0,0; 
        0.1768	0	-0.01434	0.03558	-0.02059	0.003327	0	0;
        0.3636	0	-0.0224	0.04607	-0.02506	0.004152	0	0];
    Ribc=nan(1,3);
    for i=1:3
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end   
coef_ZL =  [0  0  0  0  0  0  -6.267  0  0  0.09808  0  0  0  0.5961  0  18.49  34.53  -0.08450  -0.5106  -0.3543  0.004555  0  -9.402e-05  0.05628  0.8075  0  0  0.01631  -3.800e-05  -0.001890  -0.03755  5.177e-05;
    -3.528	0	0	0	-0.2511	0	-10.06	0	0	0.1809	0	0	0	1.375	2.951	68.09	0	0	-1.361	0	0.003711	0	0	-0.02359	0.305	-3.765	-0.001535	0.07098	-0.0002577	0	0	0;
    0	0	0	0	-1.018	0	0	0	0	0	0	6.74E-05	0.001341	-2.404	41.12	-48.05	24.94	-0.06671	0	-0.1319	0.006818	0	-0.0001788	0.5172	-4.023	2.074	0	0	0	-0.0192	0.125	0;
    0	0	-8.306	1.212	0	0	0	0	0	0.0279	0	0.0006853	-0.0009314	5.253	7.626	-0.2889	0.06073	-0.3959	-0.07098	0.003821	0	0	0	-0.5006	-0.7376	0	0.04853	0.002956	0	0.01968	0.025	-0.001897];
   if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib>Ribc(3)
        ZL = sum(coef_ZL(4,:).*SS1);
    end
elseif zz/z0m<40 && zz/z0m>=10 && z0m/z0h>=10^7 && z0m/z0h<10^11 %region 5**************************
    coef_ribc = [0	0	0	0.04825	-0.01677	-0.004762	-0.0005212	0.0002768;
        0	0	0.08807	0.05219	-0.01822	-0.01245	-0.00085	0.0007516;
        0	0	0.1219	0.0583	-0.02373	-0.01224	-0.001081	0.0009539;
        0	0	0.1609	0.07789	-0.04617	-0.00736	-0.001399	0.001238;
        0.4437	0	0	0.1349	-0.1388	0.03347	-0.00119	0.001095];
    Ribc=nan(1,5);
    for i=1:5
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end
    coef_ZL =  [0	0	-2.541	25.22	-0.03201	0.1159	-0.5745	-0.8502	0.00208	-0.001668	0.03737	-0.00001828	-0.0003967	0.4298	-0.03339	0.05692	0	-0.0233	0	-0.3158	0	0.007595	0	0	0	1.793	0.00249	-0.05666	0	0	0.129	0;
        0	77.11	-201.2	386.1	-0.6831	0	-7.571	-8.978	0.07136	0	0.3442	0	-0.003421	0	-31.72	2.558	0	0	2.695	-2.449	-0.05044	0.05465	-0.00006869	0.3612	0	18.63	0.1236	-0.837	0.008316	-0.06987	0.8756	-0.01959;
        -207.7	880	-1550	2201	0	11.61	-96.51	0	0.5093	0.8873	0.2868	-0.001909	-0.004313	189.4	-543.8	324	-80.25	-5.403	14.95	-1.706	-0.4221	0.164	-0.00111	-53.83	89.42	34.6	2.704	-4.573	0.0718	4.95	-3.112	-0.3287;
        -587.1	2726	-3759	1605	-9.376	-4.513	70.55	-58.16	0.1711	-0.9373	1.132	-0.006865	-0.001126	286.9	-903.7	407.6	260.2	0	14.82	-26.07	0.01062	0.2099	0.0009863	-44.24	98.98	22.67	-0.01096	-1.67	-0.01056	2.138	-4.604	0.054;
        0	7.886	-0.5889	0	-0.4057	0	-0.5218	0	0.01745	-0.01349	0.01468	0	0	0	0	0	0	0	0.2908	0.1992	-0.003177	-0.00933	0	0.7321	2.304	-2.456	-0.09448	0.007636	0.002124	0	0	0;
        0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.08919	0	0	0	0	0	0	2.053	0.2534	-0.2585	-0.0338	0.004269	0	-0.3116	0.1241	0];
    if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib<=Ribc(4)
        ZL = sum(coef_ZL(4,:).*SS1);
    elseif Rib<=Ribc(5)
        ZL = sum(coef_ZL(5,:).*SS1);
    elseif Rib>Ribc(5)
        ZL = sum(coef_ZL(6,:).*SS1);
    end
elseif zz/z0m<=10^5 && zz/z0m>=40 && z0m/z0h>=10^7 && z0m/z0h<10^11 %region 6**************************
    coef_ribc = [0	0	0	0.05594	-0.03245	0.005037	-0.0003654	0.0001135;
        0.1945	0	0	0.03347	-0.02116	0.002301	0	0.0000892;
        0.4288	-0.1436	0.01635	0.03207	-0.01382	0.001571	0.00001326	-0.000006424];
    Ribc=nan(1,3);
    for i=1:3
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end
    coef_ZL =  [0	-7.864	0	0	-0.02699	0.7414	-1.114	0	0	0	0	0	0.0001281	0.244	1.743	4.749	11.28	0	-0.3093	-0.2208	0	0.003674	0	0.04168	0.4341	0.6518	-0.00208	0	0.00002895	0	-0.01307	0.00001425;
        0.4383	0	0	0	0	-4.81	5.094	-1.159	0.04547	0	-0.1233	-0.0005595	0.002459	0	0	44.44	0	0	0	-0.6068	-0.005459	0	0	0	0.9983	-2.874	-0.00152	0.01501	0.0003541	0.006587	-0.04253	-0.0003659;
        0	-41.74	177	-118.2	0	-4.006	-0.5102	0	0	0.0567	0.1868	0.002457	-0.006455	0	27.45	-17.37	-7.74	0	0	0.0117	-0.01576	0.02102	-0.00001975	-0.1563	-2.085	0.3443	0.03278	-0.0325	0.0005167	0.008163	0.0854	-0.001602;
        -6.744	8.8	-13.03	2.203	-0.1139	-0.06103	0.2406	-0.04635	0.01341	-0.002749	0.000005316	-0.0001434	0	6.511	6.369	-0.175	0.03419	-0.3147	-0.06781	-0.0002026	0.002444	0.0002616	-0.000005149	-0.6219	-0.598	0.002868	0.03359	0.003178	-0.0001423	0.02407	0.0188	-0.001167];
    if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib>Ribc(3)
        ZL = sum(coef_ZL(4,:).*SS1);
    end
elseif zz/z0m<40 && zz/z0m>=10 && z0m/z0h>=10^11 && z0m/z0h<=1.07*10^13  %%region 7**************************
    coef_ribc = [0	0	0	0.03681	-0.007664	-0.005619	-0.0001211	0;
        0	0	0	0.03655	0	-0.009977	-0.0002691	0.0001057;
        0	0	0	0.03822	0	-0.01036	-0.0003658	0.0001769;
        0	0	0	0.0384	0	-0.009243	-0.0003629	0.0001471;
        0	0	0	0.05616	-0.02275	0	-0.0005172	0.0002261;
        0	0	0	0.1472	-0.1144	0.02796	-0.001218	0.0005835];
    Ribc=nan(1,6);
    for i=1:6
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end
    coef_ZL =  [-1.412	6.658	-5.68	11.9	0.1285	-0.111	-0.2095	-0.3181	-0.004693	0.004467	0.01324	6.64E-05	-0.0002023	0.7122	-4.599	2.705	0	-0.04962	0.01147	-0.1621	0.001459	0.003514	-2.01E-05	0.003692	1.299	0.6516	0	-0.03414	2.84E-05	0.0006293	-0.02559	0;
        -4.502	40.44	37.42	0	0.3067	-5.444	2.053	0	0.05302	0	-0.01586	0	0	1.663	-28.1	-11.02	0	0.1172	1.979	-0.7285	-0.0293	0.01334	0	-0.4475	5.193	5.593	-0.009728	-0.3375	0.00347	0	0	0;
        -104.2	136.3	233.3	0	13.8	-37.21	10.33	0	-0.1157	0.5542	-0.2568	0	0	16.56	0	-114.4	0	-3.238	7.578	0	0	-0.06568	0	0	-0.1495	18.12	0.167	-0.6387	0.00428	0	0	0;
        542.4	-1845	2157	0	-3.691	3.33	-45.62	0	0.1434	0.4557	0.08936	0	0	-263.7	677.7	-644.2	0	4.44	-3.037	10.93	-0.08875	-0.1436	0	32.93	-56.58	53.14	-0.951	0	0.02119	0	0	0;
        178.4	158.8	-480.9	0	-31.49	47.56	-4.153	0	0.3998	-0.8692	0.2504	0	0	-37.94	-147.8	144.7	0	9.904	-7.914	-2.224	-0.1235	0.1631	0	0	23.51	-2.645	-0.7278	-0.1801	0.008599	0	0	0;
        0	0	0	0	0	0	0	0	0	0	0	0	0	0	20.56	-13.42	3.002	-0.5254	0	0	0	0	0.0002282	0	-2.349	0.628	0.2176	0.02067	-0.005396	-0.4148	0.02245	0.01163;
        0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0.06758	0	0.003671	0	-0.0006967	0	0	0.6983	-0.1455	0	0	-0.0004282	0	0	0];
    if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib<=Ribc(4)
        ZL = sum(coef_ZL(4,:).*SS1);
    elseif Rib<=Ribc(5)
        ZL = sum(coef_ZL(5,:).*SS1);
    elseif Rib<=Ribc(6)
        ZL = sum(coef_ZL(6,:).*SS1);
    elseif Rib>Ribc(6)
        ZL = sum(coef_ZL(7,:).*SS1);
    end
    
elseif zz/z0m<=10^5 && zz/z0m>=40 && z0m/z0h>=10^11 && z0m/z0h<=1.07*10^13  %%region 8**************************
    coef_ribc = [0	0	0	0.05139	-0.02991	0.004664	-0.0002135	0.00006535;
        0	0	0	0.04919	-0.0197	0.002011	-0.0003325	0.00007974;
        0.5775	-0.2236	0.03477	0.03805	-0.01617	0.00177	-0.00002191	0.00001067];
    Ribc=nan(1,3);
    for i=1:3
        Ribc(i) = sum(coef_ribc(i,:).*XX1);
    end
    coef_ZL =  [-3.13	5.26	-29.85	57.04	0.2176	-0.00898	-1.756	-1.663	-0.007271	0.0304	0.05349	0.00008978	-0.0006252	0.9846	-1.011	14.45	4.433	-0.05083	-0.2604	-0.2977	0.001361	0.00375	-0.00001464	-0.004659	0.6393	0	0	0	0	0.0008014	-0.01934	0;
        -49.55	97.14	352.5	-573.4	2.052	-21.41	13.12	20.82	0.1357	0.238	-0.7316	-0.003367	0.006023	14.57	0	0	-54.39	-0.8911	1.478	2.13	-0.000936	-0.04272	0.0001939	-1.165	0	-3.616	0.06747	0.01581	-0.0003126	0.03485	0	-0.001713;
        0	0	10.72	0	0	0	0	-1.354	-0.06227	0	0.08799	0.002359	-0.002387	-0.2492	19.79	-18.86	9.463	0	0	-0.3291	0	0.01369	-0.000241	0	-1.689	1.036	0.00194	-0.02897	0.0008316	0.01694	0.06734	-0.001447;
        0	0	0	0	0	0	0	0	0	-0.01477	-0.001292	0	0.0003921	0	0	-0.8522	0.1065	0	0.374	0.004036	0.002528	-0.006853	-0.00008747	0	-0.4307	0.01469	0.001642	0	0	0	0.01348	0];
    if Rib<=Ribc(1)
        ZL = sum(coef_ZL(1,:).*SS1);
    elseif Rib<=Ribc(2)
        ZL = sum(coef_ZL(2,:).*SS1);
    elseif Rib<=Ribc(3)
        ZL = sum(coef_ZL(3,:).*SS1);
    elseif Rib>Ribc(3)
        ZL = sum(coef_ZL(4,:).*SS1);
    end
end
ZL= ZL*s11;







