#!/bin/bash -ve

DTs=(3600 3600)

i=0
for num in 3 6; do
    for type in d ; do
        case=${num}x${num}_${type}
        mkdir $case
        cp -r blank/* $case
        mkdir $case/constant/polyMesh
        
        sed 's/DELTAT/'${DTs[$i]}'/g' blank/system/controlDict \
            > $case/system/controlDict
        sed 's/NX/'${num}'/g' blank/constant/blockMeshDict \
                > $case/constant/polyMesh/blockMeshDict
            
        # mesh generation
        blockMesh -case $case
        tanPoints -case $case
        polyDualPatch -case $case
        # take the dual an odd number of times again
        rm -r $case/constant/polyMesh $case/0/dualMesh/polyMesh/*Map
        mv $case/0/dualMesh/polyMesh $case/0
        polyDualPatch -case $case
        
        # calculate the mesh structures
        meshStructure -case $case '1(originalPatch)'
        meshStructure -case $case -region dualMesh '1(originalPatch)'

        # calculate the orthogonality and other mesh diagnostics
        orthogonality -case $case > $case/orthogLog
    
        # move the mesh to constant
        mv $case/0/dualMesh/* $case/constant/dualMesh
        rmdir $case/0/dualMesh
        mv $case/0/* $case/constant
        rmdir $case/0

        # plot both meshes, orthogonality and skewness (for coarse meshes)
        if [ "$num" -le 20 ] ; then
            plotPatchData -case $case orthogonality
            plotPatchData -case $case skewness -region dualMesh
            cat $case/constant/skewness.eps \
                >> $case/constant/orthogonality.eps
            rm $case/constant/skewness.eps
            gv $case/constant/orthogonality.eps &
        fi
        
        # create initial conditions (and plot if on a coarse mesh)
        setWilliSteady -case $case
        if [ "$num" -le 20 ] ; then
            plotPatchData -case $case hU
            gv $case/0/hU.eps &
        fi
        
        # setup different H operators for this run
        mkdir $case/save
        Hs=(asymmetric Dubos)
        for H in ${Hs[*]}; do
            subCase=$case/save/dt${DTs[$i]}_${H}H_CLUSTPV_CLUSTh
            mkdir $subCase
            ln -s ../../0 $subCase/0
            ln -s ../../constant $subCase/constant
            cp -r $case/system $subCase
            sed 's/TYPE/'$H'/g' blank/system/fvSolution \
                > $subCase/system/fvSolution
        done 
    done 
    let i=$i+1
done

